/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.combination;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.RecordSetCombination;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;
import org.datayoo.moql.util.StringFormater;

public abstract class AbstractRecordSetCombination
implements RecordSetCombination {
    protected ColumnsMetadata columnsMetadata;

    public AbstractRecordSetCombination(ColumnsMetadata columnsMetadata) {
        Validate.notNull((Object)columnsMetadata, (String)"Parameter 'columnsMetadata is null!");
        this.columnsMetadata = columnsMetadata;
    }

    @Override
    public RecordSet combine(RecordSet recordSet, RecordSet recordSet2) {
        boolean all;
        boolean bl = all = !this.columnsMetadata.isDistinct();
        if (this.columnsMetadata.getColumns().size() == 0) {
            return this.combine(all, recordSet, recordSet2);
        }
        return this.combine(all, this.columnsMetadata.getColumns(), recordSet, recordSet2);
    }

    protected abstract RecordSet combine(boolean var1, RecordSet var2, RecordSet var3);

    protected abstract RecordSet combine(boolean var1, List<ColumnMetadata> var2, RecordSet var3, RecordSet var4);

    protected boolean existRecord(Object[] record, List<Object[]> records, Comparator<Object[]> comparator) {
        for (Object[] rec : records) {
            if (comparator.compare(rec, record) != 0) continue;
            return true;
        }
        return false;
    }

    protected int[] createSequenceIndexes(int length) {
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    protected int[] getColumnsMapping(List<? extends ColumnDefinition> lColumns, List<ColumnDefinition> rColumns) {
        Validate.notEmpty(lColumns, (String)"Parameter 'lColumns' is empty!");
        Validate.notEmpty(rColumns, (String)"Parameter 'rColumns' is empty!");
        if (lColumns.size() > rColumns.size()) {
            throw new IllegalArgumentException("The right column list's size is less than the left one!");
        }
        int[] mappingIndexes = new int[lColumns.size()];
        int index = 0;
        int i = 0;
        for (ColumnDefinition columnDefinition : lColumns) {
            index = this.getColumnIndex(columnDefinition.getName(), rColumns);
            if (index == -1) {
                throw new IllegalArgumentException(StringFormater.format((String)"The right column list has no column '{}'!", (Object[])new Object[]{columnDefinition.getName()}));
            }
            mappingIndexes[i++] = index;
        }
        return mappingIndexes;
    }

    protected int getColumnIndex(String columnName, List<ColumnDefinition> columns) {
        int index = 0;
        for (ColumnDefinition column : columns) {
            if (column.getName().equals(columnName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected RecordSetDefinition createRecordSetDefinition() {
        ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>(this.columnsMetadata.getColumns().size());
        for (ColumnMetadata columnMetadata : this.columnsMetadata.getColumns()) {
            columnDefinitions.add((ColumnDefinition)columnMetadata);
        }
        return new RecordSetMetadata(columnDefinitions, null);
    }

    protected Date getStart(Date lStart, Date rStart) {
        if (lStart.getTime() > rStart.getTime()) {
            return rStart;
        }
        return lStart;
    }

    protected Date getEnd(Date lEnd, Date rEnd) {
        if (lEnd.getTime() < rEnd.getTime()) {
            return rEnd;
        }
        return lEnd;
    }
}

