/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.group;

import org.datayoo.moql.EntityMap;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.EntityOperator;

public class GroupRecord
implements EntityOperator<Object[]> {
    protected Object[] groupKeys;
    protected int[] groupColumnIndexes;
    protected Column[] columns;

    public GroupRecord(Object[] groupKeys, int[] groupColumnIndexes, Column[] columns) {
        this.groupKeys = groupKeys;
        this.groupColumnIndexes = groupColumnIndexes;
        this.columns = columns;
        if (groupKeys.length != groupColumnIndexes.length) {
            throw new IllegalArgumentException("The array of groupKeys and the groupColumnIndexes should be equal\uff01");
        }
    }

    @Override
    public Object[] getValue() {
        int i;
        Object[] record = new Object[this.columns.length];
        for (i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            record[i] = this.columns[i].getValue();
        }
        for (i = 0; i < this.groupColumnIndexes.length; ++i) {
            record[this.groupColumnIndexes[i]] = this.groupKeys[i];
        }
        return record;
    }

    @Override
    public void operate(EntityMap entityMap) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            this.columns[i].operate(entityMap);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            this.columns[i].clear();
        }
    }
}

