/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.join;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.DataSetMap;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.EntityMapImpl;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.Queryable;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.metadata.JoinMetadata;

public abstract class AbstractJoin
implements Join {
    protected JoinMetadata joinMetadata;
    protected Queryable<? extends Object> lQueryable;
    protected Queryable<? extends Object> rQueryable;
    protected String lTableName;
    protected String rTableName;
    protected Condition on;
    protected List<EntityMap> result;
    protected EntityMap nullEntityMap;

    public AbstractJoin(JoinMetadata joinMetadata, Queryable<? extends Object> lQueryable, Queryable<? extends Object> rQueryable, Condition on) {
        Validate.notNull((Object)joinMetadata, (String)"Parameter 'joinMetadata' is null!");
        Validate.notNull(lQueryable, (String)"Parameter 'lQueryable' is null!");
        Validate.notNull(rQueryable, (String)"Parameter 'rQueryable' is null!");
        this.joinMetadata = joinMetadata;
        this.lQueryable = lQueryable;
        this.rQueryable = rQueryable;
        this.on = on;
        this.lTableName = this.getTableName(lQueryable);
        this.rTableName = this.getTableName(rQueryable);
        this.initNullEntityMap();
    }

    protected String getTableName(Queryable<? extends Object> queryable) {
        if (queryable instanceof Table) {
            return ((Table)queryable).getTableMetadata().getName();
        }
        return null;
    }

    protected void initNullEntityMap() {
        this.nullEntityMap = new EntityMapImpl();
        if (this.lTableName == null) {
            this.nullEntityMap.putAll(((Join)this.lQueryable).getNullEntityMap());
        } else {
            this.nullEntityMap.putEntity(this.lTableName, null);
        }
        if (this.rTableName == null) {
            this.nullEntityMap.putAll(((Join)this.rQueryable).getNullEntityMap());
        } else {
            this.nullEntityMap.putEntity(this.rTableName, null);
        }
    }

    @Override
    public JoinMetadata getJoinMetadata() {
        return this.joinMetadata;
    }

    @Override
    public Queryable<? extends Object> getLeftQueryable() {
        return this.lQueryable;
    }

    @Override
    public Queryable<? extends Object> getRightQueryable() {
        return this.rQueryable;
    }

    @Override
    public Condition getOn() {
        return this.on;
    }

    @Override
    public void bind(DataSetMap dataSetMap) {
        this.lQueryable.bind(dataSetMap);
        this.rQueryable.bind(dataSetMap);
        this.result = this.join();
    }

    protected abstract List<EntityMap> join();

    @Override
    public Iterator<EntityMap> iterator() {
        return this.result.iterator();
    }

    @Override
    public EntityMap getNullEntityMap() {
        return this.nullEntityMap;
    }
}

