/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.data;

import org.apache.commons.lang.Validate;
import org.datayoo.moql.data.FeatureDecisionor;

public class GeneralFeatureDecisionor
implements FeatureDecisionor {
    public static final int DEFAULT_FREQUENCY = 1000;
    public static final double DEFAULT_RATIO = 0.2;
    protected int frequency = 1000;
    protected double ratio = 0.2;

    public GeneralFeatureDecisionor() {
    }

    public GeneralFeatureDecisionor(int frequency, double ratio) {
        Validate.isTrue((frequency > 0 ? 1 : 0) != 0, (String)"frequency should be bigger than 10!");
        Validate.isTrue((ratio > 0.0 && ratio < 1.0 ? 1 : 0) != 0, (String)"ratio should be bigger than 0 and less than 1!");
        this.frequency = frequency;
        this.ratio = ratio;
    }

    @Override
    public boolean isReady(int rowCount) {
        return rowCount % this.frequency == 0;
    }

    @Override
    public boolean isDimension(double ratioOfVR) {
        Validate.isTrue((this.ratio > 0.0 && this.ratio < 1.0 ? 1 : 0) != 0, (String)"ratioOfVR should be bigger than 0 and less than 1!");
        return !(ratioOfVR > this.ratio);
    }
}

