/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand;

import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperandType;
import org.datayoo.moql.operand.OperandSourceAware;

public abstract class AbstractOperand
implements Operand,
OperandSourceAware {
    protected String name;
    protected Object source;
    protected OperandType operandType = OperandType.UNKNOWN;
    protected boolean constantReturn = false;
    protected EntityMap entityMap;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public void setSource(Object source) {
        Validate.notNull((Object)source, (String)"source is null!");
        this.source = source;
    }

    @Override
    public OperandType getOperandType() {
        return this.operandType;
    }

    @Override
    public boolean isConstantReturn() {
        return this.constantReturn;
    }

    @Override
    public boolean booleanOperate(EntityMap entityMap) {
        return AbstractOperand.isTrue(this.operate(entityMap));
    }

    public static boolean isTrue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == Boolean.class) {
            return (Boolean)obj;
        }
        return true;
    }

    @Override
    public void increment(EntityMap entityMap) {
        Validate.notNull((Object)entityMap, (String)"entityMap is null!");
        this.entityMap = entityMap;
    }

    @Override
    public Object getValue() {
        return this.operate(this.entityMap);
    }

    @Override
    public void clear() {
        this.entityMap = null;
    }

    public String toString() {
        return this.name;
    }
}

