/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;

public class OperandsExpression
extends AbstractExpression {
    protected List<Operand> operands;

    public OperandsExpression(List<Operand> operands) {
        Validate.notEmpty(operands, (String)"operands is empty!");
        this.operands = operands;
        this.expressionType = ExpressionType.OPERANDS;
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        int i = 0;
        for (Operand operand : this.operands) {
            if (i++ != 0) {
                sbuf.append(',');
            }
            sbuf.append(operand.toString());
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return this.operands;
    }

    public List<Operand> getOperands() {
        return this.operands;
    }
}

