/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.arithmetic;

import org.apache.commons.lang.Validate;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.expression.OperationExpression;
import org.datayoo.moql.operand.expression.arithmetic.AddExpression;
import org.datayoo.moql.operand.expression.arithmetic.DivideExpression;
import org.datayoo.moql.operand.expression.arithmetic.ModularExpression;
import org.datayoo.moql.operand.expression.arithmetic.MultiplyExpression;
import org.datayoo.moql.operand.expression.arithmetic.SubtractExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseAndExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseOrExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseXorExpression;
import org.datayoo.moql.util.StringFormater;

public class ArithmeticExpressionFactory {
    public static OperationExpression createArithmeticExpression(String operator, Operand lOperand, Operand rOperand) {
        Validate.notEmpty((String)operator, (String)"Parameter 'operator' is empty!");
        Validate.notNull((Object)lOperand, (String)"Parameter 'lOperand' is null!");
        Validate.notNull((Object)rOperand, (String)"Parameter 'rOperand' is null!");
        if (operator.length() > 1) {
            throw new IllegalArgumentException(StringFormater.format((String)"Operator '' is invalid!", (Object[])new Object[]{operator}));
        }
        char op = operator.charAt(0);
        if (op == "+".charAt(0)) {
            return new AddExpression(lOperand, rOperand);
        }
        if (op == "-".charAt(0)) {
            return new SubtractExpression(lOperand, rOperand);
        }
        if (op == "*".charAt(0)) {
            return new MultiplyExpression(lOperand, rOperand);
        }
        if (op == "/".charAt(0)) {
            return new DivideExpression(lOperand, rOperand);
        }
        if (op == "%".charAt(0)) {
            return new ModularExpression(lOperand, rOperand);
        }
        if (op == "&".charAt(0)) {
            return new BitwiseAndExpression(lOperand, rOperand);
        }
        if (op == "|".charAt(0)) {
            return new BitwiseOrExpression(lOperand, rOperand);
        }
        if (op == "^".charAt(0)) {
            return new BitwiseXorExpression(lOperand, rOperand);
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsuppored operator '{}'!", (Object[])new Object[]{operator}));
    }
}

