/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.member;

import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.member.MemberExpression;
import org.datayoo.moql.operand.variable.Variable;
import org.datayoo.moql.util.StringFormater;

public class MemberVariableExpression
extends AbstractExpression
implements MemberExpression {
    protected Variable variable;
    protected Operand target;
    protected Class<?> clazz;
    protected Method method;
    protected String getter;
    protected Map<Class<?>, Method> methodCache = new HashMap();

    public MemberVariableExpression(Operand target, Variable variable) {
        this.expressionType = ExpressionType.MEMBER;
        Validate.notNull((Object)target, (String)"Parameter 'target' is null!");
        Validate.notNull((Object)variable, (String)"Parameter 'variable' is null!");
        this.target = target;
        this.variable = variable;
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.target.toString());
        sbuf.append('.');
        sbuf.append(this.variable.toString());
        return sbuf.toString();
    }

    protected String buildVariableGetter(boolean booleanType) {
        String name = this.variable.getName();
        StringBuffer sbuf = new StringBuffer();
        if (booleanType) {
            sbuf.append("is");
        } else {
            sbuf.append("get");
        }
        sbuf.append(Character.toUpperCase(name.charAt(0)));
        sbuf.append(name.substring(1));
        return sbuf.toString();
    }

    @Override
    public Operand getTarget() {
        return this.target;
    }

    @Override
    public Operand getMember() {
        return this.variable;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object o = this.target.operate(entityMap);
        if (o == null) {
            return null;
        }
        if (!(o instanceof OperandContextList)) {
            if (o instanceof Map) {
                return this.operate((Map)o);
            }
            if (o instanceof JsonObject) {
                return this.operate((JsonObject)o);
            }
            return this.operate(o);
        }
        OperandContextList ctxList = (OperandContextList)o;
        OperandContextArrayList resultList = new OperandContextArrayList(ctxList.size());
        for (Object obj : ctxList) {
            Object ret = this.operate(obj);
            resultList.add(ret);
        }
        return resultList;
    }

    protected Object operate(Map map) {
        String name = this.variable.getName();
        return map.get(name);
    }

    protected Object operate(JsonObject jsonObject) {
        String name = this.variable.getName();
        return jsonObject.get(name);
    }

    protected Object operate(Object o) {
        Method m = this.getMethod(o);
        try {
            return m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke field '{}' in class '{}' failed!", (Object[])new Object[]{this.variable.getName(), o.getClass().getName()}), e);
        }
    }

    protected Method getMethod(Object targetObject) {
        Class<?> objClazz = targetObject.getClass();
        if (this.clazz != null && objClazz.equals(this.clazz)) {
            return this.method;
        }
        Method m = this.methodCache.get(objClazz);
        if (m == null) {
            if (this.getter != null) {
                throw new OperateException(StringFormater.format((String)"Get field '{}' from class '{}' failed!", (Object[])new Object[]{this.variable.getName(), objClazz.getName()}));
            }
            try {
                this.getter = this.buildVariableGetter(false);
                m = objClazz.getMethod(this.getter, new Class[0]);
            }
            catch (Exception e) {
                this.getter = this.buildVariableGetter(true);
                try {
                    m = objClazz.getMethod(this.getter, new Class[0]);
                }
                catch (Exception e1) {
                    throw new OperateException(StringFormater.format((String)"Get field '{}' from class '{}' failed!", (Object[])new Object[]{this.variable.getName(), objClazz.getName()}), e1);
                }
            }
            this.methodCache.put(objClazz, m);
            this.clazz = objClazz;
            this.method = m;
        }
        return m;
    }
}

