/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.relation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.OperandsExpression;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.array.ArrayExpressionUtils;
import org.datayoo.moql.operand.expression.relation.AbstractRelationExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.operand.selector.ColumnSelectorOperand;
import org.datayoo.moql.util.CompareHelper;

public class InExpression
extends AbstractRelationExpression {
    protected List<Operand> rOperands;
    protected Set<Object> rValues;

    public InExpression(Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, RelationOperator.IN, lOperand, rOperand);
        if (rOperand instanceof ParenExpression) {
            this.rOperands = new ArrayList<Operand>();
            this.rOperands.add(((ParenExpression)rOperand).getOperand());
        } else if (rOperand instanceof OperandsExpression) {
            this.rOperands = ((OperandsExpression)rOperand).getOperands();
            if (this.rOperands.size() == 0) {
                throw new IllegalArgumentException("Parameter 'rOperand' has no operand!");
            }
            this.rValues = new HashSet<Object>();
            for (Operand operand : this.rOperands) {
                if (operand.isConstantReturn()) {
                    this.rValues.add(operand.getValue());
                    continue;
                }
                this.rValues = null;
                return;
            }
        } else if (rOperand instanceof ColumnSelectorOperand) {
            this.rOperands = new ArrayList<Operand>();
            this.rOperands.add(rOperand);
        } else {
            throw new IllegalArgumentException("Parameter 'rOperand' is not an OperandsExpression class!");
        }
    }

    @Override
    public boolean booleanOperate(EntityMap entityMap) {
        Object lValue = this.lOperand.operate(entityMap);
        if (lValue == null) {
            return false;
        }
        if (this.rValues != null) {
            return this.rValues.contains(lValue);
        }
        for (Operand rOperand : this.rOperands) {
            int ret = 0;
            Object rValue = rOperand.operate(entityMap);
            if (rValue == null) continue;
            if (ArrayExpressionUtils.isArray(rValue)) {
                for (Object obj : ArrayExpressionUtils.toOperandContextList(rValue)) {
                    ret = CompareHelper.compare(lValue, obj);
                    if (ret != 0) continue;
                    return true;
                }
                continue;
            }
            ret = CompareHelper.compare(lValue, rValue);
            if (ret != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return this.booleanOperate(entityMap);
    }

    public List<Operand> getrOperands() {
        return this.rOperands;
    }
}

