/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.antlr.OperandLexer;
import org.datayoo.moql.antlr.OperandParser;
import org.datayoo.moql.operand.OperandFactory;
import org.datayoo.moql.operand.PseudoOperand;
import org.datayoo.moql.operand.function.factory.FunctionFactory;
import org.datayoo.moql.operand.function.factory.FunctionFactoryImpl;
import org.datayoo.moql.util.StringFormater;

public class OperandFactoryImpl
implements OperandFactory {
    protected static FunctionFactory functionFactory = FunctionFactoryImpl.createFunctionFactory();
    protected static OperandFactory operandFactory;

    protected OperandFactoryImpl() {
    }

    public static synchronized OperandFactory createOperandFactory() {
        if (operandFactory == null) {
            operandFactory = new OperandFactoryImpl();
        }
        return operandFactory;
    }

    @Override
    public Operand createOperand(String operand) throws MoqlException {
        Validate.notEmpty((String)operand, (String)"Parameter 'operand' is empty!");
        Operand pseudoOperand = OperandFactoryImpl.createPseudoOperand(operand);
        if (pseudoOperand != null) {
            return pseudoOperand;
        }
        try {
            ANTLRInputStream is = new ANTLRInputStream((InputStream)new ByteArrayInputStream(operand.getBytes()));
            OperandLexer lexer = new OperandLexer((CharStream)is);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            OperandParser parser = new OperandParser((TokenStream)tokens);
            parser.setFunctionFactory(functionFactory);
            return parser.operand();
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format((String)"Create operand '{}' failed!", (Object[])new Object[]{operand}), (Throwable)e);
        }
    }

    protected static Operand createPseudoOperand(String operand) {
        if (operand.endsWith(".*")) {
            return new PseudoOperand(operand);
        }
        return null;
    }

    public static String registFunction(String name, String className) {
        return functionFactory.registFunction(name, className);
    }

    public static String unregistFunction(String name) {
        return functionFactory.unregistFunction(name);
    }
}

