/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function.decorator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.core.group.GroupKey;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.util.StringFormater;

public class RowTransposition
extends DecorateFunction {
    public static final String FUNCTION_NAME = "rowTransposition";
    protected String headerColumn;
    protected int headerColumnIndex;
    protected String[] valueColumns;
    protected int[] valueColumnIndexes;
    protected String valueColumnsName = "META";
    protected String[] groupColumns;
    protected int[] groupColumnIndexes;
    protected String[] transposedColumns;
    protected Map<String, Integer> transposedColumnMap = new HashMap<String, Integer>();
    protected GroupKey tempGroupKey = new GroupKey();

    public RowTransposition(List<Operand> parameters) {
        super(FUNCTION_NAME, parameters.size(), parameters);
        String groupColumnsString;
        String valueColumnsName;
        String valueColumnsString;
        if (parameters.size() == 0) {
            throw new IllegalArgumentException("Invalid function format! The format should be 'rowTranspose(headerColumn[,valueColumns,valueColumnsName,groupColumns])'");
        }
        this.headerColumn = (String)parameters.get(0).operate(null);
        Validate.notEmpty((String)this.headerColumn, (String)"rowColumn is empty!");
        if (parameters.size() > 1 && (valueColumnsString = (String)parameters.get(1).operate(null)) != null && valueColumnsString.length() > 0) {
            this.valueColumns = valueColumnsString.split(",");
        }
        if (parameters.size() > 2 && (valueColumnsName = (String)parameters.get(2).operate(null)) != null && valueColumnsName.length() > 0) {
            this.valueColumnsName = valueColumnsName;
        }
        if (parameters.size() > 3 && (groupColumnsString = (String)parameters.get(3).operate(null)) != null && groupColumnsString.length() > 0) {
            this.groupColumns = groupColumnsString.split(",");
        }
        this.checkInvalidate();
    }

    protected void checkInvalidate() {
        if (this.isGroupColumn(this.headerColumn)) {
            throw new IllegalArgumentException("The headerColumn is in groupColumns!");
        }
        if (this.isValueColumn(this.headerColumn)) {
            throw new IllegalArgumentException("The headerColumn is in valueColumns!");
        }
        if (this.groupColumns != null) {
            for (int i = 0; i < this.groupColumns.length; ++i) {
                if (!this.isValueColumn(this.groupColumns[i])) continue;
                throw new IllegalArgumentException("The headerColumn is in valueColumns!");
            }
        }
    }

    protected boolean isValueColumn(String columnName) {
        if (this.valueColumns == null) {
            return false;
        }
        for (int i = 0; i < this.valueColumns.length; ++i) {
            if (!this.valueColumns[i].equals(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        if (recordSet.getRecords().size() == 0) {
            return null;
        }
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.extractHeaderColumnIndex(recordSetDefinition);
        this.extractGroupColumnIndexes(recordSetDefinition);
        if (this.valueColumns == null) {
            this.extractValueColumns(recordSetDefinition);
        } else {
            this.extractValueColumnIndexes(recordSetDefinition);
        }
        this.extractTransposedColumns(recordSet);
        return this.transpose(recordSet);
    }

    protected RecordSet transpose(RecordSet recordSet) {
        LinkedList<TransposedRecord> transRecords = new LinkedList<TransposedRecord>();
        HashMap<GroupKey, TransposedRecord> cache = new HashMap<GroupKey, TransposedRecord>();
        TransposedRecord transRecord = null;
        for (Object[] record : recordSet.getRecords()) {
            if (this.groupColumns != null) {
                this.fillTempGroupKey(record);
                transRecord = (TransposedRecord)cache.get(this.tempGroupKey);
                if (transRecord == null) {
                    GroupKey groupKey = new GroupKey(this.tempGroupKey.getGroups());
                    transRecord = new TransposedRecord(groupKey);
                    transRecords.add(transRecord);
                    cache.put(groupKey, transRecord);
                }
            } else if (transRecords.size() == 0) {
                transRecord = new TransposedRecord(null);
                transRecords.add(transRecord);
            }
            transRecord.transpose(record);
        }
        return this.packRecordSet(recordSet.getStart(), recordSet.getEnd(), transRecords);
    }

    protected void extractHeaderColumnIndex(RecordSetDefinition recordSetDefinition) {
        this.headerColumnIndex = recordSetDefinition.getColumnIndex(this.headerColumn);
        if (this.headerColumnIndex == -1) {
            throw new IllegalArgumentException(StringFormater.format((String)"RecordSet has no column named '{}'", (Object[])new Object[]{this.headerColumn}));
        }
    }

    protected void extractGroupColumnIndexes(RecordSetDefinition recordSetDefinition) {
        if (this.groupColumns == null) {
            return;
        }
        this.groupColumnIndexes = new int[this.groupColumns.length];
        for (int i = 0; i < this.groupColumns.length; ++i) {
            int index = recordSetDefinition.getColumnIndex(this.groupColumns[i]);
            if (index == -1) {
                throw new IllegalArgumentException(StringFormater.format((String)"RecordSet has no column named '{}'", (Object[])new Object[]{this.groupColumns[i]}));
            }
            this.groupColumnIndexes[i] = index;
        }
    }

    protected void extractValueColumns(RecordSetDefinition recordSetDefinition) {
        ArrayList<String> columns = new ArrayList<String>(recordSetDefinition.getColumns().size());
        ArrayList<Integer> indexes = new ArrayList<Integer>(columns.size());
        int i = -1;
        for (ColumnDefinition columnDefinition : recordSetDefinition.getColumns()) {
            ++i;
            if (columnDefinition.getName().equals(this.headerColumn) || this.isGroupColumn(columnDefinition.getName())) continue;
            columns.add(columnDefinition.getName());
            indexes.add(i);
        }
        this.valueColumns = new String[columns.size()];
        columns.toArray(this.valueColumns);
        this.valueColumnIndexes = new int[indexes.size()];
        for (i = 0; i < this.valueColumns.length; ++i) {
            this.valueColumnIndexes[i] = (Integer)indexes.get(i);
        }
    }

    protected void extractValueColumnIndexes(RecordSetDefinition recordSetDefinition) {
        this.valueColumnIndexes = new int[this.valueColumns.length];
        for (int i = 0; i < this.valueColumns.length; ++i) {
            int index = recordSetDefinition.getColumnIndex(this.valueColumns[i]);
            if (index == -1) {
                throw new IllegalArgumentException(StringFormater.format((String)"RecordSet has no column named '{}'", (Object[])new Object[]{this.valueColumns[i]}));
            }
            this.valueColumnIndexes[i] = index;
        }
    }

    protected boolean isGroupColumn(String columnName) {
        if (this.groupColumns == null) {
            return false;
        }
        for (int i = 0; i < this.groupColumns.length; ++i) {
            if (!this.groupColumns[i].equals(columnName)) continue;
            return true;
        }
        return false;
    }

    protected void extractTransposedColumns(RecordSet recordSet) {
        LinkedList<String> values = new LinkedList<String>();
        for (Object[] record : recordSet.getRecords()) {
            Object obj = record[this.headerColumnIndex];
            String value = obj == null ? "NULL" : obj.toString();
            if (values.contains(value)) continue;
            values.add(value);
        }
        this.transposedColumns = new String[values.size()];
        values.toArray(this.transposedColumns);
        for (int i = 0; i < this.transposedColumns.length; ++i) {
            this.transposedColumnMap.put(this.transposedColumns[i], i);
        }
    }

    protected void fillTempGroupKey(Object[] record) {
        Object[] values = new Object[this.groupColumnIndexes.length];
        for (int i = 0; i < this.groupColumnIndexes.length; ++i) {
            values[i] = record[this.groupColumnIndexes[i]];
        }
        this.tempGroupKey.initialize(values);
    }

    protected RecordSet packRecordSet(Date start, Date stop, List<TransposedRecord> transRecords) {
        RecordSetMetadata recordSetMetadata = this.buildTransposedRecordSetMetadata(this.name);
        List<Object[]> records = this.toRecords(transRecords);
        return new RecordSetImpl(recordSetMetadata, start, stop, records);
    }

    protected RecordSetMetadata buildTransposedRecordSetMetadata(String name) {
        ColumnMetadata column;
        int i;
        LinkedList<ColumnDefinition> columns = new LinkedList<ColumnDefinition>();
        LinkedList<ColumnDefinition> groups = new LinkedList<ColumnDefinition>();
        if (this.groupColumns != null) {
            for (i = 0; i < this.groupColumns.length; ++i) {
                column = new ColumnMetadata(this.groupColumns[i], this.groupColumns[i]);
                groups.add((ColumnDefinition)column);
            }
        }
        columns.addAll(groups);
        if (this.valueColumns.length > 1) {
            ColumnMetadata column2 = new ColumnMetadata(this.valueColumnsName, this.valueColumnsName);
            columns.add((ColumnDefinition)column2);
        }
        for (i = 0; i < this.transposedColumns.length; ++i) {
            column = new ColumnMetadata(this.transposedColumns[i], this.transposedColumns[i]);
            columns.add((ColumnDefinition)column);
        }
        return new RecordSetMetadata(columns, groups);
    }

    protected List<Object[]> toRecords(List<TransposedRecord> transRecords) {
        LinkedList<Object[]> records = new LinkedList<Object[]>();
        for (TransposedRecord transRecord : transRecords) {
            records.addAll(transRecord.toRecords());
        }
        return records;
    }

    protected class TransposedRecord {
        protected GroupKey groupKey;
        protected Object[][] records;

        public TransposedRecord(GroupKey groupKey) {
            this.records = new Object[RowTransposition.this.valueColumns.length][];
            this.groupKey = groupKey;
            for (int i = 0; i < RowTransposition.this.valueColumns.length; ++i) {
                if (RowTransposition.this.valueColumns.length > 1) {
                    this.records[i] = new Object[RowTransposition.this.transposedColumns.length + 1];
                    this.records[i][0] = RowTransposition.this.valueColumns[i];
                    continue;
                }
                this.records[i] = new Object[RowTransposition.this.transposedColumns.length];
            }
        }

        public void transpose(Object[] record) {
            String transposedColumn = record[RowTransposition.this.headerColumnIndex].toString();
            int transposedColumnIndex = RowTransposition.this.transposedColumnMap.get(transposedColumn);
            int offset = RowTransposition.this.valueColumnIndexes.length > 1 ? 1 : 0;
            for (int i = 0; i < RowTransposition.this.valueColumnIndexes.length; ++i) {
                this.records[i][transposedColumnIndex + offset] = record[RowTransposition.this.valueColumnIndexes[i]];
            }
        }

        public List<Object[]> toRecords() {
            ArrayList<Object[]> recordList = new ArrayList<Object[]>(this.records.length);
            int recordSize = this.records[0].length;
            if (this.groupKey != null) {
                recordSize += this.groupKey.getGroups().length;
            }
            int offset = 0;
            for (int i = 0; i < this.records.length; ++i) {
                Object[] record = new Object[recordSize];
                if (this.groupKey != null) {
                    System.arraycopy(this.groupKey.getGroups(), 0, record, 0, this.groupKey.getGroups().length);
                    offset = this.groupKey.getGroups().length;
                }
                System.arraycopy(this.records[i], 0, record, offset, this.records[i].length);
                recordList.add(record);
            }
            return recordList;
        }
    }
}

