/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.util;

import org.apache.commons.lang.Validate;
import org.datayoo.moql.NumberConvertable;

public abstract class CompareHelper {
    public static int compare(Object lOperand, Object rOperand) {
        if (lOperand == null && rOperand == null) {
            return 0;
        }
        Validate.notNull((Object)lOperand, (String)"Parameter 'lOperand' is null!");
        Validate.notNull((Object)rOperand, (String)"Parameter 'rOperand' is null!");
        if (lOperand instanceof Number) {
            return CompareHelper.compareNumber((Number)lOperand, rOperand);
        }
        if (rOperand instanceof Number) {
            int ret = CompareHelper.compareNumber((Number)rOperand, lOperand);
            return CompareHelper.reverse(ret);
        }
        if (lOperand instanceof Comparable) {
            return CompareHelper.compare((Comparable)lOperand, rOperand);
        }
        if (rOperand instanceof Comparable) {
            int ret = CompareHelper.compare(rOperand, lOperand);
            return CompareHelper.reverse(ret);
        }
        throw new IllegalArgumentException("Parameter 'lOperand' and 'rOperand' can not compare each other!");
    }

    protected static int compare(Comparable lOperand, Object rOperand) {
        if (lOperand instanceof String) {
            return lOperand.compareTo(rOperand.toString());
        }
        return lOperand.compareTo(rOperand);
    }

    protected static int compareNumber(Number lOperand, Object rOperand) {
        double lValue = lOperand.doubleValue();
        double rValue = 0.0;
        if (rOperand instanceof Number) {
            rValue = ((Number)rOperand).doubleValue();
        } else if (rOperand instanceof String) {
            rValue = Double.valueOf((String)rOperand);
        } else if (rOperand instanceof NumberConvertable) {
            rValue = ((NumberConvertable)rOperand).toNumber().doubleValue();
        }
        return (int)(lValue - rValue);
    }

    protected static int reverse(int result) {
        if (result < 0) {
            return 1;
        }
        if (result > 0) {
            return -1;
        }
        return 0;
    }
}

