/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.xml;

import org.datayoo.moql.util.StringFormater;
import org.datayoo.moql.xml.XmlAccessException;
import org.datayoo.moql.xml.XmlElementFormater;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class AbstractElementFormater<T>
implements XmlElementFormater<T> {
    protected String[] supportElementNames = new String[0];

    @Override
    public boolean canImport(Element element) {
        for (int i = 0; i < this.supportElementNames.length; ++i) {
            if (!this.supportElementNames[i].equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    protected Element createRootElement(Element element, String rootName) {
        Element elRoot = null;
        if (element != null) {
            elRoot = element.addElement(rootName);
        } else {
            Document doc = DocumentHelper.createDocument();
            elRoot = doc.addElement(rootName);
        }
        return elRoot;
    }

    @Override
    public String[] getSupportElementNames() {
        return this.supportElementNames;
    }

    protected String getAttribute(Element element, String attribute, boolean option) throws XmlAccessException {
        Attribute attr = element.attribute(attribute);
        if (attr != null) {
            return attr.getValue();
        }
        if (option) {
            return null;
        }
        throw new XmlAccessException(StringFormater.format("There is no attribute '{}' in element '{}'!", attribute, element.getName()));
    }

    protected String getElementText(Element element, String textElement, boolean option) throws XmlAccessException {
        Element el = element.element(textElement);
        if (el != null) {
            return el.getTextTrim();
        }
        if (option) {
            return null;
        }
        throw new XmlAccessException(StringFormater.format("There is no element '{}' in element '{}'!", textElement, element.getName()));
    }
}

