/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbVisitor;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WkbDecodeException;

class WkbDialect {
    public static final int WKB_POINT = 1;
    public static final int WKB_LINESTRING = 2;
    public static final int WKB_POLYGON = 3;
    public static final int WKB_MULTIPOINT = 4;
    public static final int WKB_MULTILINESTRING = 5;
    public static final int WKB_MULTIPOLYGON = 6;
    public static final int WKB_GEOMETRYCOLLECTION = 7;

    WkbDialect() {
    }

    GeometryType parseType(long tpe) {
        switch ((int)tpe) {
            case 1: {
                return GeometryType.POINT;
            }
            case 2: {
                return GeometryType.LINESTRING;
            }
            case 3: {
                return GeometryType.POLYGON;
            }
            case 4: {
                return GeometryType.MULTIPOINT;
            }
            case 6: {
                return GeometryType.MULTIPOLYGON;
            }
            case 5: {
                return GeometryType.MULTILINESTRING;
            }
            case 7: {
                return GeometryType.GEOMETRYCOLLECTION;
            }
        }
        throw new WkbDecodeException("Unsupported WKB type code: " + tpe);
    }

    boolean hasZ(long tpe) {
        return false;
    }

    boolean hasM(long tpe) {
        return false;
    }

    <P extends Position> BaseWkbVisitor<P> mkVisitor(Geometry<P> geom, ByteOrder bo) {
        ByteBuffer buffer = this.mkByteBuffer(geom, bo);
        return new BaseWkbVisitor(buffer, this);
    }

    protected <P extends Position> ByteBuffer mkByteBuffer(Geometry<P> geom, ByteOrder bo) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateSize(geom, true));
        if (bo != null) {
            buffer.setByteOrder(bo);
        }
        return buffer;
    }

    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean topLevel) {
        int size = 5;
        if (topLevel) {
            size += this.extraHeaderSize(geom);
        }
        if (geom.isEmpty()) {
            return size + this.sizeEmptyGeometry(geom);
        }
        return size + this.geometrySize(geom);
    }

    protected <P extends Position> int extraHeaderSize(Geometry<P> geom) {
        return 0;
    }

    protected <P extends Position> int sizeEmptyGeometry(Geometry<P> geometry) {
        if (geometry.getGeometryType() == GeometryType.POINT) {
            return this.emptyPointAsNaN() ? this.getPositionSize(geometry) : 4;
        }
        return 4;
    }

    protected <P extends Position> int geometrySize(Geometry<P> geom) {
        if (geom instanceof AbstractGeometryCollection) {
            return this.sizeOfGeometryCollection((AbstractGeometryCollection)geom);
        }
        if (geom instanceof Polygon) {
            return this.getPolygonSize((Polygon)geom);
        }
        if (geom instanceof Point) {
            return this.getPositionSize(geom);
        }
        int numPoints = 4;
        return numPoints + this.getPositionSize(geom) * geom.getNumPositions();
    }

    protected <P extends Position> int getPositionSize(Geometry<P> geom) {
        return geom.getCoordinateDimension() * 8;
    }

    protected <P extends Position> int getPolygonSize(Polygon<P> geom) {
        int size = 4;
        size += geom.isEmpty() ? 0 : 4 * (geom.getNumInteriorRing() + 1);
        return size += this.getPositionSize(geom) * geom.getNumPositions();
    }

    protected <P extends Position, G extends Geometry<P>> int sizeOfGeometryCollection(AbstractGeometryCollection<P, G> collection) {
        int size = 4;
        for (Geometry g : collection) {
            size += this.calculateSize(g, false);
        }
        return size;
    }

    boolean emptyPointAsNaN() {
        return true;
    }

    protected <P extends Position> Long geometryTypeCode(Geometry<P> geometry) {
        return this.wkbTypeCode(geometry);
    }

    private <P extends Position> int wkbTypeCode(Geometry<P> geometry) {
        switch (geometry.getGeometryType()) {
            case POINT: {
                return 1;
            }
            case LINESTRING: 
            case LINEARRING: {
                return 2;
            }
            case POLYGON: {
                return 3;
            }
            case MULTIPOINT: {
                return 4;
            }
            case MULTILINESTRING: {
                return 5;
            }
            case MULTIPOLYGON: {
                return 6;
            }
            case GEOMETRYCOLLECTION: {
                return 7;
            }
        }
        throw new UnsupportedConversionException(String.format("Can't convert geometries of type %s", geometry.getClass().getCanonicalName()));
    }
}

