/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.G2D;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.EllipsoidalAxis;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem2DM;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem3D;
import org.geolatte.geom.crs.EllipsoidalHeightCSAXis;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class EllipsoidalCoordinateSystem2D
extends CoordinateSystem<G2D> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1);

    public EllipsoidalCoordinateSystem2D(EllipsoidalAxis first, EllipsoidalAxis second) {
        super(first, second);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0 and 1 axes");
        }
    }

    @Override
    public Class<G2D> getPositionClass() {
        return G2D.class;
    }

    @Override
    public CoordinateSystem<? extends G2D> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        CoordinateSystemAxis axis = coordinateSystem.getAxis();
        return this.extend(axis);
    }

    @Override
    public CoordinateSystem<? extends G2D> extend(CoordinateSystemAxis axis) {
        if (axis instanceof EllipsoidalHeightCSAXis) {
            return new EllipsoidalCoordinateSystem3D((EllipsoidalAxis)this.getAxis(0), (EllipsoidalAxis)this.getAxis(1), (EllipsoidalHeightCSAXis)axis);
        }
        if (axis instanceof MeasureStraightLineAxis) {
            return new EllipsoidalCoordinateSystem2DM((EllipsoidalAxis)this.getAxis(0), (EllipsoidalAxis)this.getAxis(1), (MeasureStraightLineAxis)axis);
        }
        if (axis instanceof VerticalStraightLineAxis) {
            return new EllipsoidalCoordinateSystem3D((EllipsoidalAxis)this.getAxis(0), (EllipsoidalAxis)this.getAxis(1), (VerticalStraightLineAxis)axis);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasZ() {
        return false;
    }

    @Override
    public boolean hasM() {
        return false;
    }
}

