/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.G3DM;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.EllipsoidalAxis;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.StraightLineAxis;

public class EllipsoidalCoordinateSystem3DM
extends CoordinateSystem<G3DM> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1, 2, 3);

    public EllipsoidalCoordinateSystem3DM(EllipsoidalAxis first, EllipsoidalAxis second, StraightLineAxis heightAxis, MeasureStraightLineAxis other) {
        super(first, second, heightAxis, other);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0, 1, 2 and 3 axes");
        }
    }

    @Override
    public Class<G3DM> getPositionClass() {
        return G3DM.class;
    }

    @Override
    public CoordinateSystem<?> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CoordinateSystem<?> extend(CoordinateSystemAxis axis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasZ() {
        return true;
    }

    @Override
    public boolean hasM() {
        return true;
    }
}

