/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.crs.OneDimensionCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.CoordinateOperation;

class ExtendedCoordinateOperation
implements CoordinateOperation {
    private final CoordinateOperation baseOp;
    private OneDimensionCoordinateReferenceSystem source;
    private OneDimensionCoordinateReferenceSystem target;
    private final int inCoDim;
    private final int outCoDim;
    double convFactor = 1.0;

    ExtendedCoordinateOperation(CoordinateOperation baseOp, OneDimensionCoordinateReferenceSystem source, OneDimensionCoordinateReferenceSystem target) {
        this.baseOp = baseOp;
        this.source = source;
        this.target = target;
        this.inCoDim = source != null ? baseOp.inCoordinateDimension() + 1 : baseOp.inCoordinateDimension();
        int n = this.outCoDim = target != null ? baseOp.outCoordinateDimension() + 1 : baseOp.outCoordinateDimension();
        if (source != null && target != null) {
            this.convFactor = source.getUnit().getConversionFactor() / target.getUnit().getConversionFactor();
        }
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public int inCoordinateDimension() {
        return this.inCoDim;
    }

    @Override
    public int outCoordinateDimension() {
        return this.outCoDim;
    }

    @Override
    public void forward(double[] inCoordinate, double[] outCoordinate) {
        this.baseOp.forward(inCoordinate, outCoordinate);
        if (this.source == null && this.target != null) {
            outCoordinate[this.outCoDim - 1] = 0.0;
        }
        if (this.source != null && this.target != null) {
            outCoordinate[this.outCoDim - 1] = this.convFactor * inCoordinate[this.inCoDim - 1];
        }
    }

    @Override
    public void reverse(double[] inCoordinate, double[] outCoordinate) {
        this.baseOp.reverse(inCoordinate, outCoordinate);
        if (this.target == null && this.source != null) {
            outCoordinate[this.inCoDim - 1] = 0.0;
        }
        if (this.source != null && this.target != null) {
            outCoordinate[this.inCoDim - 1] = inCoordinate[this.outCoDim - 1] / this.convFactor;
        }
    }
}

