/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class RenameHandler {
    public static final RenameHandler INSTANCE = new RenameHandler();
    private final ConcurrentHashMap<String, Class<?>> typeRenames = new ConcurrentHashMap(16, 0.75f, 2);
    private final ConcurrentHashMap<Class<?>, Map<String, Enum<?>>> enumRenames = new ConcurrentHashMap(16, 0.75f, 2);

    public static RenameHandler create() {
        return new RenameHandler();
    }

    private RenameHandler() {
    }

    public void renamedType(String oldName, Class<?> currentValue) {
        if (oldName == null) {
            throw new IllegalArgumentException("oldName must not be null");
        }
        if (currentValue == null) {
            throw new IllegalArgumentException("currentValue must not be null");
        }
        this.typeRenames.put(oldName, currentValue);
    }

    public Map<String, Class<?>> getTypeRenames() {
        return new HashMap(this.typeRenames);
    }

    public Class<?> lookupType(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Class<?> type = this.typeRenames.get(name);
        if (type == null) {
            type = this.loadType(name);
        }
        return type;
    }

    private Class<?> loadType(String fullName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader != null ? loader.loadClass(fullName) : Class.forName(fullName);
    }

    public void renamedEnum(String oldName, Enum<?> currentValue) {
        if (oldName == null) {
            throw new IllegalArgumentException("oldName must not be null");
        }
        if (currentValue == null) {
            throw new IllegalArgumentException("currentValue must not be null");
        }
        Class<?> enumType = currentValue.getDeclaringClass();
        Map<String, Enum<?>> perClass = this.enumRenames.get(enumType);
        if (perClass == null) {
            this.enumRenames.putIfAbsent(enumType, new ConcurrentHashMap(16, 0.75f, 2));
            perClass = this.enumRenames.get(enumType);
        }
        perClass.put(oldName, currentValue);
    }

    public Set<Class<?>> getEnumTypesWithRenames() {
        return new HashSet(this.enumRenames.keySet());
    }

    public Map<String, Enum<?>> getEnumRenames(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        Map<String, Enum<?>> map = this.enumRenames.get(type);
        if (map == null) {
            return new HashMap();
        }
        return new HashMap(map);
    }

    public <T extends Enum<T>> T lookupEnum(Class<T> type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map<String, Enum<?>> map = this.getEnumRenames(type);
        Enum<?> value = map.get(name);
        if (value != null) {
            return (T)((Enum)type.cast(value));
        }
        return Enum.valueOf(type, name);
    }

    public String toString() {
        return "RenamedTypes" + this.typeRenames + ",RenamedEnumConstants" + this.enumRenames;
    }
}

