/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.lease;

import java.util.concurrent.TimeUnit;
import org.simpleframework.common.lease.Cleaner;
import org.simpleframework.common.lease.Contract;
import org.simpleframework.common.lease.ContractController;
import org.simpleframework.common.lease.LeaseCleaner;
import org.simpleframework.common.lease.LeaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContractMaintainer<T>
implements ContractController<T> {
    private final LeaseCleaner<T> queue;

    public ContractMaintainer(Cleaner<T> cleaner) {
        this.queue = new LeaseCleaner<T>(cleaner);
    }

    @Override
    public synchronized void issue(Contract<T> contract) {
        this.queue.issue(contract);
    }

    @Override
    public synchronized void renew(Contract<T> contract) {
        boolean active = this.queue.revoke(contract);
        if (!active) {
            throw new LeaseException("Lease has expired for " + contract);
        }
        this.queue.issue(contract);
    }

    @Override
    public synchronized void cancel(Contract<T> contract) {
        boolean active = this.queue.revoke(contract);
        if (!active) {
            throw new LeaseException("Lease has expired for " + contract);
        }
        contract.setDelay(0L, TimeUnit.MILLISECONDS);
        this.queue.issue(contract);
    }

    @Override
    public synchronized void close() {
        this.queue.close();
    }
}

