/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;

public class ChainedPersistenceExceptionTranslator
implements PersistenceExceptionTranslator {
    private final List delegates = new ArrayList(4);

    public final void addDelegate(PersistenceExceptionTranslator pet) {
        Assert.notNull(pet, "PersistenceExceptionTranslator must not be null");
        this.delegates.add(pet);
    }

    public final PersistenceExceptionTranslator[] getDelegates() {
        return this.delegates.toArray(new PersistenceExceptionTranslator[this.delegates.size()]);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        DataAccessException translatedDex = null;
        Iterator it = this.delegates.iterator();
        while (translatedDex == null && it.hasNext()) {
            PersistenceExceptionTranslator pet = (PersistenceExceptionTranslator)it.next();
            translatedDex = pet.translateExceptionIfPossible(ex);
        }
        return translatedDex;
    }
}

