/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaXsdItemNrPriceResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlibabaXsdItemNrPriceRequest
extends BaseTaobaoRequest<AlibabaXsdItemNrPriceResponse> {
    private Long itemId;
    private Long price;
    private Long shopId;
    private String skuDetails;

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getPrice() {
        return this.price;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setSkuDetails(String skuDetails) {
        this.skuDetails = skuDetails;
    }

    public void setSkuDetails(List<StoreItemPriceSkuDetail> skuDetails) {
        this.skuDetails = new JSONWriter(false, true).write(skuDetails);
    }

    public String getSkuDetails() {
        return this.skuDetails;
    }

    @Override
    public String getApiMethodName() {
        return "alibaba.xsd.item.nr.price";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("price", (Object)this.price);
        txtParams.put("shop_id", (Object)this.shopId);
        txtParams.put("sku_details", this.skuDetails);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<AlibabaXsdItemNrPriceResponse> getResponseClass() {
        return AlibabaXsdItemNrPriceResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkNotEmpty(this.shopId, "shopId");
    }

    public static class StoreItemPriceSkuDetail
    extends TaobaoObject {
        private static final long serialVersionUID = 1323829545485713242L;
        @ApiField(value="price")
        private Long price;
        @ApiField(value="sku_id")
        private Long skuId;

        public Long getPrice() {
            return this.price;
        }

        public void setPrice(Long price) {
            this.price = price;
        }

        public Long getSkuId() {
            return this.skuId;
        }

        public void setSkuId(Long skuId) {
            this.skuId = skuId;
        }
    }
}

