/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.RefundSmartNegotiationSubmitResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefundSmartNegotiationSubmitRequest
extends BaseTaobaoRequest<RefundSmartNegotiationSubmitResponse> {
    private String negotiationFactors;
    private String negotiationType;
    private Long refundId;

    public void setNegotiationFactors(String negotiationFactors) {
        this.negotiationFactors = negotiationFactors;
    }

    public void setNegotiationFactors(NegotiationFactors negotiationFactors) {
        this.negotiationFactors = new JSONWriter(false, true).write(negotiationFactors);
    }

    public String getNegotiationFactors() {
        return this.negotiationFactors;
    }

    public void setNegotiationType(String negotiationType) {
        this.negotiationType = negotiationType;
    }

    public String getNegotiationType() {
        return this.negotiationType;
    }

    public void setRefundId(Long refundId) {
        this.refundId = refundId;
    }

    public Long getRefundId() {
        return this.refundId;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.refund.smart.negotiation.submit";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("negotiation_factors", this.negotiationFactors);
        txtParams.put("negotiation_type", this.negotiationType);
        txtParams.put("refund_id", (Object)this.refundId);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<RefundSmartNegotiationSubmitResponse> getResponseClass() {
        return RefundSmartNegotiationSubmitResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.negotiationType, "negotiationType");
        RequestCheckUtils.checkNotEmpty(this.refundId, "refundId");
    }

    public static class NegotiationFactors
    extends TaobaoObject {
        private static final long serialVersionUID = 4119453298557424839L;
        @ApiField(value="negotiation_script")
        private String negotiationScript;
        @ApiField(value="refund_amount")
        private Long refundAmount;
        @ApiField(value="return_address")
        private Long returnAddress;

        public String getNegotiationScript() {
            return this.negotiationScript;
        }

        public void setNegotiationScript(String negotiationScript) {
            this.negotiationScript = negotiationScript;
        }

        public Long getRefundAmount() {
            return this.refundAmount;
        }

        public void setRefundAmount(Long refundAmount) {
            this.refundAmount = refundAmount;
        }

        public Long getReturnAddress() {
            return this.returnAddress;
        }

        public void setReturnAddress(Long returnAddress) {
            this.returnAddress = returnAddress;
        }
    }
}

