/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.danga.MemCached.LineInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufArrayInputStream
extends InputStream
implements LineInputStream {
    private ByteBuffer[] bufs;
    private int currentBuf = 0;

    public ByteBufArrayInputStream(List<ByteBuffer> list) throws Exception {
        this(list.toArray(new ByteBuffer[0]));
    }

    public ByteBufArrayInputStream(ByteBuffer[] byteBufferArray) throws Exception {
        if (byteBufferArray == null || byteBufferArray.length == 0) {
            throw new Exception("buffer is empty");
        }
        this.bufs = byteBufferArray;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            byteBuffer.flip();
        }
    }

    @Override
    public int read() {
        do {
            if (this.bufs[this.currentBuf].hasRemaining()) {
                return this.bufs[this.currentBuf].get() & 0xFF;
            }
            ++this.currentBuf;
        } while (this.currentBuf < this.bufs.length);
        --this.currentBuf;
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        do {
            if (this.bufs[this.currentBuf].hasRemaining()) {
                int n4 = Math.min(this.bufs[this.currentBuf].remaining(), n2 - n3);
                this.bufs[this.currentBuf].get(byArray, n3, n4);
                n3 += n4;
            }
            ++this.currentBuf;
        } while (this.currentBuf < this.bufs.length && n3 < n2);
        --this.currentBuf;
        if (n3 > 0 || n3 == 0 && n2 == 0) {
            return n3 - n;
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        byte[] byArray = new byte[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        while (this.read(byArray, 0, 1) != -1) {
            if (byArray[0] == 13) {
                bl = true;
            } else if (bl) {
                if (byArray[0] == 10) break;
                bl = false;
            }
            byteArrayOutputStream.write(byArray, 0, 1);
        }
        if (byteArrayOutputStream == null || byteArrayOutputStream.size() <= 0) {
            throw new IOException("++++ Stream appears to be dead, so closing it down");
        }
        return byteArrayOutputStream.toString().trim();
    }

    @Override
    public void clearEOL() throws IOException {
        byte[] byArray = new byte[1];
        boolean bl = false;
        while (this.read(byArray, 0, 1) != -1) {
            if (byArray[0] == 13) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (byArray[0] == 10) break;
            bl = false;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ByteBufArrayIS: ");
        stringBuilder.append(this.bufs.length).append(" bufs of sizes: \n");
        for (int i = 0; i < this.bufs.length; ++i) {
            stringBuilder.append("                                        ").append(i).append(":  ").append(this.bufs[i]).append("\n");
        }
        return stringBuilder.toString();
    }
}

