/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.SchoonerSockIO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;

public final class SockOutputStream
extends OutputStream {
    private int count = 0;
    private SchoonerSockIO sock;

    public final int getCount() {
        return this.count;
    }

    public final void resetCount() {
        this.count = 0;
    }

    public final SchoonerSockIO getSock() {
        return this.sock;
    }

    public SockOutputStream(SchoonerSockIO schoonerSockIO) {
        this.sock = schoonerSockIO;
    }

    private final void writeToChannel() throws IOException {
        this.sock.writeBuf.flip();
        this.sock.getChannel().write(this.sock.writeBuf);
        this.sock.writeBuf.clear();
    }

    public final void write(int n) throws IOException {
        try {
            this.sock.writeBuf.put((byte)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            this.writeToChannel();
            this.sock.writeBuf.put((byte)n);
        }
        ++this.count;
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.sock.writeBuf.remaining() >= n2) {
            this.sock.writeBuf.put(byArray, n, n2);
        } else {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while ((n5 = n2 - n3) > 0) {
                n4 = this.sock.writeBuf.remaining();
                int n6 = n4 = n4 < n5 ? n4 : n5;
                if (n4 == 0) {
                    this.writeToChannel();
                } else {
                    this.sock.writeBuf.put(byArray, n, n4);
                }
                n3 += n4;
            }
        }
        this.count += n2;
    }
}

