/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.codegen;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectReaderGen {
    final Class<?> objectClass;
    final String packageName;
    final String className;
    BeanInfo beanInfo;
    private final FieldReader[] fieldReaderArray;
    private final long[] hashCodes;
    private final short[] mapping;
    Map<Integer, List<Long>> map = new LinkedHashMap<Integer, List<Long>>();
    Map<Long, Member> members = new HashMap<Long, Member>();
    Map<Long, Type> fieldTypes = new HashMap<Long, Type>();
    Appendable out;

    public ObjectReaderGen(Class<?> objectClass) {
        this(objectClass, System.out);
    }

    public ObjectReaderGen(Class<?> objectClass, Appendable out) {
        int i;
        this.out = out;
        this.objectClass = objectClass;
        this.packageName = objectClass.getPackage().getName();
        this.className = objectClass.getSimpleName() + "_ObjectReader";
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        this.beanInfo = new BeanInfo();
        for (ObjectReaderModule module : provider.getModules()) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getBeanInfo(this.beanInfo, objectClass);
        }
        ObjectReaderCreator creator = provider.getCreator();
        this.fieldReaderArray = creator.createFieldReaders(objectClass);
        Arrays.sort(this.fieldReaderArray);
        long[] hashCodes = new long[this.fieldReaderArray.length];
        for (i = 0; i < this.fieldReaderArray.length; ++i) {
            long hashCode64;
            FieldReader fieldReader = this.fieldReaderArray[i];
            String fieldName = fieldReader.getFieldName();
            hashCodes[i] = hashCode64 = Fnv.hashCode64(fieldName);
            this.fieldTypes.put(hashCode64, fieldReader.getFieldType());
            Field field = fieldReader.getField();
            Method method = fieldReader.getMethod();
            if (field != null) {
                this.members.put(hashCode64, field);
                continue;
            }
            if (method != null) {
                this.members.put(hashCode64, method);
                continue;
            }
            throw new JSONException("TODO");
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            long hashCode = hashCodes[i];
            int index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
        for (i = 0; i < this.hashCodes.length; ++i) {
            long hashCode64 = this.hashCodes[i];
            int hashCode32 = (int)(hashCode64 ^ hashCode64 >>> 32);
            List<Long> hashCode64List = this.map.get(hashCode32);
            if (hashCode64List == null) {
                hashCode64List = new ArrayList<Long>();
                this.map.put(hashCode32, hashCode64List);
            }
            hashCode64List.add(hashCode64);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void gen() {
        FieldReader fieldReader;
        int i;
        this.println("package " + this.packageName + ";");
        this.println();
        this.println("import java.util.Arrays;");
        this.println("import com.alibaba.fastjson2.JSONReader;");
        this.println("import com.alibaba.fastjson2.reader.FieldReader;");
        this.println("import com.alibaba.fastjson2.reader.ObjectReader;");
        this.println("import com.alibaba.fastjson2.reader.FieldReaderObject;");
        this.println("import com.alibaba.fastjson2.JSONException;");
        this.println("import " + this.objectClass.getName().replace('$', '.') + ";");
        this.println();
        this.println("public class " + this.className + " implements ObjectReader {");
        this.println();
        this.println("\tprivate FieldReader[] fieldReaders;");
        this.println();
        for (i = 0; i < this.fieldReaderArray.length; ++i) {
            fieldReader = this.fieldReaderArray[i];
            this.println("\tprivate FieldReader fieldReader" + i + "; // " + fieldReader.getFieldName());
        }
        for (i = 0; i < this.fieldReaderArray.length; ++i) {
            fieldReader = this.fieldReaderArray[i];
            if (!(fieldReader instanceof FieldReaderObject)) continue;
            this.println("\tprivate ObjectReader fieldObjectReader" + i + "; // " + fieldReader.getFieldName());
        }
        for (i = 0; i < this.fieldReaderArray.length; ++i) {
            fieldReader = this.fieldReaderArray[i];
            if (!(fieldReader instanceof FieldReaderList)) continue;
            this.println("\tprivate ObjectReader fieldListItemReader" + i + "; // " + fieldReader.getFieldName() + ".item");
        }
        this.println();
        this.gen_constructor();
        this.println();
        this.gen_createInstance();
        this.println();
        this.gen_readJSONBObject();
        this.println();
        this.genReadObject();
        this.println();
        this.genReadArrayMappingObject();
        this.println();
        this.gen_getFieldReader();
        this.println("}");
    }

    private void gen_constructor() {
        this.println("\tpublic " + this.className + "(FieldReader[] fieldReaders) {");
        this.println("\t\tthis.fieldReaders = Arrays.copyOf(fieldReaders, fieldReaders.length);");
        this.println("\t\tArrays.sort(this.fieldReaders);");
        this.println();
        for (int i = 0; i < this.fieldReaderArray.length; ++i) {
            this.println("\t\tthis.fieldReader" + i + " = this.fieldReaders[" + i + "];");
        }
        this.println("\t}");
    }

    private void gen_createInstance() {
        this.println("\t@Override");
        this.println("\tpublic Object createInstance() {");
        this.println("\t\treturn new " + this.objectClass.getSimpleName() + "();");
        this.println("\t}");
    }

    private void gen_readJSONBObject() {
        this.println("\t@Override");
        this.println("\tpublic Object readJSONBObject(JSONReader jsonReader, long features) {");
        this.println("\t\tjsonReader.nextIfObjectStart();");
        this.println("\t\t" + this.objectClass.getSimpleName() + " object = new " + this.objectClass.getSimpleName() + "();");
        this.println("\t\tfor (;;) {");
        this.println("\t\t\tif (jsonReader.nextIfObjectEnd()) {");
        this.println("\t\t\t\tbreak;");
        this.println("\t\t\t}");
        this.println("\t\t\tlong hashCode64 = jsonReader.readFieldNameHashCode();");
        this.gen_readObject_for_body(1, true);
        this.println("\t\t}");
        this.println("\t\treturn object;");
        this.println("\t}");
    }

    private void genReadArrayMappingObject() {
        this.println("\t@Override");
        this.println("\tpublic Object readArrayMappingObject(JSONReader jsonReader) {");
        this.println("\t\tjsonReader.next();");
        this.println("\t\t" + this.objectClass.getSimpleName() + " object = new " + this.objectClass.getSimpleName() + "();");
        for (int i = 0; i < this.fieldReaderArray.length; ++i) {
            FieldReader fieldReader = this.fieldReaderArray[i];
            Type fieldType = fieldReader.getFieldType();
            Class fieldClass = fieldReader.getFieldClass();
            AccessibleObject member = fieldReader.getMethod();
            if (member == null) {
                member = fieldReader.getField();
            }
            this.readFieldValue(0, false, (short)i, fieldReader, (Member)((Object)member), fieldType, fieldClass);
        }
        this.println("\t\tif (!jsonReader.nextIfMatch(']')) {");
        this.println("\t\t\tthrow new JSONException(\"array to bean end error, \" + jsonReader.current());");
        this.println("\t\t}");
        this.println();
        this.println("\t\tjsonReader.nextIfMatch(',');");
        this.println();
        this.println("\t\treturn object;");
        this.println("\t}");
    }

    private void genReadObject() {
        this.println("\t@Override");
        this.println("\tpublic Object readObject(JSONReader jsonReader, long features) {");
        this.println("\t\tif (jsonReader.isJSONB()) {");
        this.println("\t\t\treturn readJSONBObject(jsonReader, features);");
        this.println("\t\t}");
        this.println();
        if (this.beanInfo.readerFeatures != 0L) {
            this.println("\t\tif (jsonReader.isArray() && jsonReader.isSupportBeanArray(" + this.beanInfo.readerFeatures + "L | features)) {");
        } else {
            this.println("\t\tif (jsonReader.isArray() && jsonReader.isSupportBeanArray(features)) {");
        }
        this.println("\t\t\treturn readArrayMappingObject(jsonReader);");
        this.println("\t\t}");
        this.println();
        this.println("\t\tjsonReader.next();");
        this.println("\t\t" + this.objectClass.getSimpleName() + " object = new " + this.objectClass.getSimpleName() + "();");
        this.println("\t\tfor_:");
        this.println("\t\tfor (int i = 0;;++i) {");
        this.println("\t\t\tif (jsonReader.current() == '}') {");
        this.println("\t\t\t\tjsonReader.next();");
        this.println("\t\t\t\tbreak;");
        this.println("\t\t\t}");
        this.println();
        this.println("\t\t\tlong hashCode64 = jsonReader.readFieldNameHashCode();");
        this.println();
        this.println("\t\t\tif (hashCode64 == HASH_TYPE && i == 0) {");
        this.println("\t\t\t\tlong typeHash = jsonReader.readValueHashCode();");
        this.println("\t\t\t\tJSONReader.Context context = jsonReader.getContext();");
        this.println("\t\t\t\tObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);");
        this.println("\t\t\t\tif (autoTypeObjectReader == null) {");
        this.println("\t\t\t\t\tString typeName = jsonReader.getString();");
        this.println("\t\t\t\t\tautoTypeObjectReader = context.getObjectReaderAutoType(typeName, " + ObjectReaderGen.className(this.objectClass) + ".class);");
        this.println();
        this.println("\t\t\t\t\tif (autoTypeObjectReader == null) {");
        this.println("\t\t\t\t\t\tthrow new JSONException(\"auotype not support : \" + typeName);");
        this.println("\t\t\t\t\t}");
        this.println("\t\t\t\t}");
        this.println();
        this.println("\t\t\t\tif (autoTypeObjectReader != this) {");
        this.println("\t\t\t\t\tobject = (" + ObjectReaderGen.className(this.objectClass) + ") autoTypeObjectReader.readObject(jsonReader, 0);");
        this.println("\t\t\t\t\tbreak;");
        this.println("\t\t\t\t} else {");
        this.println("\t\t\t\t\tcontinue;");
        this.println("\t\t\t\t}");
        this.println("\t\t\t}");
        this.gen_readObject_for_body(1, false);
        this.println("\t\t}");
        this.println();
        this.println("\t\treturn object;");
        this.println("\t}");
    }

    private void gen_readObject_for_body(int tabCnt, boolean jsonb) {
        boolean useSwitch;
        boolean bl = useSwitch = this.fieldReaderArray.length > 6;
        if (useSwitch) {
            this.println(tabCnt, "\t\tint hashCode32 = (int)(hashCode64 ^ (hashCode64 >>> 32));");
            this.println(tabCnt, "\t\tswitch(hashCode32) {");
            tabCnt += 2;
        }
        for (Map.Entry<Integer, List<Long>> entry : this.map.entrySet()) {
            int hashCode32 = entry.getKey();
            if (useSwitch) {
                this.println("\t\t\tcase " + hashCode32 + ":");
            }
            for (Long hashCode64 : entry.getValue()) {
                Class<?> fieldClass;
                int m = Arrays.binarySearch(this.hashCodes, hashCode64);
                short index = this.mapping[m];
                FieldReader fieldReader = this.fieldReaderArray[index];
                String fieldName = fieldReader.getFieldName();
                long fieldNameHashCode64 = Fnv.hashCode64(fieldName);
                if (fieldNameHashCode64 != hashCode64) {
                    throw new IllegalStateException();
                }
                if (hashCode32 != (int)(fieldNameHashCode64 ^ fieldNameHashCode64 >>> 32)) {
                    throw new IllegalStateException();
                }
                this.println(tabCnt, "\t\tif (hashCode64 == " + hashCode64 + "L) { // " + fieldName);
                Member member = this.members.get(fieldNameHashCode64);
                Type fieldType = this.fieldTypes.get(fieldNameHashCode64);
                if (member instanceof Field) {
                    fieldClass = ((Field)member).getType();
                } else if (member instanceof Method) {
                    fieldClass = ((Method)member).getParameterTypes()[0];
                } else {
                    throw new JSONException("TODO");
                }
                this.readFieldValue(tabCnt, jsonb, index, fieldReader, member, fieldType, fieldClass);
                this.println(tabCnt, "\t\t\tcontinue;");
                this.println(tabCnt, "\t\t}");
            }
            if (!useSwitch) continue;
            this.println(tabCnt, "\t\tbreak;");
        }
        if (useSwitch) {
            this.println(tabCnt, "\tdefault:");
            this.println(tabCnt, "\t\tbreak;");
            this.println(tabCnt, "}");
        }
        this.println(tabCnt, "\t\tString fieldName = jsonReader.getFieldName();");
        this.println(tabCnt, "\t\tthrow new JSONException(\"fieldReader not found, fieldName \" + fieldName);");
    }

    private void readFieldValue(int tabCnt, boolean jsonb, short index, FieldReader fieldReader, Member member, Type fieldType, Class fieldClass) {
        if (fieldType == Integer.TYPE) {
            if (member instanceof Method) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + "(jsonReader.readInt32Value());");
            } else if (member instanceof Field) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + " = jsonReader.readInt32Value();");
            } else {
                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, jsonReader.readInt32Value());");
            }
        } else if (fieldType == Long.TYPE) {
            if (member instanceof Method) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + "(jsonReader.readInt64Value());");
            } else if (member instanceof Field) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + " = jsonReader.readInt64Value();");
            } else {
                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, jsonReader.readInt64Value());");
            }
        } else if (fieldType == String.class) {
            if (member instanceof Method) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + "(jsonReader.readString());");
            } else if (member instanceof Field) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + " = jsonReader.readString();");
            } else {
                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, jsonReader.readString());");
            }
        } else if (fieldType == List.class) {
            this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".readFieldValue(jsonReader, object);");
        } else if (fieldType instanceof Class && ((Class)fieldType).isEnum()) {
            if (jsonb) {
                this.println(tabCnt, "\t\t\tlong hash = jsonReader.readValueHashCode();");
                String fieldClassName = ((Class)fieldType).getName().replace('$', '.');
                this.println(tabCnt, "\t\t\t" + fieldClassName + " fieldValue");
                this.println(tabCnt, "\t\t\t\t= (" + fieldClassName + ") this.fieldReader" + index + ".getEnumByHashCode(hash);");
                if (member instanceof Method) {
                    this.println(tabCnt, "\t\t\tobject." + member.getName() + "(fieldValue);");
                } else {
                    this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, fieldValue);");
                }
            } else {
                this.println(tabCnt, "\t\t\tchar ch = jsonReader.current();");
                this.println(tabCnt, "\t\t\tif (ch == '\"') {");
                this.println(tabCnt, "\t\t\t\tlong hash = jsonReader.readValueHashCode();");
                String fieldClassName = ((Class)fieldType).getName().replace('$', '.');
                this.println(tabCnt, "\t\t\t\t" + fieldClassName + " fieldValue");
                this.println(tabCnt, "\t\t\t\t\t= (" + fieldClassName + ") this.fieldReader" + index + ".getEnumByHashCode(hash);");
                if (member instanceof Method) {
                    this.println(tabCnt, "\t\t\t\tobject." + member.getName() + "(fieldValue);");
                } else {
                    this.println(tabCnt, "\t\t\t\tthis.fieldReader" + index + ".accept(object, fieldValue);");
                }
                this.println(tabCnt, "\t\t\t} else {");
                this.println(tabCnt, "\t\t\t\tthrow new JSONException(\"TODO\");");
                this.println(tabCnt, "\t\t\t}");
            }
        } else if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 1 && actualTypeArguments[0] instanceof Class) {
                if (rawType == List.class || rawType == ArrayList.class) {
                    if (actualTypeArguments[0] == String.class) {
                        if (jsonb) {
                            this.println(tabCnt, "\t\t\tint listItemCnt = jsonReader.startArray();");
                            this.println(tabCnt, "\t\t\tjava.util.List list = new java.util.ArrayList(listItemCnt);");
                            this.println(tabCnt, "\t\t\tfor (int j = 0; j < listItemCnt; ++j) {");
                            this.println(tabCnt, "\t\t\t\t\tlist.add(");
                            this.println(tabCnt, "\t\t\t\t\t\tjsonReader.readString());");
                            this.println();
                            this.println(tabCnt, "\t\t\t}");
                            if (member instanceof Method) {
                                this.println(tabCnt, "\t\t\tobject." + member.getName() + "(list);");
                            } else {
                                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, list);");
                            }
                        } else {
                            this.println(tabCnt, "\t\t\tif (jsonReader.current() == '[') {");
                            this.println(tabCnt, "\t\t\t\tjava.util.List list = new java.util.ArrayList();");
                            this.println(tabCnt, "\t\t\t\tjsonReader.next();");
                            this.println(tabCnt, "\t\t\t\tfor (;;) {");
                            this.println(tabCnt, "\t\t\t\t\tif (jsonReader.current() == ']') {");
                            this.println(tabCnt, "\t\t\t\t\t\tjsonReader.next();");
                            this.println(tabCnt, "\t\t\t\t\t\tbreak;");
                            this.println(tabCnt, "\t\t\t\t\t}");
                            this.println();
                            this.println(tabCnt, "\t\t\t\t\tlist.add(jsonReader.readString());");
                            this.println();
                            this.println(tabCnt, "\t\t\t\t\tif (jsonReader.current() == ',') {");
                            this.println(tabCnt, "\t\t\t\t\t\tjsonReader.next();");
                            this.println(tabCnt, "\t\t\t\t\t\tcontinue;");
                            this.println(tabCnt, "\t\t\t\t\t}");
                            this.println(tabCnt, "\t\t\t\t}");
                            if (member instanceof Method) {
                                this.println(tabCnt, "\t\t\tobject." + member.getName() + "(list);");
                            } else {
                                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, list);");
                            }
                            this.println(tabCnt, "\t\t\t\tif (jsonReader.current() == ',') {");
                            this.println(tabCnt, "\t\t\t\t\tjsonReader.next();");
                            this.println(tabCnt, "\t\t\t\t}");
                            this.println(tabCnt, "\t\t\t}");
                        }
                    } else if (jsonb) {
                        this.println(tabCnt, "\t\t\tint listItemCnt = jsonReader.startArray();");
                        this.println(tabCnt, "\t\t\tjava.util.List list = new java.util.ArrayList(listItemCnt);");
                        this.println(tabCnt, "\t\t\tfor (int j = 0; j < listItemCnt; ++j) {");
                        this.println(tabCnt, "\t\t\t\tif (fieldListItemReader" + index + " == null) {");
                        this.println(tabCnt, "\t\t\t\t\tfieldListItemReader" + index + " = jsonReader.getContext()");
                        this.println(tabCnt, "\t\t\t\t\t\t.getObjectReader(" + ObjectReaderGen.className((Class)actualTypeArguments[0]) + ".class);");
                        this.println(tabCnt, "\t\t\t\t}");
                        this.println(tabCnt, "\t\t\t\t\tlist.add(");
                        this.println(tabCnt, "\t\t\t\t\t\tfieldListItemReader" + index + ".readJSONBObject(jsonReader, " + fieldReader.getFeatures() + "));");
                        this.println();
                        this.println(tabCnt, "\t\t\t}");
                        if (member instanceof Method) {
                            this.println(tabCnt, "\t\t\tobject." + member.getName() + "(list);");
                        } else {
                            this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, list);");
                        }
                    } else {
                        this.println(tabCnt, "\t\t\tif (jsonReader.current() == '[') {");
                        this.println(tabCnt, "\t\t\t\tif (fieldListItemReader" + index + " == null) {");
                        this.println(tabCnt, "\t\t\t\t\tfieldListItemReader" + index + " = jsonReader.getContext()");
                        this.println(tabCnt, "\t\t\t\t\t\t.getObjectReader(" + ObjectReaderGen.className((Class)actualTypeArguments[0]) + ".class);");
                        this.println(tabCnt, "\t\t\t\t}");
                        this.println();
                        this.println(tabCnt, "\t\t\t\tjava.util.List list = new java.util.ArrayList();");
                        this.println(tabCnt, "\t\t\t\tjsonReader.next();");
                        this.println(tabCnt, "\t\t\t\tfor (;;) {");
                        this.println(tabCnt, "\t\t\t\t\tif (jsonReader.current() == ']') {");
                        this.println(tabCnt, "\t\t\t\t\t\tjsonReader.next();");
                        this.println(tabCnt, "\t\t\t\t\t\tbreak;");
                        this.println(tabCnt, "\t\t\t\t\t\t}");
                        this.println();
                        this.println(tabCnt, "\t\t\t\t\t\tlist.add(");
                        this.println(tabCnt, "\t\t\t\t\t\t\tfieldListItemReader" + index + ".readObject(jsonReader, " + fieldReader.getFeatures() + "));");
                        this.println();
                        this.println(tabCnt, "\t\t\t\t\t\tif (jsonReader.current() == ',') {");
                        this.println(tabCnt, "\t\t\t\t\t\t\tjsonReader.next();");
                        this.println(tabCnt, "\t\t\t\t\t\t\tcontinue;");
                        this.println(tabCnt, "\t\t\t\t\t\t}");
                        this.println(tabCnt, "\t\t\t\t\t}");
                        if (member instanceof Method) {
                            this.println(tabCnt, "\t\t\t\tobject." + member.getName() + "(list);");
                        } else {
                            this.println(tabCnt, "\t\t\t\tthis.fieldReader" + index + ".accept(object, list);");
                        }
                        this.println(tabCnt, "\t\t\t\tif (jsonReader.current() == ',') {");
                        this.println(tabCnt, "\t\t\t\t\tjsonReader.next();");
                        this.println(tabCnt, "\t\t\t\t}");
                        this.println(tabCnt, "\t\t\t}");
                    }
                } else {
                    this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".readFieldValue(jsonReader, object);");
                }
            } else {
                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".readFieldValue(jsonReader, object);");
            }
        } else if (fieldReader instanceof FieldReaderObject) {
            this.println(tabCnt, "\t\t\tif (this.fieldObjectReader" + index + " == null) {");
            this.println(tabCnt, "\t\t\t\tthis.fieldObjectReader" + index + " = jsonReader.getContext()");
            this.println(tabCnt, "\t\t\t\t\t.getObjectReader(" + ObjectReaderGen.className(fieldClass) + ".class); // " + fieldReader.getFieldName());
            this.println(tabCnt, "\t\t\t}");
            if (member instanceof Method) {
                this.println(tabCnt, "\t\t\tobject." + member.getName() + "((" + ObjectReaderGen.className(fieldClass) + ")");
                if (jsonb) {
                    this.println(tabCnt, "\t\t\t\t\tfieldObjectReader" + index + ".readJSONBObject(jsonReader, " + fieldReader.getFeatures() + "));");
                } else {
                    this.println(tabCnt, "\t\t\t\t\tfieldObjectReader" + index + ".readObject(jsonReader, " + fieldReader.getFeatures() + "));");
                }
            } else {
                this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".accept(object, fieldObjectReader\" + index + \".readObject(jsonReader, " + fieldReader.getFeatures() + "));");
            }
        } else {
            this.println(tabCnt, "\t\t\tthis.fieldReader" + index + ".readFieldValue(jsonReader, object);");
        }
    }

    static String className(Class clazz) {
        return clazz.getName().replace('$', '.');
    }

    private void gen_getFieldReader() {
        this.println("\t@Override");
        this.println("\tpublic FieldReader getFieldReader(long hashCode64) {");
        boolean useSwitch = this.fieldReaderArray.length > 6;
        int tabCnt = 0;
        if (useSwitch) {
            this.println("\t\tint hashCode32 = (int)(hashCode64 ^ (hashCode64 >>> 32));");
            this.println("\t\tswitch(hashCode32) {");
            tabCnt = 2;
        }
        for (Map.Entry<Integer, List<Long>> entry : this.map.entrySet()) {
            int hashCode32 = entry.getKey();
            if (useSwitch) {
                this.println(tabCnt, "\tcase " + hashCode32 + ":");
            }
            for (Long hashCode64 : entry.getValue()) {
                int m = Arrays.binarySearch(this.hashCodes, hashCode64);
                short index = this.mapping[m];
                FieldReader fieldReader = this.fieldReaderArray[index];
                String fieldName = fieldReader.getFieldName();
                long fieldNameHashCode64 = Fnv.hashCode64(fieldName);
                if (fieldNameHashCode64 != hashCode64) {
                    throw new IllegalStateException();
                }
                if (hashCode32 != (int)(fieldNameHashCode64 ^ fieldNameHashCode64 >>> 32)) {
                    throw new IllegalStateException();
                }
                this.println(tabCnt, "\t\tif (hashCode64 == " + hashCode64 + "L) { // " + fieldName);
                this.println(tabCnt, "\t\t\treturn this.fieldReader" + index + ";");
                this.println(tabCnt, "\t\t}");
            }
            if (!useSwitch) continue;
            this.println(tabCnt, "\t\tbreak;");
        }
        if (useSwitch) {
            this.println(tabCnt, "\tdefault:");
            this.println(tabCnt, "\t\tbreak;");
            this.println(tabCnt, "}");
        }
        this.println("\t\treturn null;");
        this.println("\t}");
    }

    void println() {
        try {
            this.out.append('\n');
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void println(String context) {
        try {
            this.out.append(context);
            this.out.append('\n');
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void println(int tabCnt, String context) {
        try {
            for (int i = 0; i < tabCnt; ++i) {
                this.out.append('\t');
            }
            this.out.append(context);
            this.out.append('\n');
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

