/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.OptionalDouble;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;

public class test {
    public static void main(String[] args) {
        String expressionString = "sum(-23*22,-1*1)";
        expressionString = test.convertSumToPlus(expressionString);
        System.out.println(test.execute(expressionString, null));
    }

    public static BigDecimal execute(String expressionString, Date date) {
        return test.execute(expressionString, null, date);
    }

    public static BigDecimal execute(String expressionString, Integer decimals, Date date) {
        System.out.println(expressionString);
        try {
            Function avg = new Function("avg", 0){

                @Override
                public double apply(double ... args) {
                    System.out.println("avg:" + args.length);
                    this.setNumArguments(args.length);
                    OptionalDouble avg = Arrays.stream(args).average();
                    return avg.isPresent() ? avg.getAsDouble() : 0.0;
                }
            };
            Function sum = new Function("sum", 0){

                @Override
                public double apply(double ... args) {
                    return Arrays.stream(args).sum();
                }
            };
            Function first = new Function("first", 0){

                @Override
                public double apply(double ... args) {
                    if (args.length == 0) {
                        return 0.0;
                    }
                    return args[0];
                }
            };
            Function max = new Function("max", 0){

                @Override
                public double apply(double ... args) {
                    return Arrays.stream(args).max().isPresent() ? Arrays.stream(args).max().getAsDouble() : 0.0;
                }
            };
            Function min = new Function("min", 0){

                @Override
                public double apply(double ... args) {
                    return Arrays.stream(args).min().isPresent() ? Arrays.stream(args).min().getAsDouble() : 0.0;
                }
            };
            Expression expression = new ExpressionBuilder(expressionString).function(sum).functions(avg).functions(first).functions(max).functions(min).build();
            double result = expression.evaluate();
            if (decimals == null) {
                return BigDecimal.valueOf(result);
            }
            return BigDecimal.valueOf(result).setScale((int)decimals, RoundingMode.HALF_UP);
        }
        catch (ArithmeticException e) {
            return null;
        }
        catch (IllegalArgumentException ee) {
            return null;
        }
    }

    public static String convertSumToPlus(String expression) {
        Pattern pattern = Pattern.compile("sum\\((.*)\\)", 2);
        Matcher matcher = pattern.matcher(expression);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String args = matcher.group(1);
            String[] parts = args.split(",");
            ArrayList<String> cleanedParts = new ArrayList<String>();
            for (String part : parts) {
                cleanedParts.add(part.trim());
            }
            String replacement = String.join((CharSequence)" + ", cleanedParts);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

