/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.controller;

import cc.lechun.balance.api.GiftCardManagerApi;
import cc.lechun.balance.dto.GiftCardBatchDTO;
import cc.lechun.balance.dto.GiftCardDTO;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/giftCard"})
public class GiftCardBatchController {
    private static final Logger log = LoggerFactory.getLogger(GiftCardBatchController.class);
    @Autowired
    private GiftCardManagerApi giftCardBatchApiService;

    @RequestMapping(value={"/findGiftCardBatches"})
    public BaseJsonVo findGiftCardBatches(PageForm pageForm, GiftCardBatchDTO giftCardBatchDTO) {
        return this.giftCardBatchApiService.findGiftCardBatches(pageForm, giftCardBatchDTO);
    }

    @RequestMapping(value={"/findGiftCards"})
    public BaseJsonVo findGiftCards(PageForm pageForm, GiftCardDTO giftCardDTO) {
        return this.giftCardBatchApiService.findGiftCards(pageForm, giftCardDTO);
    }

    @RequestMapping(value={"/exportGiftCards"})
    public BaseJsonVo exportGiftCards(String batchId) {
        return this.giftCardBatchApiService.exportGiftCards(batchId);
    }

    @RequestMapping(value={"/generateGiftCardBatch"})
    public BaseJsonVo generateGiftCardBatch(GiftCardBatchDTO batchDto) {
        if (StringUtils.isEmpty((String)batchDto.getBatchNo())) {
            return this.giftCardBatchApiService.generateGiftCardBatch(batchDto);
        }
        return this.giftCardBatchApiService.updateGiftCardBatch(batchDto);
    }

    @RequestMapping(value={"/delGiftCardBatch"})
    public BaseJsonVo delGiftCardBatch(String batchId) {
        return this.giftCardBatchApiService.delGiftCardBatch(batchId);
    }

    @RequestMapping(value={"/cancelGiftCardBatch"})
    public BaseJsonVo cancelGiftCardBatch(String batchId) {
        return this.giftCardBatchApiService.cancelGiftCardBatch(batchId);
    }

    @RequestMapping(value={"/invalidCard"})
    public BaseJsonVo invalidCard(String cardNo, int cardState) {
        return this.giftCardBatchApiService.invalidCard(cardNo, cardState);
    }
}

