/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.gift;

import cc.lechun.balance.dao.gift.GiftCardBatchMapper;
import cc.lechun.balance.dao.gift.GiftCardMapper;
import cc.lechun.balance.entity.gift.GiftCardBatchEntity;
import cc.lechun.balance.entity.gift.GiftCardEntity;
import cc.lechun.balance.entity.gift.GiftCardEntityExample;
import cc.lechun.balance.iservice.gift.GiftCardInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftCardService
extends BaseService<GiftCardEntity, String, GiftCardEntityExample>
implements GiftCardInterface {
    @Autowired
    private GiftCardMapper giftCardMapper;
    @Autowired
    private GiftCardBatchMapper giftCardBatchMapper;

    public PageInfo queryGiftCardByBatchId(int currentPage, int pageSize, GiftCardEntity giftCardEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List giftCardEntityList = this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
        PageInfo pg = page.toPageInfo();
        pg.setList(giftCardEntityList);
        return pg;
    }

    public void saveGiftCardByBatchId(List<GiftCardEntity> giftCardEntityList) {
        this.giftCardMapper.batchInsert(giftCardEntityList);
    }

    public List<GiftCardEntity> queryCardInfo(String batchNo) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setBatchNo(batchNo);
        List giftCardEntityList = this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
        return giftCardEntityList;
    }

    public List<GiftCardEntity> queryCardInfoByBatchNo(String batchNo, int cardState) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setBatchNo(batchNo);
        giftCardEntity.setCardState(Integer.valueOf(cardState));
        List giftCardEntityList = this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
        return giftCardEntityList;
    }

    public List<GiftCardEntity> queryCardInfoByBatchNoOne(String batchNo, int cardState) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setBatchNo(batchNo);
        giftCardEntity.setCardState(Integer.valueOf(cardState));
        List giftCardEntityList = this.giftCardMapper.queryGiftCardInfoListByNotOne(giftCardEntity);
        return giftCardEntityList;
    }

    public void batchDeleteCardInfoByBatchNo(String batchNo) {
        String[] batchNoArr = new String[]{batchNo};
        this.giftCardMapper.batchDelete((Serializable[])batchNoArr);
    }

    public int batchCancel(String[] cardNoArry) {
        for (String cardNo : cardNoArry) {
            this.remoteCache((Serializable)((Object)cardNo));
        }
        return this.giftCardMapper.batchCancel(cardNoArry);
    }

    public List<GiftCardEntity> queryGiftCardInfoListByNotOne(GiftCardEntity giftCardEntity) {
        return this.giftCardMapper.queryGiftCardInfoListByNotOne(giftCardEntity);
    }

    public int updateCardState(GiftCardEntity giftCardEntity) {
        this.remoteCache((Serializable)((Object)giftCardEntity.getCardNo()));
        return this.giftCardMapper.updateCardState(giftCardEntity);
    }

    public List<GiftCardEntity> queryGiftCardInfo(GiftCardEntity giftCardEntity) {
        return this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
    }

    public void importCards() {
        this.giftCardMapper.truncate();
        List batchs = this.giftCardMapper.findOldBatchs();
        batchs.forEach(batch -> {
            GiftCardBatchEntity b = new GiftCardBatchEntity();
            b.setBatchNo(IDGenerate.getUniqueIdStr());
            b.setBatchName((Integer)batch.get("cash") + "\u5143\u793c\u54c1\u5361");
            b.setBatchNum(Integer.valueOf((int)((Long)batch.get("cou")).longValue()));
            b.setBatchMoney(new BigDecimal((Integer)batch.get("cash")));
            b.setCardStartTime((Date)batch.get("create_time"));
            b.setCardEndTime(DateUtils.getDateFromString((String)"2099-01-01 00:00:00"));
            b.setCreateTime((Date)batch.get("create_time"));
            b.setCreateBy("IMPORT");
            this.giftCardBatchMapper.insert((Object)b);
            List cards = this.giftCardMapper.findOldCards(((Integer)batch.get("batch_no")).intValue(), ((Integer)batch.get("cash")).intValue());
            cards.forEach(card -> {
                GiftCardEntity e = new GiftCardEntity();
                e.setCardNo((String)card.get("no"));
                e.setCardCash(new BigDecimal((Integer)card.get("cash")));
                e.setCardState(Integer.valueOf((Integer)card.get("state")));
                e.setCardStartTime((Date)batch.get("create_time"));
                e.setCardEndTime(DateUtils.getDateFromString((String)"2099-01-01 00:00:00"));
                e.setBatchNo(b.getBatchNo());
                e.setCustomerId((Integer)card.get("state") == 0 ? null : (String)card.get("used_id"));
                e.setActivateTime((Integer)card.get("state") == 0 ? null : (Date)batch.get("used_time"));
                e.setCreateTime((Date)batch.get("create_time"));
                e.setCreateBy("IMPORT");
                e.setUpdateTime((Integer)card.get("state") == 0 ? null : (Date)batch.get("used_time"));
                e.setUpdateBy((Integer)card.get("state") == 0 ? null : (String)card.get("used_id"));
                this.giftCardMapper.insert((Object)e);
            });
        });
    }
}

