/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.api;

import cc.lechun.balance.api.UserBalanceApi;
import cc.lechun.balance.apiinvoke.mall.MallTempMsgInvoke;
import cc.lechun.balance.common.constants.BalanceTypeEnum;
import cc.lechun.balance.common.constants.DetailTypeEnum;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.balance.dto.UserBalanceDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.balance.entity.account.UserBalanceChangeEntity;
import cc.lechun.balance.entity.account.UserBalanceChangeEntityExample;
import cc.lechun.balance.entity.account.UserBalanceDetailEntity;
import cc.lechun.balance.entity.account.UserBalanceDetailEntityExample;
import cc.lechun.balance.entity.account.UserBalanceDetailReleEntity;
import cc.lechun.balance.entity.account.UserBalanceEntity;
import cc.lechun.balance.entity.gift.GiftCardEntity;
import cc.lechun.balance.entity.specialCard.SpecialCardEntity;
import cc.lechun.balance.entity.specialCard.SpecialCardLogEntity;
import cc.lechun.balance.entity.storage.StorageCardEntity;
import cc.lechun.balance.iservice.account.UserBalanceChangeInterface;
import cc.lechun.balance.iservice.account.UserBalanceDetailInterface;
import cc.lechun.balance.iservice.account.UserBalanceDetailReleInterface;
import cc.lechun.balance.iservice.account.UserBalanceInterface;
import cc.lechun.balance.iservice.gift.GiftCardInterface;
import cc.lechun.balance.iservice.specialCard.SpecialCardInterface;
import cc.lechun.balance.iservice.specialCard.SpecialCardLogInterface;
import cc.lechun.balance.iservice.storage.StorageCardInterface;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.cache.RedisLock;
import cc.lechun.framework.common.utils.cache.RedisLockParameter;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mallapi.dto.TemplateMessageDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserBalanceApiService
implements UserBalanceApi {
    private static final Logger log = LoggerFactory.getLogger(UserBalanceApiService.class);
    @Autowired
    RedisCacheUtil redis;
    @Autowired
    UserBalanceInterface userBalanceInterface;
    @Autowired
    UserBalanceDetailInterface userBalanceDetailInterface;
    @Autowired
    UserBalanceChangeInterface userBalanceChangeInterface;
    @Autowired
    UserBalanceDetailReleInterface userBalanceDetailReleInterface;
    @Autowired
    StorageCardInterface storageCardInterface;
    @Autowired
    GiftCardInterface giftCardInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallTempMsgInvoke tempMsgApi;
    @Autowired
    SpecialCardInterface specialCardInterface;
    @Autowired
    SpecialCardLogInterface specialCardLogInterface;

    @Cacheable(value={"Balance"}, key="'BalanceAccount:'+#customerId")
    public BaseJsonVo<UserBalanceDTO> getUserBalance(String customerId) {
        UserBalanceDTO dto = (UserBalanceDTO)this.redis.get("BalanceAccount:" + customerId);
        if (dto != null) {
            return BaseJsonVo.success((Object)dto);
        }
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        if (userBalanceEntity == null || userBalanceEntity.getBalanceState() == 0) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (userBalanceEntity.getBalanceState() == 2) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u5df2\u505c\u7528");
        }
        UserBalanceDTO userBalanceDTO = new UserBalanceDTO();
        userBalanceDTO.setCustomerId(userBalanceEntity.getCustomerId());
        userBalanceDTO.setBalanceState(userBalanceEntity.getBalanceState());
        userBalanceDTO.setCreateTime(userBalanceEntity.getCreateTime());
        userBalanceDTO.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        userBalanceDTO.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        userBalanceDTO.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        userBalanceDTO.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        if (userBalanceDTO != null) {
            this.redis.set("BalanceAccount:" + customerId, (Object)userBalanceDTO, Long.valueOf(3600L));
        }
        return BaseJsonVo.success((Object)userBalanceDTO);
    }

    @Cacheable(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")
    public BaseJsonVo<UserBalanceDetailDTO> getUserBalanceDetail(String customerId) {
        UserBalanceDetailDTO dto = (UserBalanceDetailDTO)this.redis.get("BalanceAccountDetail:" + customerId);
        if (dto != null) {
            return BaseJsonVo.success((Object)dto);
        }
        BaseJsonVo userBalance = ((UserBalanceApiService)SpringContextUtil.getBean(this.getClass())).getUserBalance(customerId);
        if (!userBalance.isSuccess()) {
            return BaseJsonVo.error((String)userBalance.getMessage());
        }
        int page = 0;
        int pageSize = 100;
        BaseJsonVo detailsResult = this.userBalanceDetailInterface.findOrderedDetails(customerId, page, pageSize);
        List details = detailsResult.isSuccess() ? (List)detailsResult.getValue() : null;
        ArrayList records = new ArrayList();
        UserBalanceDetailDTO userBalanceDetail = new UserBalanceDetailDTO();
        if (details != null && details.size() > 0) {
            details.forEach(detail -> {
                UserBalanceDetailDTO.UserBalanceDetailRecordDTO record = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
                record.setCash((detail.getDetailType() == 1 ? "+" : "-") + detail.getChangeMoney().toString());
                record.setTime(detail.getCreateTime());
                record.setWealth(detail.getAccountTotal().toString());
                record.setTitle(detail.getDetailSubTypeDesc());
                record.setTradeNo(detail.getOrderMainNo());
                if (detail.getDetailType() == 1) {
                    UserBalanceChangeEntityExample example = new UserBalanceChangeEntityExample();
                    example.createCriteria().andDetailIdEqualTo(detail.getId());
                    List list = this.userBalanceChangeInterface.selectByExample((Object)example);
                    UserBalanceChangeEntity userBalanceChangeEntity = null;
                    if (list != null && list.size() > 0) {
                        userBalanceChangeEntity = (UserBalanceChangeEntity)list.get(0);
                    }
                    if (userBalanceChangeEntity != null && userBalanceChangeEntity.getUsableMoney() != null) {
                        record.setUsableWealth(userBalanceChangeEntity.getUsableMoney().toString());
                    }
                }
                records.add(record);
            });
        }
        userBalanceDetail.setUserBalance((UserBalanceDTO)userBalance.getValue());
        userBalanceDetail.setRecords(records);
        if (userBalanceDetail != null && userBalanceDetail.getUserBalance() != null) {
            this.redis.set("BalanceAccountDetail:" + customerId, (Object)userBalanceDetail, Long.valueOf(3600L));
        }
        return BaseJsonVo.success((Object)userBalanceDetail);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> charge(@RedisLockParameter String customerId, String orderMainNo, String productId) {
        StorageCardEntity storageCardEntity = this.storageCardInterface.selectByProductId(productId);
        if (storageCardEntity == null || storageCardEntity.getGiftCash() == null || storageCardEntity.getGiftCash().compareTo(BigDecimal.ZERO) == 0) {
            throw new RuntimeException("\u8be5\u50a8\u503c\u5361\u4e0d\u5b58\u5728");
        }
        if (storageCardEntity.getGiftState() == 0) {
            throw new RuntimeException("\u50a8\u503c\u5361\u5df2\u5220\u9664");
        }
        if (storageCardEntity.getGiftState() == 2) {
            throw new RuntimeException("\u50a8\u503c\u5361\u5df2\u505c\u7528");
        }
        UserBalanceDetailEntityExample example = new UserBalanceDetailEntityExample();
        example.createCriteria().andOrderMainNoEqualTo(orderMainNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
        List list = this.userBalanceDetailInterface.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            throw new RuntimeException("\u8be5\u8ba2\u5355\u4f59\u989d\u5df2\u589e\u52a0");
        }
        BaseJsonVo userBalanceStore = this.userBalanceInterface.increaseAccount(customerId, storageCardEntity.getGiftCash(), BalanceTypeEnum.STORE, customerId, 2);
        if (!userBalanceStore.isSuccess()) {
            throw new RuntimeException(userBalanceStore.getMessage());
        }
        BaseJsonVo userBalanceFree = this.userBalanceInterface.increaseAccount(customerId, storageCardEntity.getFreeCash(), BalanceTypeEnum.FREE, customerId, 2);
        if (!userBalanceFree.isSuccess()) {
            throw new RuntimeException(userBalanceFree.getMessage());
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(IDGenerate.getUniqueIdStr());
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.STORE.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.STORE.getName());
        detailStore.setChangeMoney(storageCardEntity.getGiftCash());
        detailStore.setAccountTotal(((UserBalanceEntity)userBalanceStore.getValue()).getUsableTotalBalance());
        detailStore.setAccountStore(((UserBalanceEntity)userBalanceStore.getValue()).getUsableStoreBalance());
        detailStore.setAccountFree(((UserBalanceEntity)userBalanceStore.getValue()).getUsableFreeBalance());
        detailStore.setAccountGift(((UserBalanceEntity)userBalanceStore.getValue()).getUsableGiftBalance());
        detailStore.setOrderMainNo(orderMainNo);
        detailStore.setGiftId(storageCardEntity.getId());
        detailStore.setGiftTitle(storageCardEntity.getGiftTitle());
        detailStore.setCreateBy(customerId);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark(orderMainNo);
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        UserBalanceDetailEntity detailFree = new UserBalanceDetailEntity();
        detailFree.setId(IDGenerate.getUniqueIdStr());
        detailFree.setCustomerId(customerId);
        detailFree.setDetailType(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue() / 1000));
        detailFree.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue()));
        detailFree.setDetailSubTypeDesc(DetailTypeEnum.STORE_FREE.getName());
        detailFree.setChangeMoney(storageCardEntity.getFreeCash());
        detailFree.setAccountTotal(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        detailFree.setAccountStore(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        detailFree.setAccountFree(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        detailFree.setAccountGift(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        detailFree.setOrderMainNo(orderMainNo);
        detailFree.setGiftId(storageCardEntity.getId());
        detailFree.setGiftTitle(storageCardEntity.getGiftTitle());
        detailFree.setCreateBy(customerId);
        detailFree.setCreateTime(detailStore.getCreateTime());
        detailFree.setUpdateBy("");
        detailFree.setUpdateTime(null);
        detailFree.setRemark(orderMainNo);
        BaseJsonVo userBalanceDetailFree = this.userBalanceDetailInterface.keepAccountDetail(detailFree);
        if (!userBalanceDetailFree.isSuccess()) {
            throw new RuntimeException(userBalanceDetailFree.getMessage());
        }
        BaseJsonVo userBalanceChangeStore = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getId(), storageCardEntity.getGiftCash(), customerId);
        if (!userBalanceChangeStore.isSuccess()) {
            throw new RuntimeException(userBalanceChangeStore.getMessage());
        }
        BaseJsonVo userBalanceChangeFree = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getId(), storageCardEntity.getFreeCash(), customerId);
        if (!userBalanceChangeFree.isSuccess()) {
            throw new RuntimeException(userBalanceChangeFree.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        HashMap<String, String> messageBody = new HashMap<String, String>();
        messageBody.put("userId", customerId);
        messageBody.put("taskId", "3164445247234775788");
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.finishTaskCharge, new MessageParam(customerId, messageBody));
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalanceFree.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOStore = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOStore.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTOStore.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTOStore.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTOStore.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOStore);
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOFree = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOFree.setCash(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getChangeMoney().toString());
        detailRecordDTOFree.setTime(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getCreateTime());
        detailRecordDTOFree.setWealth(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getAccountTotal().toString());
        detailRecordDTOFree.setTitle(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOFree);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(storageCardEntity.getGiftCash().add(storageCardEntity.getFreeCash()));
        changeDTO.setStoreBalanceChange(storageCardEntity.getGiftCash());
        changeDTO.setFreeBalanceChange(storageCardEntity.getFreeCash());
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detailStore.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.STORE.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)changeDTO.getTotalBalanceChange()));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<SpecialCardDTO> purchaseSpecialCard(String customerId, String orderMainNo, BigDecimal chargeAmount) {
        SpecialCardEntity card = new SpecialCardEntity();
        card.setOrderMainNo(orderMainNo);
        List cardList = this.specialCardInterface.getList((Object)card);
        if (cardList != null && cardList.size() > 0) {
            log.info("\u8be5\u8ba2\u5355[" + orderMainNo + "]\u5df2\u521b\u5efa\u5361");
            return BaseJsonVo.error((String)("\u8be5\u8ba2\u5355[" + orderMainNo + "]\u5df2\u521b\u5efa\u5361"));
        }
        card.setCardNo(IDGenerate.getUniqueIdStr());
        card.setTotalAmount(chargeAmount);
        card.setUsableAmount(chargeAmount);
        card.setRefundAmount(BigDecimal.ZERO);
        card.setStatus(Integer.valueOf(1));
        card.setCreateTime(DateUtils.now());
        int result = this.specialCardInterface.insert((Object)card);
        if (result <= 0) {
            return BaseJsonVo.error((String)("\u8be5\u8ba2\u5355[" + orderMainNo + "]\u4fdd\u5b58\u5931\u8d25"));
        }
        SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
        cardLog.setLogType(Integer.valueOf(0));
        cardLog.setCardNo(card.getCardNo());
        cardLog.setChangeMoney(card.getUsableAmount());
        cardLog.setTotalAccount(card.getUsableAmount());
        cardLog.setCustomerId(customerId);
        cardLog.setOrderMainNo(orderMainNo);
        cardLog.setCreateTime(DateUtils.now());
        this.specialCardLogInterface.insert((Object)cardLog);
        SpecialCardDTO dto = new SpecialCardDTO();
        dto.setCardNo(card.getCardNo());
        dto.setOrderMainNo(card.getOrderMainNo());
        dto.setTotalAmount(card.getTotalAmount());
        dto.setUsableAmount(card.getUsableAmount());
        dto.setCreateTime(card.getCreateTime());
        dto.setStatus(card.getStatus());
        return BaseJsonVo.success((Object)dto);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> cardCharge(@RedisLockParameter String customerId, String cardNo) {
        GiftCardEntity card = (GiftCardEntity)this.giftCardInterface.selectByPrimaryKey((Serializable)((Object)cardNo));
        if (card == null || card.getCardCash().compareTo(BigDecimal.ZERO) <= 0) {
            return BaseJsonVo.error((String)"\u5361\u53f7\u4e0d\u5b58\u5728");
        }
        if (card.getCardState() == -1) {
            return BaseJsonVo.error((String)"\u5361\u53f7\u65e0\u6548");
        }
        if (card.getCardState() == 1) {
            return BaseJsonVo.error((String)"\u8be5\u5361\u5df2\u88ab\u6fc0\u6d3b");
        }
        if (card.getCardStartTime() != null && card.getCardStartTime().compareTo(new Date()) > 0) {
            return BaseJsonVo.error((String)"\u672a\u5230\u6fc0\u6d3b\u65e5\u671f");
        }
        if (card.getCardEndTime() != null && card.getCardEndTime().compareTo(new Date()) < 0) {
            return BaseJsonVo.error((String)"\u5361\u5df2\u8fc7\u671f");
        }
        card.setCardState(Integer.valueOf(1));
        card.setActivateTime(new Date());
        card.setCustomerId(customerId);
        card.setUpdateTime(card.getActivateTime());
        card.setUpdateBy(customerId);
        this.giftCardInterface.updateByPrimaryKey((Object)card);
        BaseJsonVo userBalance = this.userBalanceInterface.increaseAccount(customerId, card.getCardCash(), BalanceTypeEnum.GIFT, customerId, 2);
        if (!userBalance.isSuccess()) {
            return BaseJsonVo.error((String)userBalance.getMessage());
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(IDGenerate.getUniqueIdStr());
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.GIFT_CHARGE.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.GIFT_CHARGE.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.GIFT_CHARGE.getName());
        detail.setChangeMoney(card.getCardCash());
        detail.setAccountTotal(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        detail.setAccountStore(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        detail.setAccountFree(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        detail.setAccountGift(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        detail.setOrderMainNo(cardNo);
        detail.setDetailStatus(null);
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetail = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetail.isSuccess()) {
            return BaseJsonVo.error((String)userBalanceDetail.getMessage());
        }
        BaseJsonVo userBalanceChange = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getId(), card.getCardCash(), customerId);
        if (!userBalanceChange.isSuccess()) {
            return BaseJsonVo.error((String)userBalanceChange.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            return BaseJsonVo.error((String)cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetail.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(card.getCardCash());
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(card.getCardCash());
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detail.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.GIFT_CHARGE.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)changeDTO.getTotalBalanceChange()));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> payOrder(@RedisLockParameter String customerId, String orderMainNo, BigDecimal orderAmount) {
        long start = System.currentTimeMillis();
        log.info("\u6d88\u8d39\u8ba2\u5355orderMainNo:" + orderMainNo + "|" + start);
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        if (userBalanceEntity == null || userBalanceEntity.getBalanceState() == 0) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u5220\u9664");
        }
        if (userBalanceEntity.getBalanceState() == 2) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u505c\u7528");
        }
        if (userBalanceEntity.getUsableTotalBalance().compareTo(orderAmount) < 0) {
            throw new RuntimeException("\u4f59\u989d\u4e0d\u8db3");
        }
        UserBalanceDetailEntityExample example = new UserBalanceDetailEntityExample();
        example.createCriteria().andOrderMainNoEqualTo(orderMainNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.ORDER.getValue()));
        List list = this.userBalanceDetailInterface.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            throw new RuntimeException("\u8be5\u8ba2\u5355\u4f59\u989d\u5df2\u6263\u9664");
        }
        BaseJsonVo changes = this.userBalanceChangeInterface.findChanges(customerId);
        if (!changes.isSuccess()) {
            throw new RuntimeException(changes.getMessage());
        }
        log.info(((List)changes.getValue()).stream().map(UserBalanceChangeEntity::getUsableMoney).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
        log.info(userBalanceEntity.getUsableTotalBalance().toString());
        if (((List)changes.getValue()).stream().map(UserBalanceChangeEntity::getUsableMoney).reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(userBalanceEntity.getUsableTotalBalance()) != 0) {
            throw new RuntimeException("\u8d26\u6237\u4f59\u989d\u4e0e\u5269\u4f59\u91d1\u989d\u4e0d\u7b26");
        }
        String detailId = IDGenerate.getUniqueIdStr();
        BigDecimal storeOrderAmount = BigDecimal.ZERO;
        BigDecimal giftOrderAmount = BigDecimal.ZERO;
        BigDecimal freeOrderAmount = BigDecimal.ZERO;
        BigDecimal remainOrderAmount = orderAmount;
        for (UserBalanceChangeEntity change : (List)changes.getValue()) {
            UserBalanceDetailReleEntity rele;
            UserBalanceDetailEntity detail;
            if (remainOrderAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (change.getUsableMoney().compareTo(remainOrderAmount) >= 0) {
                detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
                if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                    storeOrderAmount = storeOrderAmount.add(remainOrderAmount);
                } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                    giftOrderAmount = giftOrderAmount.add(remainOrderAmount);
                } else {
                    freeOrderAmount = freeOrderAmount.add(remainOrderAmount);
                }
                this.userBalanceChangeInterface.consume(change.getDetailId(), customerId, remainOrderAmount);
                rele = new UserBalanceDetailReleEntity();
                rele.setId(IDGenerate.getUniqueIdStr());
                rele.setExpendId(detailId);
                rele.setIncomeId(change.getDetailId());
                rele.setPayMoney(remainOrderAmount);
                rele.setCreateBy(customerId);
                rele.setCreateTime(new Date());
                this.userBalanceDetailReleInterface.insert((Object)rele);
                remainOrderAmount = BigDecimal.ZERO;
                break;
            }
            detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
            if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                storeOrderAmount = storeOrderAmount.add(change.getUsableMoney());
            } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                giftOrderAmount = giftOrderAmount.add(change.getUsableMoney());
            } else {
                freeOrderAmount = freeOrderAmount.add(change.getUsableMoney());
            }
            this.userBalanceChangeInterface.consume(change.getDetailId(), customerId, change.getUsableMoney());
            rele = new UserBalanceDetailReleEntity();
            rele.setId(IDGenerate.getUniqueIdStr());
            rele.setExpendId(detailId);
            rele.setIncomeId(change.getDetailId());
            rele.setPayMoney(change.getUsableMoney());
            rele.setCreateBy(customerId);
            rele.setCreateTime(new Date());
            this.userBalanceDetailReleInterface.insert((Object)rele);
            remainOrderAmount = remainOrderAmount.subtract(change.getUsableMoney());
        }
        if (storeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceStore = this.userBalanceInterface.decreaseAccount(customerId, storeOrderAmount, BalanceTypeEnum.STORE, customerId, 2);
            if (!userBalanceStore.isSuccess()) {
                throw new RuntimeException(userBalanceStore.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceStore.getValue();
        }
        if (giftOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceGift = this.userBalanceInterface.decreaseAccount(customerId, giftOrderAmount, BalanceTypeEnum.GIFT, customerId, 2);
            if (!userBalanceGift.isSuccess()) {
                throw new RuntimeException(userBalanceGift.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceGift.getValue();
        }
        if (freeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceFree = this.userBalanceInterface.decreaseAccount(customerId, freeOrderAmount, BalanceTypeEnum.FREE, customerId, 2);
            if (!userBalanceFree.isSuccess()) {
                throw new RuntimeException(userBalanceFree.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceFree.getValue();
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(detailId);
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.ORDER.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.ORDER.getName());
        detail.setChangeMoney(orderAmount);
        detail.setAccountTotal(userBalanceEntity.getUsableTotalBalance());
        detail.setAccountStore(userBalanceEntity.getUsableStoreBalance());
        detail.setAccountFree(userBalanceEntity.getUsableFreeBalance());
        detail.setAccountGift(userBalanceEntity.getUsableGiftBalance());
        detail.setOrderMainNo(orderMainNo);
        detail.setDetailStatus(Integer.valueOf(0));
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        dto.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        dto.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        dto.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        dto.setBalanceState(userBalanceEntity.getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setDetailId(detailId);
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(orderAmount);
        changeDTO.setStoreBalanceChange(storeOrderAmount);
        changeDTO.setFreeBalanceChange(freeOrderAmount);
        changeDTO.setGiftBalanceChange(giftOrderAmount);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detail.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.ORDER.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)changeDTO.getTotalBalanceChange()));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)userBalanceEntity.getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        long end = System.currentTimeMillis();
        log.info("\u4e0b\u5355\u6263\u4f59\u989d\u7ed3\u675f" + orderMainNo + "|\u8017\u65f6\uff1a" + (end - start));
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> payOrderWithSpecialCard(String customerId, String orderMainNo, String cardNo, BigDecimal orderAmount) {
        log.info("payOrderWithSpecialCard\u8c03\u7528\u5f00\u59cbcustomerId=" + customerId + ",orderMainNo=" + orderMainNo + ",cardNo=" + cardNo + ",orderAmount=" + orderAmount);
        SpecialCardEntity card = (SpecialCardEntity)this.specialCardInterface.selectByPrimaryKey((Serializable)((Object)cardNo));
        if (card == null) {
            log.info(cardNo + "\u5361\u53f7\u4e0d\u5b58\u5728");
            return BaseJsonVo.error((String)(cardNo + "\u5361\u53f7\u4e0d\u5b58\u5728"));
        }
        if (card.getStatus() != 1) {
            log.info(cardNo + "\u5361\u4e0d\u53ef\u7528");
            return BaseJsonVo.error((String)(cardNo + "\u5361\u4e0d\u53ef\u7528"));
        }
        if (card.getUsableAmount().compareTo(orderAmount) < 0) {
            log.info(cardNo + "\u5361\u4f59\u989d" + card.getUsableAmount() + "\u4e0d\u8db3" + orderAmount);
            return BaseJsonVo.error((String)(cardNo + "\u5361\u4f59\u989d" + card.getUsableAmount() + "\u4e0d\u8db3" + orderAmount));
        }
        SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
        cardLog.setOrderMainNo(orderMainNo);
        List logList = this.specialCardLogInterface.getList((Object)cardLog);
        if (logList != null && logList.size() > 0) {
            log.info("\u8be5\u8ba2\u5355" + orderMainNo + "\u5df2\u7ecf\u6d88\u8d39\u8fc7\u5b9a\u5411\u5361\u4f59\u989d" + cardNo);
            return BaseJsonVo.error((String)("\u8be5\u8ba2\u5355" + orderMainNo + "\u5df2\u7ecf\u6d88\u8d39\u8fc7\u5b9a\u5411\u5361\u4f59\u989d" + cardNo));
        }
        BaseJsonVo payResult = this.specialCardInterface.payOrder(cardNo, orderAmount);
        if (!payResult.isSuccess()) {
            log.info(payResult.getError_msg());
            return payResult;
        }
        card.setUsableAmount(card.getUsableAmount().subtract(orderAmount));
        cardLog = new SpecialCardLogEntity();
        cardLog.setLogType(Integer.valueOf(1));
        cardLog.setCardNo(card.getCardNo());
        cardLog.setChangeMoney(orderAmount);
        cardLog.setTotalAccount(card.getUsableAmount());
        cardLog.setCustomerId(customerId);
        cardLog.setOrderMainNo(orderMainNo);
        cardLog.setCreateTime(DateUtils.now());
        this.specialCardLogInterface.insert((Object)cardLog);
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        BalanceChangeDTO changeDTO = this.buildEmptyChangeDTO(customerId);
        changeDTO.setDetailId(String.valueOf(cardLog.getLogId()));
        changeDTO.setSpecialCardBalanceChange(orderAmount);
        log.info("\u8c03\u7528\u5b8c\u6210");
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> cancleOrder(@RedisLockParameter String customerId, String tradeNo) {
        if (this.redis.get("cancleOrder:" + tradeNo) != null) {
            return BaseJsonVo.success(null);
        }
        this.redis.set("cancleOrder:" + tradeNo, (Object)"LOCK", Long.valueOf(5L));
        log.info("customerId : " + customerId);
        log.info("tradeNo : " + tradeNo);
        UserBalanceDetailEntity paramDetail = new UserBalanceDetailEntity();
        paramDetail.setOrderMainNo(tradeNo);
        List expendList = this.userBalanceDetailInterface.getList((Object)paramDetail);
        if (expendList == null || expendList.size() != 1) {
            SpecialCardLogEntity specialParam = new SpecialCardLogEntity();
            specialParam.setOrderMainNo(tradeNo);
            List specialLogList = this.specialCardLogInterface.getList((Object)specialParam);
            if (specialLogList != null && specialLogList.size() > 0) {
                BaseJsonVo specialCancelResult = this.specialCardInterface.cancelOrder((SpecialCardLogEntity)specialLogList.get(0));
                if (specialCancelResult.isSuccess()) {
                    BalanceChangeDTO changeDTO = this.buildEmptyChangeDTO(customerId);
                    changeDTO.setSpecialCardBalanceChange(((SpecialCardLogEntity)specialLogList.get(0)).getChangeMoney());
                    return BaseJsonVo.success((Object)changeDTO);
                }
                return specialCancelResult;
            }
            throw new RuntimeException("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        UserBalanceDetailEntityExample example = new UserBalanceDetailEntityExample();
        example.createCriteria().andOrderMainNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue()));
        List list = this.userBalanceDetailInterface.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            log.info("\u8fd9\u4e2a\u8ba2\u5355\u5df2\u7ecf\u8c03\u7528\u8fc7\u4e86");
            return BaseJsonVo.success(null);
        }
        String expendDetailId = ((UserBalanceDetailEntity)expendList.get(0)).getId();
        UserBalanceDetailReleEntity paramRele = new UserBalanceDetailReleEntity();
        paramRele.setExpendId(expendDetailId);
        List incomeReleDetails = this.userBalanceDetailReleInterface.getList((Object)paramRele);
        if (incomeReleDetails == null || incomeReleDetails.size() == 0) {
            throw new RuntimeException("\u8ba2\u5355\u6263\u51cf\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        BigDecimal[] storeAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] giftAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] freeAmount = new BigDecimal[]{BigDecimal.ZERO};
        incomeReleDetails.forEach(rele -> {
            rele.setCancelMoney(rele.getPayMoney());
            rele.setUpdateBy(customerId);
            rele.setUpdateTime(new Date());
            this.userBalanceDetailReleInterface.updateByPrimaryKey(rele);
            this.userBalanceChangeInterface.cancleOrRefund(rele.getIncomeId(), rele.getPayMoney(), customerId);
            UserBalanceDetailEntity incomeDetail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
            incomeDetail.setDetailStatus(Integer.valueOf(1));
            this.userBalanceDetailInterface.updateByPrimaryKey((Object)incomeDetail);
            switch (incomeDetail.getDetailSubType()) {
                case 1001: {
                    storeAmount[0] = storeAmount[0].add(rele.getPayMoney());
                    break;
                }
                case 1003: {
                    giftAmount[0] = giftAmount[0].add(rele.getPayMoney());
                    break;
                }
                default: {
                    freeAmount[0] = freeAmount[0].add(rele.getPayMoney());
                }
            }
        });
        BaseJsonVo balance = BaseJsonVo.success((Object)"");
        if (storeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, storeAmount[0], BalanceTypeEnum.STORE, customerId, 1);
        }
        if (giftAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, giftAmount[0], BalanceTypeEnum.GIFT, customerId, 1);
        }
        if (freeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, freeAmount[0], BalanceTypeEnum.FREE, customerId, 1);
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(IDGenerate.getUniqueIdStr());
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.ORDER_CANCEL.getName());
        detail.setChangeMoney(((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney());
        detail.setAccountTotal(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        detail.setAccountStore(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        detail.setAccountFree(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        detail.setAccountGift(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        detail.setOrderMainNo(tradeNo);
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)balance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney());
        changeDTO.setStoreBalanceChange(storeAmount[0]);
        changeDTO.setFreeBalanceChange(freeAmount[0]);
        changeDTO.setGiftBalanceChange(giftAmount[0]);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detail.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.ORDER_CANCEL.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)changeDTO.getTotalBalanceChange()));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)balance.getValue()).getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> refundOrder(@RedisLockParameter String customerId, String tradeNo, BigDecimal refundAmount, String operator) {
        String expendDetailId;
        List incomeReleDetails;
        Long start = System.currentTimeMillis();
        UserBalanceDetailEntity paramDetail = new UserBalanceDetailEntity();
        paramDetail.setOrderMainNo(tradeNo);
        paramDetail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER.getValue()));
        List expendList = this.userBalanceDetailInterface.getList((Object)paramDetail);
        if (expendList == null || expendList.size() == 0) {
            SpecialCardEntity specialParam = new SpecialCardEntity();
            specialParam.setOrderMainNo(tradeNo);
            List specialList = this.specialCardInterface.getList((Object)specialParam);
            if (specialList != null && specialList.size() > 0) {
                BaseJsonVo specialRefundResult = this.specialCardInterface.refundOrder((SpecialCardEntity)specialList.get(0), customerId, operator);
                if (specialRefundResult.isSuccess()) {
                    BalanceChangeDTO changeDTO = this.buildEmptyChangeDTO(customerId);
                    changeDTO.setSpecialCardBalanceChange(((SpecialCardEntity)specialList.get(0)).getUsableAmount());
                    return BaseJsonVo.success((Object)changeDTO);
                }
                return specialRefundResult;
            }
            return BaseJsonVo.error((String)("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728" + tradeNo));
        }
        if (((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney().compareTo(refundAmount) < 0) {
            return BaseJsonVo.error((String)("\u8ba2\u5355" + tradeNo + "\u9000\u6b3e\u91d1\u989d" + refundAmount + "\u8d85\u8fc7\u652f\u4ed8\u91d1\u989d" + ((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney().toString()));
        }
        UserBalanceDetailEntityExample example = new UserBalanceDetailEntityExample();
        example.createCriteria().andOrderMainNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue()));
        List list = this.userBalanceDetailInterface.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            BigDecimal refunded = list.stream().map(UserBalanceDetailEntity::getChangeMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney().compareTo(refundAmount.add(refunded)) < 0) {
                return BaseJsonVo.error((String)("\u8ba2\u5355" + tradeNo + "\u652f\u4ed8\u91d1\u989d\u4e3a" + ((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney().toString() + "\uff0c\u5df2\u9000\u6b3e" + refunded.toString() + ",\u65e0\u6cd5\u5728\u9000" + refundAmount));
            }
        }
        if ((incomeReleDetails = this.userBalanceDetailReleInterface.getUnRefundedList(expendDetailId = ((UserBalanceDetailEntity)expendList.get(0)).getId())) == null || incomeReleDetails.size() == 0) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u6263\u51cf\u8bb0\u5f55\u4e0d\u5b58\u5728" + tradeNo));
        }
        BigDecimal[] storeAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] giftAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] freeAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] remainRefundAmount = new BigDecimal[]{refundAmount};
        for (int i = incomeReleDetails.size() - 1; i >= 0; --i) {
            UserBalanceDetailReleEntity rele = (UserBalanceDetailReleEntity)incomeReleDetails.get(i);
            BigDecimal thisRefund = rele.getPayMoney().subtract(rele.getRefundMoney() == null ? BigDecimal.ZERO : rele.getRefundMoney()).compareTo(remainRefundAmount[0]) >= 0 ? remainRefundAmount[0] : rele.getPayMoney().subtract(rele.getRefundMoney() == null ? BigDecimal.ZERO : rele.getRefundMoney());
            rele.setRefundMoney((rele.getRefundMoney() == null ? BigDecimal.ZERO : rele.getRefundMoney()).add(thisRefund));
            rele.setUpdateBy(operator);
            rele.setUpdateTime(new Date());
            this.userBalanceDetailReleInterface.updateByPrimaryKey((Object)rele);
            this.userBalanceChangeInterface.cancleOrRefund(rele.getIncomeId(), thisRefund, customerId);
            UserBalanceDetailEntity incomeDetail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
            switch (incomeDetail.getDetailSubType()) {
                case 1001: {
                    storeAmount[0] = storeAmount[0].add(thisRefund);
                    break;
                }
                case 1003: {
                    giftAmount[0] = giftAmount[0].add(thisRefund);
                    break;
                }
                default: {
                    freeAmount[0] = freeAmount[0].add(thisRefund);
                }
            }
            remainRefundAmount[0] = remainRefundAmount[0].subtract(thisRefund);
            if (remainRefundAmount[0].compareTo(BigDecimal.ZERO) == 0) break;
        }
        UserBalanceDetailEntity expendDetail = (UserBalanceDetailEntity)expendList.get(0);
        expendDetail.setDetailStatus(Integer.valueOf(2));
        this.userBalanceDetailInterface.updateByPrimaryKey((Object)expendDetail);
        BaseJsonVo balance = BaseJsonVo.success((Object)"");
        if (storeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, storeAmount[0], BalanceTypeEnum.STORE, customerId, 1);
        }
        if (giftAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, giftAmount[0], BalanceTypeEnum.GIFT, customerId, 1);
        }
        if (freeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, freeAmount[0], BalanceTypeEnum.FREE, customerId, 1);
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(IDGenerate.getUniqueIdStr());
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND.getName());
        detail.setChangeMoney(refundAmount);
        detail.setAccountTotal(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        detail.setAccountStore(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        detail.setAccountFree(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        detail.setAccountGift(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        detail.setOrderMainNo(tradeNo);
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetailStore.isSuccess()) {
            return BaseJsonVo.error((String)(tradeNo + userBalanceDetailStore.getError_msg()));
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            return BaseJsonVo.error((String)(tradeNo + cleanResult.getError_msg()));
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)balance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(refundAmount);
        changeDTO.setStoreBalanceChange(storeAmount[0]);
        changeDTO.setFreeBalanceChange(freeAmount[0]);
        changeDTO.setGiftBalanceChange(giftAmount[0]);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detail.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.ORDER_REFUND.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)changeDTO.getTotalBalanceChange()));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)balance.getValue()).getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        Long end = System.currentTimeMillis();
        log.info(tradeNo + "\u8ba2\u5355\u9000\u6b3e\u8017\u65f6\uff1a" + (end - start) + "\u6beb\u79d2");
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> cancelSpecialCardOrder(String cardNo, String orderMainNo, BigDecimal refundAmount, String operator) {
        SpecialCardEntity card;
        log.info("[cancelSpecialCardOrder]cardNo=" + cardNo + "&orderMainNo" + orderMainNo + "&refundAmount=" + refundAmount + "&operator=" + operator);
        if (StringUtils.isEmpty((String)cardNo)) {
            log.info("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundAmount.compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u9000\u6b3e\u91d1\u989d\u9700\u5927\u4e8e0");
            return BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u9700\u5927\u4e8e0");
        }
        if (StringUtils.isEmpty((String)operator)) {
            operator = "";
        }
        if ((card = (SpecialCardEntity)this.specialCardInterface.selectByPrimaryKey((Serializable)((Object)cardNo))) == null || card.getCardNo() == null) {
            return BaseJsonVo.error((String)"\u5361\u53f7\u4e0d\u5b58\u5728");
        }
        if (card.getStatus() != 1) {
            return BaseJsonVo.error((String)"\u5361\u4e0d\u53ef\u7528");
        }
        SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
        cardLog.setOrderMainNo(orderMainNo);
        cardLog.setLogType(Integer.valueOf(1));
        List logList = this.specialCardLogInterface.getList((Object)cardLog);
        if (logList == null || logList.size() == 0) {
            return BaseJsonVo.error((String)("\u6ca1\u6709\u8ba2\u5355[" + orderMainNo + "]\u6d88\u8d39\u8bb0\u5f55"));
        }
        if (((SpecialCardLogEntity)logList.get(0)).getChangeMoney().compareTo(refundAmount) < 0) {
            return BaseJsonVo.error((String)("[" + orderMainNo + "]\u53d6\u6d88\u91d1\u989d" + refundAmount + "\u4e0d\u80fd\u5927\u4e8e\u652f\u4ed8\u91d1\u989d" + ((SpecialCardLogEntity)logList.get(0)).getChangeMoney()));
        }
        BaseJsonVo result = this.specialCardInterface.recordCancelOrder(cardNo, refundAmount, card.getUsableAmount(), orderMainNo, ((SpecialCardLogEntity)logList.get(0)).getCustomerId(), operator);
        if (!result.isSuccess()) {
            return result;
        }
        BalanceChangeDTO changeDTO = this.buildEmptyChangeDTO(((SpecialCardLogEntity)logList.get(0)).getCustomerId());
        changeDTO.setSpecialCardBalanceChange(refundAmount);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> refundSpecialCardOrder(String cardNo, String orderMainNo, BigDecimal refundAmount, String operator) {
        log.info("[refundSpecialCardOrder]cardNo=" + cardNo + "&orderMainNo" + orderMainNo + "&refundAmount=" + refundAmount + "&operator=" + operator);
        if (StringUtils.isEmpty((String)cardNo)) {
            log.info("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundAmount.compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u9000\u6b3e\u91d1\u989d\u9700\u5927\u4e8e0");
            return BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u9700\u5927\u4e8e0");
        }
        if (StringUtils.isEmpty((String)operator)) {
            operator = "";
        }
        Boolean isRefund = StringUtils.isNotEmpty((String)orderMainNo);
        SpecialCardEntity card = (SpecialCardEntity)this.specialCardInterface.selectByPrimaryKey((Serializable)((Object)cardNo));
        if (card == null || card.getCardNo() == null) {
            return BaseJsonVo.error((String)"\u5361\u53f7\u4e0d\u5b58\u5728");
        }
        if (card.getStatus() != 1) {
            return BaseJsonVo.error((String)"\u5361\u4e0d\u53ef\u7528");
        }
        SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
        if (isRefund.booleanValue()) {
            cardLog.setOrderMainNo(orderMainNo);
            cardLog.setLogType(Integer.valueOf(1));
        } else {
            cardLog.setCardNo(cardNo);
            cardLog.setLogType(Integer.valueOf(0));
        }
        List logList = this.specialCardLogInterface.getList((Object)cardLog);
        if (isRefund.booleanValue()) {
            if (logList == null || logList.size() == 0) {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u6d88\u8d39\u8bb0\u5f55");
            }
            if (((SpecialCardLogEntity)logList.get(0)).getChangeMoney().compareTo(refundAmount) < 0) {
                return BaseJsonVo.error((String)("[" + orderMainNo + "]\u9000\u6b3e\u91d1\u989d" + refundAmount + "\u4e0d\u80fd\u5927\u4e8e\u652f\u4ed8\u91d1\u989d" + ((SpecialCardLogEntity)logList.get(0)).getChangeMoney()));
            }
        } else if (logList == null || logList.size() == 0) {
            return BaseJsonVo.error((String)("\u6ca1\u6709[" + cardNo + "]\u50a8\u503c\u8bb0\u5f55"));
        }
        if (!isRefund.booleanValue() && card.getUsableAmount().compareTo(refundAmount) < 0) {
            return BaseJsonVo.error((String)"\u5361\u4f59\u989d\u4e0d\u8db3");
        }
        BaseJsonVo result = isRefund != false ? this.specialCardInterface.recordRefundOrder(cardNo, refundAmount, card.getUsableAmount(), orderMainNo, ((SpecialCardLogEntity)logList.get(0)).getCustomerId(), operator) : this.specialCardInterface.recordRefundUndelivered(cardNo, refundAmount, card.getUsableAmount().subtract(refundAmount), ((SpecialCardLogEntity)logList.get(0)).getCustomerId(), operator);
        if (!result.isSuccess()) {
            return result;
        }
        BalanceChangeDTO changeDTO = this.buildEmptyChangeDTO(((SpecialCardLogEntity)logList.get(0)).getCustomerId());
        changeDTO.setSpecialCardBalanceChange(refundAmount);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> refundCharge(@RedisLockParameter String customerId, String tradeNo, String operator) {
        UserBalanceDetailEntityExample detailStoreExample = new UserBalanceDetailEntityExample();
        detailStoreExample.createCriteria().andOrderMainNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
        List storeDetails = this.userBalanceDetailInterface.selectByExample((Object)detailStoreExample);
        if (storeDetails == null || storeDetails.size() != 1) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u8be5\u50a8\u503c\u6216\u8be5\u50a8\u503c\u5927\u4e8e1\u6761");
        }
        UserBalanceChangeEntityExample changeStoreExample = new UserBalanceChangeEntityExample();
        changeStoreExample.createCriteria().andDetailIdEqualTo(((UserBalanceDetailEntity)storeDetails.get(0)).getId());
        List storeChanges = this.userBalanceChangeInterface.selectByExample((Object)changeStoreExample);
        if (storeChanges == null || storeChanges.size() != 1) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u8be5\u50a8\u503c\u5269\u4f59\u6216\u8be5\u50a8\u503c\u5269\u4f59\u5927\u4e8e1\u6761");
        }
        if (((UserBalanceChangeEntity)storeChanges.get(0)).getUsableMoney().compareTo(BigDecimal.ZERO) <= 0) {
            throw new RuntimeException("\u8be5\u50a8\u503c\u5df2\u7528\u5b8c");
        }
        UserBalanceDetailEntityExample example = new UserBalanceDetailEntityExample();
        example.createCriteria().andOrderMainNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue()));
        List list = this.userBalanceDetailInterface.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            throw new RuntimeException("\u8be5\u50a8\u503c\u4f59\u989d\u5df2\u6263\u9664");
        }
        BigDecimal remainStoreAmount = ((UserBalanceChangeEntity)storeChanges.get(0)).getUsableMoney();
        UserBalanceDetailEntityExample detailFreeExample = new UserBalanceDetailEntityExample();
        detailFreeExample.createCriteria().andOrderMainNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue()));
        List freeDetails = this.userBalanceDetailInterface.selectByExample((Object)detailFreeExample);
        UserBalanceChangeEntityExample changeFreeExample = new UserBalanceChangeEntityExample();
        changeFreeExample.createCriteria().andDetailIdEqualTo(((UserBalanceDetailEntity)freeDetails.get(0)).getId());
        List freeChanges = this.userBalanceChangeInterface.selectByExample((Object)changeFreeExample);
        BigDecimal remainFreeAmount = ((UserBalanceChangeEntity)freeChanges.get(0)).getUsableMoney();
        BaseJsonVo userBalanceStore = this.userBalanceInterface.decreaseAccount(customerId, remainStoreAmount, BalanceTypeEnum.STORE, operator, 1);
        if (!userBalanceStore.isSuccess()) {
            throw new RuntimeException(userBalanceStore.getMessage());
        }
        BaseJsonVo userBalanceFree = this.userBalanceInterface.decreaseAccount(customerId, remainFreeAmount, BalanceTypeEnum.FREE, operator, 1);
        if (!userBalanceFree.isSuccess()) {
            throw new RuntimeException(userBalanceFree.getMessage());
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(IDGenerate.getUniqueIdStr());
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND.getName());
        detailStore.setChangeMoney(remainStoreAmount);
        detailStore.setAccountTotal(((UserBalanceEntity)userBalanceStore.getValue()).getUsableTotalBalance());
        detailStore.setAccountStore(((UserBalanceEntity)userBalanceStore.getValue()).getUsableStoreBalance());
        detailStore.setAccountFree(((UserBalanceEntity)userBalanceStore.getValue()).getUsableFreeBalance());
        detailStore.setAccountGift(((UserBalanceEntity)userBalanceStore.getValue()).getUsableGiftBalance());
        detailStore.setOrderMainNo(tradeNo);
        detailStore.setGiftId(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftId());
        detailStore.setGiftTitle(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftTitle());
        detailStore.setCreateBy(operator);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        UserBalanceDetailEntity detailFree = new UserBalanceDetailEntity();
        detailFree.setId(IDGenerate.getUniqueIdStr());
        detailFree.setCustomerId(customerId);
        detailFree.setDetailType(Integer.valueOf(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getValue() / 1000));
        detailFree.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getValue()));
        detailFree.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getName());
        detailFree.setChangeMoney(remainFreeAmount);
        detailFree.setAccountTotal(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        detailFree.setAccountStore(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        detailFree.setAccountFree(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        detailFree.setAccountGift(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        detailFree.setOrderMainNo(tradeNo);
        detailFree.setGiftId(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftId());
        detailFree.setGiftTitle(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftTitle());
        detailFree.setCreateBy(operator);
        detailFree.setCreateTime(new Date());
        detailFree.setUpdateBy("");
        detailFree.setUpdateTime(null);
        detailFree.setRemark("");
        BaseJsonVo userBalanceDetailFree = this.userBalanceDetailInterface.keepAccountDetail(detailFree);
        if (!userBalanceDetailFree.isSuccess()) {
            throw new RuntimeException(userBalanceDetailFree.getMessage());
        }
        UserBalanceChangeEntity storeChange = (UserBalanceChangeEntity)storeChanges.get(0);
        storeChange.setUsableMoney(BigDecimal.ZERO);
        this.userBalanceChangeInterface.updateByPrimaryKey((Object)storeChange);
        UserBalanceChangeEntity freeChange = (UserBalanceChangeEntity)freeChanges.get(0);
        freeChange.setUsableMoney(BigDecimal.ZERO);
        this.userBalanceChangeInterface.updateByPrimaryKey((Object)freeChange);
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalanceFree.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOStore = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOStore.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTOStore.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTOStore.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTOStore.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOStore);
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOFree = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOFree.setCash(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getChangeMoney().toString());
        detailRecordDTOFree.setTime(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getCreateTime());
        detailRecordDTOFree.setWealth(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getAccountTotal().toString());
        detailRecordDTOFree.setTitle(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOFree);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(remainStoreAmount.add(remainFreeAmount));
        changeDTO.setStoreBalanceChange(remainStoreAmount);
        changeDTO.setFreeBalanceChange(remainFreeAmount);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detailStore.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.STORE_REFUND.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)changeDTO.getTotalBalanceChange()));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> activeCharge(@RedisLockParameter String customerId, BigDecimal increaseAmount, String detailSubTypeDesc, Boolean notice, String noticeText, String remark) {
        BaseJsonVo userBalance = this.userBalanceInterface.increaseAccount(customerId, increaseAmount, BalanceTypeEnum.FREE, customerId, 2);
        if (!userBalance.isSuccess()) {
            throw new RuntimeException(userBalance.getMessage());
        }
        UserBalanceDetailEntityExample example = new UserBalanceDetailEntityExample();
        example.createCriteria().andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue())).andDetailSubTypeDescEqualTo(detailSubTypeDesc);
        List list = this.userBalanceDetailInterface.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            throw new RuntimeException("\u8be5\u8ba2\u5355\u4f59\u989d\u5df2\u8fd4\u56de");
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(IDGenerate.getUniqueIdStr());
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
        detailStore.setChangeMoney(increaseAmount);
        detailStore.setAccountTotal(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        detailStore.setAccountStore(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        detailStore.setAccountFree(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        detailStore.setAccountGift(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        detailStore.setOrderMainNo("");
        detailStore.setCreateBy(customerId);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark(detailSubTypeDesc);
        BaseJsonVo userBalanceDetail = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetail.isSuccess()) {
            throw new RuntimeException(userBalanceDetail.getMessage());
        }
        BaseJsonVo userBalanceChange = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getId(), increaseAmount, customerId);
        if (!userBalanceChange.isSuccess()) {
            throw new RuntimeException(userBalanceChange.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        if (notice.booleanValue()) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("detailTypeDesc", detailStore.getDetailSubTypeDesc());
            param.put("type", DetailTypeEnum.ACTIVE_FREE.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
            param.put("balanceChange", PriceUtils.parse((BigDecimal)increaseAmount));
            param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance()));
            BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
            if (!sendResult.isSuccess()) {
                log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
            } else {
                log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
            }
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetail.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(increaseAmount);
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(increaseAmount);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> increaseManual(@RedisLockParameter String customerId, BigDecimal increaseAmount, String operator, String detailSubTypeDesc) {
        BaseJsonVo userBalance = this.userBalanceInterface.increaseAccount(customerId, increaseAmount, BalanceTypeEnum.FREE, operator, 2);
        if (!userBalance.isSuccess()) {
            throw new RuntimeException(userBalance.getMessage());
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(IDGenerate.getUniqueIdStr());
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.MANUAL_INCREASE.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_INCREASE.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_INCREASE.getName());
        detailStore.setChangeMoney(increaseAmount);
        detailStore.setAccountTotal(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        detailStore.setAccountStore(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        detailStore.setAccountFree(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        detailStore.setAccountGift(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        detailStore.setOrderMainNo("");
        detailStore.setCreateBy(operator);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark(detailSubTypeDesc);
        BaseJsonVo userBalanceDetail = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetail.isSuccess()) {
            throw new RuntimeException(userBalanceDetail.getMessage());
        }
        BaseJsonVo userBalanceChange = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getId(), increaseAmount, operator);
        if (!userBalanceChange.isSuccess()) {
            throw new RuntimeException(userBalanceChange.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        TemplateMessageDTO tempMsg = new TemplateMessageDTO();
        tempMsg.setActionId("BALANCE_NOTICE");
        tempMsg.setCustomerId(customerId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detailStore.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.MANUAL_INCREASE.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)increaseAmount));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance()));
        tempMsg.setParams(param);
        String paramString = JsonUtils.toJson(param, (boolean)false);
        log.info(">>>>>>>>>" + paramString);
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", paramString);
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetail.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(increaseAmount);
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(increaseAmount);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @RedisLock(key="BalanceLock", expire=7L, waitTime=60L)
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> reduceManual(@RedisLockParameter String customerId, BigDecimal reduceAmount, String operator, String remark) {
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        if (userBalanceEntity == null || userBalanceEntity.getBalanceState() == 0) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u5220\u9664");
        }
        if (userBalanceEntity.getBalanceState() == 2) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u505c\u7528");
        }
        if (userBalanceEntity.getUsableTotalBalance().compareTo(reduceAmount) < 0) {
            throw new RuntimeException("\u4f59\u989d\u4e0d\u8db3");
        }
        BaseJsonVo changes = this.userBalanceChangeInterface.findChanges(customerId);
        if (!changes.isSuccess()) {
            throw new RuntimeException(changes.getMessage());
        }
        if (((List)changes.getValue()).stream().map(UserBalanceChangeEntity::getUsableMoney).reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(userBalanceEntity.getUsableTotalBalance()) != 0) {
            throw new RuntimeException("\u8d26\u6237\u4f59\u989d\u4e0e\u5269\u4f59\u91d1\u989d\u4e0d\u7b26");
        }
        String detailId = IDGenerate.getUniqueIdStr();
        BigDecimal storeOrderAmount = BigDecimal.ZERO;
        BigDecimal giftOrderAmount = BigDecimal.ZERO;
        BigDecimal freeOrderAmount = BigDecimal.ZERO;
        BigDecimal remainOrderAmount = reduceAmount;
        for (UserBalanceChangeEntity change : (List)changes.getValue()) {
            UserBalanceDetailReleEntity rele;
            UserBalanceDetailEntity detail;
            if (remainOrderAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (change.getUsableMoney().compareTo(remainOrderAmount) >= 0) {
                detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
                if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                    storeOrderAmount = storeOrderAmount.add(remainOrderAmount);
                } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                    giftOrderAmount = giftOrderAmount.add(remainOrderAmount);
                } else {
                    freeOrderAmount = freeOrderAmount.add(remainOrderAmount);
                }
                this.userBalanceChangeInterface.consume(change.getDetailId(), operator, remainOrderAmount);
                rele = new UserBalanceDetailReleEntity();
                rele.setId(IDGenerate.getUniqueIdStr());
                rele.setExpendId(detailId);
                rele.setIncomeId(change.getDetailId());
                rele.setPayMoney(remainOrderAmount);
                rele.setCreateBy(operator);
                rele.setCreateTime(new Date());
                this.userBalanceDetailReleInterface.insert((Object)rele);
                remainOrderAmount = BigDecimal.ZERO;
                break;
            }
            detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
            if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                storeOrderAmount = storeOrderAmount.add(change.getUsableMoney());
            } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                giftOrderAmount = giftOrderAmount.add(change.getUsableMoney());
            } else {
                freeOrderAmount = freeOrderAmount.add(change.getUsableMoney());
            }
            this.userBalanceChangeInterface.consume(change.getDetailId(), operator, change.getUsableMoney());
            rele = new UserBalanceDetailReleEntity();
            rele.setId(IDGenerate.getUniqueIdStr());
            rele.setExpendId(detailId);
            rele.setIncomeId(change.getDetailId());
            rele.setPayMoney(change.getUsableMoney());
            rele.setCreateBy(operator);
            rele.setCreateTime(new Date());
            this.userBalanceDetailReleInterface.insert((Object)rele);
            remainOrderAmount = remainOrderAmount.subtract(change.getUsableMoney());
        }
        if (storeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceStore = this.userBalanceInterface.decreaseAccount(customerId, storeOrderAmount, BalanceTypeEnum.STORE, operator, 2);
            if (!userBalanceStore.isSuccess()) {
                throw new RuntimeException(userBalanceStore.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceStore.getValue();
        }
        if (giftOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceGift = this.userBalanceInterface.decreaseAccount(customerId, giftOrderAmount, BalanceTypeEnum.GIFT, operator, 2);
            if (!userBalanceGift.isSuccess()) {
                throw new RuntimeException(userBalanceGift.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceGift.getValue();
        }
        if (freeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceFree = this.userBalanceInterface.decreaseAccount(customerId, freeOrderAmount, BalanceTypeEnum.FREE, operator, 2);
            if (!userBalanceFree.isSuccess()) {
                throw new RuntimeException(userBalanceFree.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceFree.getValue();
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(detailId);
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.MANUAL_DECREASE.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_DECREASE.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_DECREASE.getName());
        detailStore.setChangeMoney(reduceAmount);
        detailStore.setAccountTotal(userBalanceEntity.getUsableTotalBalance());
        detailStore.setAccountStore(userBalanceEntity.getUsableStoreBalance());
        detailStore.setAccountFree(userBalanceEntity.getUsableFreeBalance());
        detailStore.setAccountGift(userBalanceEntity.getUsableGiftBalance());
        detailStore.setOrderMainNo("");
        detailStore.setCreateBy(operator);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark(remark);
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("detailTypeDesc", detailStore.getDetailSubTypeDesc());
        param.put("type", DetailTypeEnum.MANUAL_DECREASE.getValue() / 1000 == 1 ? "\u589e\u52a0" : "\u51cf\u5c11");
        param.put("balanceChange", PriceUtils.parse((BigDecimal)reduceAmount));
        param.put("balanceAccount", PriceUtils.parse((BigDecimal)userBalanceEntity.getUsableTotalBalance()));
        BaseJsonVo sendResult = this.tempMsgApi.sendTempMsg("BALANCE_NOTICE", customerId, "", JsonUtils.toJson(param, (boolean)false));
        if (!sendResult.isSuccess()) {
            log.error("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u5931\u8d25\uff1a" + sendResult.getError_msg() + "|" + JsonUtils.toJson(param, (boolean)false));
        } else {
            log.info("\u4f59\u989d\u53d8\u52a8\u53d1\u9001\u6210\u529f");
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        dto.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        dto.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        dto.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        dto.setBalanceState(userBalanceEntity.getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(reduceAmount);
        changeDTO.setStoreBalanceChange(storeOrderAmount);
        changeDTO.setFreeBalanceChange(freeOrderAmount);
        changeDTO.setGiftBalanceChange(giftOrderAmount);
        return BaseJsonVo.success((Object)changeDTO);
    }

    private BaseJsonVo cleanBalanceCache(String customerId) {
        this.redis.remove("BalanceAccountDetail:" + customerId);
        this.redis.remove("BalanceAccount:" + customerId);
        return BaseJsonVo.success((Object)"");
    }

    private BalanceChangeDTO buildEmptyChangeDTO(String customerId) {
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        dto.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        dto.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        dto.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        dto.setBalanceState(userBalanceEntity.getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        detailDTO.setUserBalance(dto);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(BigDecimal.ZERO);
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(BigDecimal.ZERO);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return changeDTO;
    }
}

