/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service;

import cc.lechun.balance.iservice.BaseInterface;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.core.baseclass.BaseDaoEx;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseService<T, PK extends Serializable, Example>
implements BaseInterface<T, PK, Example> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected BaseDaoEx<T, PK, Example> baseDao;
    @Autowired
    protected RedisCacheUtil redisCacheUtil;
    private String cachselectByPrimaryKey = this.getClass().getName() + "_select_";
    private String cachgetList = this.getClass().getName() + "_getlist_";
    private String cachsingle = this.getClass().getName() + "_single_";
    private String cachexists = this.getClass().getName() + "_exists_";
    private String cachexistsEntity = this.getClass().getName() + "_existsEntity_";
    private String cachgetSelectExample = this.getClass().getName() + "_SelectExample_";
    private String cachgetCountExample = this.getClass().getName() + "_CountExample_";
    private String cachPrimaryKey2 = this.getClass().getName() + "_PK2_";

    protected <T> T getService(T t) {
        return (T)SpringContextUtil.getBean((Class)((Class)t));
    }

    public int deleteByPrimaryKey(PK var1) {
        if (this.remoteCache(var1)) {
            return this.baseDao.deleteByPrimaryKey(var1);
        }
        return 0;
    }

    public int insert(T var1) {
        if (this.remoteCache(var1)) {
            return this.baseDao.insert(var1);
        }
        return 0;
    }

    public int insertSelective(T var1) {
        if (this.remoteCache(var1)) {
            return this.baseDao.insert(var1);
        }
        return 0;
    }

    public int updateByPrimaryKeySelective(T var1) {
        if (this.remoteCache(var1)) {
            return this.baseDao.updateByPrimaryKeySelective(var1);
        }
        return 0;
    }

    public int updateByPrimaryKey(T var1) {
        if (this.remoteCache(var1)) {
            return this.baseDao.updateByPrimaryKeySelective(var1);
        }
        return 0;
    }

    public int batchInsert(List<T> entities) {
        if (entities == null || entities.size() == 0) {
            return 0;
        }
        for (T t : entities) {
            if (this.remoteCache(t)) continue;
            return 0;
        }
        return this.baseDao.batchInsert(entities);
    }

    public int batchUpdate(List<T> entities) {
        if (entities == null || entities.size() == 0) {
            return 0;
        }
        for (T t : entities) {
            if (this.remoteCache(t)) continue;
            return 0;
        }
        return this.baseDao.batchUpdate(entities);
    }

    public int batchDelete(PK[] pks) {
        if (pks == null || pks.length == 0) {
            return 0;
        }
        for (PK t : pks) {
            if (this.remoteCache(t)) continue;
            return 0;
        }
        return this.baseDao.batchDelete(pks);
    }

    public T selectByPrimaryKey(PK var1) {
        Object o = this.redisCacheUtil.get(this.cachselectByPrimaryKey + var1);
        if (o != null) {
            return (T)o;
        }
        Object t = this.baseDao.selectByPrimaryKey(var1);
        if (t != null) {
            this.redisCacheUtil.set(this.cachselectByPrimaryKey + var1, t, Long.valueOf(600L));
        }
        return (T)t;
    }

    public List<T> getList(T var1) {
        String key = this.cachgetList + var1.hashCode();
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (List)o;
        }
        List ts = this.baseDao.getList(var1);
        if (ts != null && ts.size() > 0) {
            if (ts.size() > 100) {
                return ts;
            }
            this.redisCacheUtil.set(key, (Object)ts, Long.valueOf(600L));
            for (Object t : ts) {
                Serializable pk = this.getPrimaryKey(t);
                this.redisCacheUtil.setCacheSet(this.cachPrimaryKey2 + pk, new Object[]{key});
            }
        }
        return ts;
    }

    public List<T> selectByExample(Example var1) {
        String key = this.cachgetSelectExample + var1.hashCode();
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (List)o;
        }
        List ts = this.baseDao.selectByExample(var1);
        if (ts != null && ts.size() > 0) {
            if (ts.size() > 100) {
                return ts;
            }
            this.redisCacheUtil.set(key, (Object)ts, Long.valueOf(600L));
            for (Object t : ts) {
                Serializable pk = this.getPrimaryKey(t);
                this.redisCacheUtil.setCacheSet(this.cachPrimaryKey2 + pk, new Object[]{key});
            }
        }
        return ts;
    }

    public int countByExample(Example var1) {
        return this.baseDao.countByExample(var1);
    }

    public int existsByEntity(T var1) {
        return this.baseDao.existsByEntity(var1);
    }

    public int exists(PK var1) {
        Object o = this.redisCacheUtil.get(this.cachexists + var1);
        if (o != null) {
            return (Integer)o;
        }
        Integer i = this.baseDao.exists(var1);
        if (i > 0) {
            this.redisCacheUtil.set(this.cachexists + var1, (Object)i, Long.valueOf(600L));
        }
        return i;
    }

    public T getSingle(T var1) {
        Object o = this.redisCacheUtil.get(this.cachsingle + var1.hashCode());
        if (o != null) {
            return (T)o;
        }
        Object t = this.baseDao.getSingle(var1);
        if (t != null) {
            this.redisCacheUtil.set(this.cachsingle + var1.hashCode(), t, Long.valueOf(600L));
            Serializable pk = this.getPrimaryKey(t);
            this.redisCacheUtil.setCacheSet(this.cachPrimaryKey2 + pk, new Object[]{this.cachsingle + var1.hashCode()});
        }
        return (T)t;
    }

    protected boolean remoteCache(PK pk) {
        if (pk == null) {
            return true;
        }
        try {
            this.redisCacheUtil.remove(this.cachselectByPrimaryKey + pk);
            Set set = this.redisCacheUtil.getCacheSet(this.cachPrimaryKey2 + pk);
            if (set != null && set.size() > 0) {
                for (String str : set) {
                    this.redisCacheUtil.remove(str);
                }
                this.redisCacheUtil.remove(this.cachPrimaryKey2 + pk);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected boolean remoteCache(T var1) {
        return this.remoteCache(this.getPrimaryKey(var1));
    }

    private PK getPrimaryKey(T var1) {
        Serializable fieldValue = null;
        try {
            Method getMethod = var1.getClass().getMethod("accessPrimaryKeyValue", null);
            fieldValue = (Serializable)getMethod.invoke(var1, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (PK)fieldValue;
    }
}

