/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.channel;

import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.baseservice.model.sms.TaskEntity;
import cc.lechun.baseservice.service.TaskInterface;
import cc.lechun.baseservice.service.apiinvoke.active.ActiveInvoke;
import cc.lechun.baseservice.service.channel.MessageHandle;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageContext
extends BaseService {
    private final Map<String, MessageHandle> messageHandleMap = new ConcurrentHashMap<String, MessageHandle>();
    @Autowired
    private ActiveInvoke activeInvoke;
    @Autowired
    private TaskInterface taskInterface;

    @Autowired
    public MessageContext(Map<String, MessageHandle> messageHandle) {
        this.messageHandleMap.clear();
        messageHandle.forEach((k, v) -> this.messageHandleMap.put((String)k, (MessageHandle)v));
    }

    public BaseJsonVo pushMessage(Map<String, Object> param) {
        String action = param.get("action").toString();
        Integer platformId = Integer.valueOf(param.get("platformId").toString());
        List list = (List)param.get("action");
        if (list != null) {
            String tempId = "";
            if (list.size() > 0) {
                TaskEntity task = this.taskInterface.getTaskEntityById(((UserMessageVo)list.get(0)).getTaskId());
                if (task.getTemplateId() != null) {
                    tempId = task.getTemplateId().toString();
                } else {
                    return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u6a21\u677f");
                }
            }
            String id = tempId;
            list.forEach(userMessageVo -> this.pushMessage((UserMessageVo)userMessageVo, platformId));
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo pushMessage(UserMessageVo messageVo, Integer platformId) {
        MessageHandle messageHandle;
        if (messageVo != null && (messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(messageVo.getType()))) != null) {
            try {
                messageHandle.pushMessage(messageVo);
                if (StringUtils.isNotEmpty((String)messageVo.getActiveNo())) {
                    if (StringUtils.isNotEmpty((String)messageVo.getCustomerId())) {
                        this.activeInvoke.sendCash(messageVo.getActiveNo(), messageVo.getCustomerId(), platformId);
                    } else {
                        this.logger.info("\u7528\u6237customerId\u4e3a\u7a7a\uff0c\u4e0d\u53d1\u9001\u4f18\u60e0\u5238", (Object)messageVo.toString());
                    }
                } else {
                    this.logger.info("\u4efb\u52a1:{}\u672a\u5173\u8054\u6d3b\u52a8\uff0c\u4e0d\u53d1\u9001\u4f18\u60e0\u5238", (Object)messageVo.getTaskId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }

    public BaseJsonVo pushMessage(SendMessageVo sendMessageVo) {
        MessageHandle messageHandle;
        if (sendMessageVo != null && (messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(sendMessageVo.getType()))) != null) {
            return messageHandle.pushMessage(sendMessageVo);
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }
}

