/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.channel;

import cc.lechun.baseservice.constant.BaseResultEnum;
import cc.lechun.baseservice.constant.MessagePushStatusEnum;
import cc.lechun.baseservice.dao.MessageMapper;
import cc.lechun.baseservice.entity.AppEntity;
import cc.lechun.baseservice.entity.TemplateEntity;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.exception.BaseException;
import cc.lechun.baseservice.model.sms.MessageContentDTO;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.baseservice.service.IAppService;
import cc.lechun.baseservice.service.ITemplateService;
import cc.lechun.baseservice.service.channel.ChannelMessageBase;
import cc.lechun.baseservice.service.channel.MessageHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.sms.service.IMessageService;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SMS")
public class SmsMessage
extends BaseService
implements MessageHandle {
    @Autowired
    private IMessageService messageService;
    @Autowired
    private ChannelMessageBase channelMessageBase;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private IAppService appService;

    @Override
    public void pushMessage(UserMessageVo userMessageVo) {
        TemplateEntity template = this.templateService.getTemplateEntity(Integer.valueOf(userMessageVo.getTemplateId()));
        if (template == null) {
            throw new BaseException(BaseResultEnum.TEMPLATE_NOT_EXIST);
        }
        AppEntity app = this.appService.getAppEntity(template.getAppId());
        if (app == null) {
            throw new BaseException(BaseResultEnum.APP_NOT_EXIST);
        }
        MessageContentDTO messageDTO = new MessageContentDTO();
        messageDTO.setMobile(userMessageVo.getMobile());
        messageDTO.setContent(this.renderString(template.getTemplate(), userMessageVo.getParams()));
        BaseJsonVo result = this.messageService.send(messageDTO);
        int status = result.isSuccess() ? MessagePushStatusEnum.SUCCESS.getValue() : MessagePushStatusEnum.FAIL.getValue();
        this.channelMessageBase.saveUserMessageRecord(userMessageVo, status);
    }

    @Override
    public BaseJsonVo pushMessage(SendMessageVo sendMessageVo) {
        MessageContentDTO messageDTO = new MessageContentDTO();
        messageDTO.setMobile(sendMessageVo.getAccount());
        messageDTO.setContent(sendMessageVo.getContent());
        return this.messageService.send(messageDTO);
    }

    private String getValidateCode(byte length) {
        int base = (int)Math.pow(10.0, length - 1);
        int result = new Random().nextInt(9 * base) + base;
        return String.valueOf(result);
    }

    private String renderString(String content, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> sets = map.entrySet();
        for (Map.Entry<String, Object> entry : sets) {
            String regex = "\\$\\{" + entry.getKey() + "}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll(String.valueOf(entry.getValue()));
        }
        return content;
    }
}

