/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.dao.AppMapper;
import cc.lechun.baseservice.entity.AppEntity;
import cc.lechun.baseservice.model.sms.AppQueryDTO;
import cc.lechun.baseservice.service.IAppService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppService
implements IAppService {
    private static final Logger logger = LoggerFactory.getLogger(AppService.class);
    @Autowired
    private AppMapper appMapper;
    @Autowired
    protected MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="AppService.getAppEntity", expiration=300)
    public AppEntity getAppEntity(@ParameterValueKeyProvider Integer appId) {
        return (AppEntity)this.appMapper.selectByPrimaryKey(appId);
    }

    @Override
    public BaseJsonVo saveApp(AppEntity appEntity) {
        logger.info("\u5e94\u7528\u5bf9\u8c61:{}", (Object)appEntity.toString());
        int result = 0;
        if (appEntity.getId() == null) {
            appEntity.setUpdateDate(DateUtils.now());
            appEntity.setCreateDate(DateUtils.now());
            result = this.appMapper.insertSelective(appEntity);
        } else {
            this.removeCache(appEntity);
            appEntity.setUpdateDate(DateUtils.now());
            result = this.appMapper.updateByPrimaryKeySelective(appEntity);
        }
        return result >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public PageInfo getAppList(AppQueryDTO appQueryDTO) {
        Page page = PageHelper.startPage((int)appQueryDTO.getCurrentPage(), (int)appQueryDTO.getPageSize()).setOrderBy(" id DESC ");
        AppEntity appEntity = new AppEntity();
        List list = this.appMapper.getList(appEntity);
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    private void removeCache(AppEntity appEntity) {
        this.memcachedService.delete("AppService.getAppEntity", appEntity.getId().toString());
    }
}

