/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.constant.PeriodTypeEnum;
import cc.lechun.baseservice.constant.TaskStatusEnum;
import cc.lechun.baseservice.dao.TaskMapper;
import cc.lechun.baseservice.entity.GroupDetailEntity;
import cc.lechun.baseservice.entity.GroupDetailQuery;
import cc.lechun.baseservice.entity.TaskVo;
import cc.lechun.baseservice.entity.TemplateEntity;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.TaskEntity;
import cc.lechun.baseservice.model.sms.TaskQueryVo;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.service.ITemplateService;
import cc.lechun.baseservice.service.TaskInterface;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TaskService
extends BaseService
implements TaskInterface {
    @Autowired
    private RedisService redisService;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private UserInterface userService;
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Lazy
    @Autowired
    private ITemplateService templateService;
    private final String MESSAGE_REDIS_KEY = "MESSAGE_REDIS_KEY";
    private final String UNSEND_MESSAGE_REDIS_KEY = "UNSEND_MESSAGE_REDIS_KEY";

    @Override
    public BaseJsonVo saveTask(TaskEntity taskEntity) {
        if (taskEntity.getId() == null || taskEntity.getId() == 0) {
            return this.taskMapper.insert(taskEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        TaskEntity taskItem = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskEntity.getId());
        if (taskItem.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            return BaseJsonVo.error((String)("\u4efb\u52a1" + TaskStatusEnum.getName(taskItem.getTaskStatus()) + "\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        this.taskMapper.updateByPrimaryKeySelective(taskEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    @Override
    public PageInfo getTaskList(TaskQueryVo taskQueryVo) {
        Page page = PageHelper.startPage((int)taskQueryVo.getCurrentPage(), (int)taskQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        TaskEntity query = new TaskEntity();
        query.setBeginTime(taskQueryVo.getBeginTime());
        query.setEndTime(taskQueryVo.getEndTime());
        query.setTaskName(taskQueryVo.getTaskName());
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(query);
        ArrayList userGroupVos = new ArrayList();
        for (TaskEntity task : list) {
            TaskVo taskVo = new TaskVo();
            BeanUtils.copyProperties((Object)task, (Object)taskVo);
            taskVo.setActiveName("");
            TemplateEntity templateEntity = this.templateService.getTemplateEntity(task.getTemplateId());
            taskVo.setContent(templateEntity == null ? "" : templateEntity.getTemplate());
            UserGroupEntity groupEntity = this.userGroupInterface.getGroup(task.getGroupId());
            taskVo.setGroupName(groupEntity == null ? "" : groupEntity.getUserGroupName());
            taskVo.setMessageTypeName(MessageTypeEnum.getName(task.getMessageType()));
            taskVo.setPeriodTypeName(PeriodTypeEnum.getName(task.getPeriodType()));
            taskVo.setTaskStatusName(TaskStatusEnum.getName(task.getTaskStatus()));
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(userGroupVos);
        return pg;
    }

    @Override
    public void pullUserToRedis() {
        int pageSize = 1000;
        try {
            TaskEntity task = new TaskEntity();
            task.setTaskStatus(Integer.valueOf(1));
            task.setExecTime(DateUtils.now());
            task.setBeginTime(DateUtils.now());
            task.setEndTime(DateUtils.now());
            List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
            if (list != null && list.size() > 0) {
                list.forEach(taskItem -> this.pullUserToRedis((TaskEntity)taskItem));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pullUserToRedis(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            this.pullUserToRedis(task);
        } else {
            this.logger.error("\u65e0\u6548\u7684\u4efb\u52a1:{}", (Object)taskId);
        }
    }

    @Override
    public void pullUserToRedis(TaskEntity task) {
        int pageSize = 1000;
        int i = 0;
        while (true) {
            GroupDetailQuery groupDetailQuery = new GroupDetailQuery();
            groupDetailQuery.setCurrentPage(i);
            groupDetailQuery.setPageSize(pageSize);
            List userList = this.userService.getUserByGroupId(groupDetailQuery).getList();
            userList.forEach(userItem -> {
                boolean addSuccess = this.redisService.sadd("MESSAGE_REDIS_KEY:" + task.getId().toString(), userItem);
                if (addSuccess) {
                    this.redisService.sadd("UNSEND_MESSAGE_REDIS_KEY:" + task.getId().toString(), userItem);
                }
            });
            if (userList == null || userList.size() < 10000) break;
            ++i;
        }
        TaskEntity update = new TaskEntity();
        update.setTaskStatus(Integer.valueOf(2));
        update.setId(task.getId());
        if (this.taskMapper.updateByPrimaryKeySelective(update) > 0) {
            this.logger.info("\u4efb\u52a1:{},{},\u6d88\u606f\u63a8\u9001\u4e2d..." + task.getTaskName(), (Object)task.getId());
        }
    }

    @Override
    public void pullUserToMq() {
        Integer perSize = 100;
        TaskEntity task = new TaskEntity();
        task.setTaskStatus(Integer.valueOf(2));
        task.setExecTime(DateUtils.now());
        task.setBeginTime(DateUtils.now());
        task.setEndTime(DateUtils.now());
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
        list.forEach(taskItem -> {
            Integer popNumPage = 1000;
            popNumPage = popNumPage == null || popNumPage == 0 ? 50 : popNumPage;
            for (int i = 0; i < popNumPage; ++i) {
                ArrayList<UserMessageVo> messageList = new ArrayList<UserMessageVo>();
                for (int j = 0; j < perSize; ++j) {
                    GroupDetailEntity user = (GroupDetailEntity)this.redisService.spop("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId());
                    if (user == null) {
                        i = popNumPage;
                        break;
                    }
                    this.redisService.sremove("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId(), user);
                    UserMessageVo messageVo = new UserMessageVo();
                    BeanUtils.copyProperties((Object)user, (Object)messageVo);
                    messageVo.setTaskId(taskItem.getId());
                    messageVo.setActiveNo(taskItem.getActiveNo());
                    UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(user.getGroupId());
                    messageVo.setGroupType(userGroupEntity != null ? userGroupEntity.getGroupType() : 0);
                    messageList.add(messageVo);
                }
                this.logger.info("\u8981\u63a8\u9001\u6a21\u677f\u6d88\u606f\u4e86[" + i + "]\uff1a" + JsonUtils.toJson(messageList, (boolean)true));
                this.pushNoticeMQ("AllSubscribes", "all", messageList, i, 1);
            }
        });
    }

    private void pushNoticeMQ(String customerType, String action, List<UserMessageVo> taskList, int pageNum, Integer platformId) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("action", action);
        messageMap.put("list", taskList);
        messageMap.put("platformId", platformId);
        this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6d88\u606f\uff1a" + JsonUtils.toJson(messageMap, (boolean)true));
        MessageResult mr = this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.templeteMessageSend, new MessageParam(String.valueOf(pageNum), messageMap));
        this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a" + mr.isStatus() + "  " + mr.getMsg().toString());
    }

    @Override
    public TaskEntity getTaskEntityById(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task == null) {
            return new TaskEntity();
        }
        return task;
    }

    @Override
    public BaseJsonVo approveTask(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            if (task.getTaskStatus() == 0) {
                TaskEntity update = new TaskEntity();
                update.setId(taskId);
                update.setTaskStatus(Integer.valueOf(1));
                this.taskMapper.updateByPrimaryKeySelective(update);
                return BaseJsonVo.success((Object)"\u5ba1\u6838\u6210\u529f");
            }
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5df2\u5ba1\u6838\u8fc7");
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
    }
}

