/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.GroupTypeEnum;
import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.dao.UserGroupMapper;
import cc.lechun.baseservice.entity.UserGroupVo;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.model.sms.UserGroupQueryVo;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserGroupService
extends BaseService
implements UserGroupInterface {
    @Autowired
    private UserGroupMapper userGroupMapper;

    @Override
    public BaseJsonVo saveGroup(UserGroupEntity userGroupEntity) {
        if (userGroupEntity.getId() == null || userGroupEntity.getId() == 0) {
            return this.userGroupMapper.insert(userGroupEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        this.userGroupMapper.updateByPrimaryKeySelective(userGroupEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    @Override
    @ReadThroughSingleCache(namespace="UserGroupService.getGroup", expiration=300)
    public UserGroupEntity getGroup(@ParameterValueKeyProvider int groupId) {
        return (UserGroupEntity)this.userGroupMapper.selectByPrimaryKey(Integer.valueOf(groupId));
    }

    @Override
    public PageInfo getUserGroupList(UserGroupQueryVo userGroupQueryVo) {
        Page page = PageHelper.startPage((int)userGroupQueryVo.getCurrentPage(), (int)userGroupQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        List<UserGroupEntity> list = this.userGroupMapper.getUserGrouList(userGroupQueryVo);
        ArrayList<UserGroupVo> userGroupVos = new ArrayList<UserGroupVo>();
        for (UserGroupEntity group : list) {
            UserGroupVo userGroupVo = new UserGroupVo();
            BeanUtils.copyProperties((Object)group, (Object)userGroupVo);
            userGroupVo.setGroupTypeName(GroupTypeEnum.getName(group.getGroupType()));
            userGroupVo.setMessageTypeName(MessageTypeEnum.getName(group.getGroupType()));
            userGroupVo.setStatusName(group.getStatus() == 1 ? "\u5df2\u66f4\u65b0" : "\u672a\u66f4\u65b0");
            userGroupVos.add(userGroupVo);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(userGroupVos);
        return pg;
    }
}

