/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.crowd;

import cc.lechun.active.dao.crowd.CrowdActiveConfigMapper;
import cc.lechun.active.dao.crowd.CrowdCommonConfigMapper;
import cc.lechun.active.dao.crowd.CrowdFundingForumMapper;
import cc.lechun.active.dao.crowd.CrowdFundingMapper;
import cc.lechun.active.dao.crowd.CrowdPicMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.entity.crowd.CrowdActiveConfigEntity;
import cc.lechun.active.entity.crowd.CrowdCommonConfigEntity;
import cc.lechun.active.entity.crowd.CrowdCouponVo;
import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.entity.crowd.CrowdFundingForumEntity;
import cc.lechun.active.entity.crowd.CrowdFundingForumVo;
import cc.lechun.active.entity.crowd.CrowdInviteVo;
import cc.lechun.active.entity.crowd.CrowdPicEntity;
import cc.lechun.active.entity.crowd.InviteCustomerVo;
import cc.lechun.active.entity.crowd.MallCrowdfundingListVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.refund.ActiveRefundContext;
import cc.lechun.active.service.refund.ActiveRefundHandle;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.templatemessage.MiniSubscribeMessage;

@Service
public class CrowdService
extends ActiveBaseService
implements CrowdInterface {
    @Autowired
    private CrowdCommonConfigMapper crowdCommonConfigMapper;
    @Autowired
    private CrowdFundingMapper crowdFundingMapper;
    @Autowired
    private ActiveRuleInterface activeRuleInterface;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    MallTradeInterface tradeInterface;
    @Autowired
    private CrowdActiveConfigMapper crowdActiveConfigMapper;
    @Autowired
    private CrowdFundingForumMapper crowdFundingForumMapper;
    @Autowired
    private CrowdPicMapper crowdPicMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private ActiveRefundContext activeRefundContext;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    CustomerInterface customerInterface;

    @Override
    public BaseJsonVo saveCrowdActiveInfo(CrowdActiveConfigEntity crowdActiveConfigEntity) {
        CrowdActiveConfigEntity param = new CrowdActiveConfigEntity();
        param.setActiveNo(crowdActiveConfigEntity.getActiveNo());
        if (this.crowdActiveConfigMapper.existsByEntity(param) > 0) {
            return BaseJsonVo.error((String)"\u8be5\u6d3b\u52a8\u5df2\u7ecf\u914d\u7f6e\u4e86\u4f17\u7b79");
        }
        crowdActiveConfigEntity.setCreateTime(new Date());
        int i = this.crowdActiveConfigMapper.insert(crowdActiveConfigEntity);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public PageInfo getCrowActiveConfigList(PageForm pageForm, String activeName, String activeNo) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.crowdActiveConfigMapper.getCrowActiveConfigList(activeName, activeNo);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo getCrowdActiveProductList(String activeNo, String id) {
        return BaseJsonVo.success(this.crowdFundingMapper.getCrowdActiveProductList(activeNo, id));
    }

    @Override
    public BaseJsonVo checkCanJoinCrowdActive(String customerId, String activeNo) {
        return null;
    }

    @Override
    public BaseJsonVo getCrowdInfo() {
        CrowdCommonConfigEntity commonConfigEntity = new CrowdCommonConfigEntity();
        List list = this.crowdCommonConfigMapper.getList(commonConfigEntity);
        return list != null && list.size() >= 1 ? BaseJsonVo.success(this.crowdCommonConfigMapper.getList(commonConfigEntity).get(0)) : BaseJsonVo.error((String)"\u65e0\u6548\u7684\u914d\u7f6e");
    }

    @Override
    public BaseJsonVo getCrowdActiveList(Integer page, Integer pageSize, Integer type) {
        return null;
    }

    @Override
    public PageInfo getCrowdProductList(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.crowdCommonConfigMapper.getCrowdProductList();
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveCrowProduct(CrowdFundingEntity crowdFundingEntity) {
        int temp = 0;
        if (crowdFundingEntity.getStatus() == null) {
            crowdFundingEntity.setStatus(1);
        }
        if (crowdFundingEntity.getMessageStatus() == null) {
            crowdFundingEntity.setMessageStatus(1);
        }
        if (crowdFundingEntity.getAmountStatus() == null) {
            crowdFundingEntity.setAmountStatus(1);
        }
        temp = crowdFundingEntity.getId() == null || crowdFundingEntity.getId() == 0 ? this.crowdFundingMapper.insert(crowdFundingEntity) : this.crowdFundingMapper.updateByPrimaryKeySelective(crowdFundingEntity);
        return temp >= 1 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getSelectCrowdProductCouponList(String activeNo, String proId) {
        List<CrowdCouponVo> list = this.crowdCommonConfigMapper.getSelectCrowdProductCouponList(activeNo, proId);
        return list != null && list.size() >= 1 ? BaseJsonVo.success(list) : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo getAllCrowdProductCouponList() {
        return BaseJsonVo.success(this.crowdCommonConfigMapper.getAllCrowdProductCouponList());
    }

    @Override
    @Transactional
    public BaseJsonVo saveCrowdCouponConfig(String proId, String activeNo, String listCoupon) throws UnsupportedEncodingException {
        String items = URLDecoder.decode(listCoupon, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List list = JsonUtils.getListByArray(CrowdCouponVo.class, (String)items);
        int k = this.crowdCommonConfigMapper.deleteCrowdCoupon(proId);
        ActiveRuleEntity activeRuleEntity = new ActiveRuleEntity();
        activeRuleEntity.setActiveNo(activeNo);
        activeRuleEntity.setProId(proId);
        activeRuleEntity.setCreateTime(DateUtils.now());
        activeRuleEntity.setBindCode(UUID.randomUUID().toString().replace("-", ""));
        ArrayList<ActiveCashticketEntity> list2 = new ArrayList<ActiveCashticketEntity>();
        list.forEach(c -> {
            ActiveCashticketEntity activeCashticketEntity = new ActiveCashticketEntity();
            activeCashticketEntity.setBindCode(activeRuleEntity.getBindCode());
            activeCashticketEntity.setTicketBatchId(c.getBacthId());
            activeCashticketEntity.setTackType(3);
            activeCashticketEntity.setSource(0);
            activeCashticketEntity.setOnlyNewCashticket(0);
            activeCashticketEntity.setCount(1);
            list2.add(activeCashticketEntity);
        });
        this.activeRuleInterface.saveActiveRule(activeRuleEntity, list2);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getCrowdInviteList(Integer crowdId, String customerId) {
        CrowdInviteVo crowdInviteVo = new CrowdInviteVo();
        CrowdFundingEntity crowdFundingEntity = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(crowdId);
        this.logger.info(crowdFundingEntity.toString());
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(crowdFundingEntity.getActiveNo());
        crowdInviteVo.setStatus(1);
        if (activeEntity.getStatus() == 0 || activeEntity.getEndTime().before(DateUtils.now())) {
            crowdInviteVo.setStatus(3);
            if (this.getCrowdNum(crowdFundingEntity.getProId(), crowdFundingEntity.getActiveNo(), crowdFundingEntity.getPeopleCount()) >= crowdFundingEntity.getTargerPeople()) {
                crowdInviteVo.setStatus(2);
            }
        }
        Integer total = 0;
        List<InviteCustomerVo> list = this.crowdCommonConfigMapper.getCrowdInvite(crowdFundingEntity.getProId(), customerId, crowdFundingEntity.getActiveNo());
        if (list != null) {
            crowdInviteVo.setInviteList(list);
            for (InviteCustomerVo invite : list) {
                if (invite.getNewUser() == 1) {
                    invite.setCrowdAmout(crowdFundingEntity.getNewUserAmout());
                    total = total + crowdFundingEntity.getNewUserAmout();
                    continue;
                }
                invite.setCrowdAmout(crowdFundingEntity.getOldUserAmout());
                total = total + crowdFundingEntity.getOldUserAmout();
            }
            BigDecimal inviteTotal = new BigDecimal(total).add(new BigDecimal(crowdFundingEntity.getBaseAmount()));
            if (inviteTotal.compareTo(new BigDecimal(crowdFundingEntity.getMaxAmout())) > 0) {
                inviteTotal = new BigDecimal(crowdFundingEntity.getMaxAmout());
            }
            crowdInviteVo.setTotal(inviteTotal);
        }
        crowdInviteVo.setMaxAmout(crowdFundingEntity.getMaxAmout());
        return BaseJsonVo.success((Object)crowdInviteVo);
    }

    @Override
    public Integer getCrowdNum(String proId, String activeNo) {
        return this.crowdCommonConfigMapper.getCrowdNum(proId, activeNo);
    }

    @Override
    public Integer getCrowdNum(String proId, String activeNo, Integer peopleCount) {
        Integer num = this.getCrowdNum(proId, activeNo);
        return num == null ? (peopleCount == null ? 0 : peopleCount) : num + (peopleCount == null ? 0 : peopleCount);
    }

    @Override
    public PageInfo getMyCrowd(String customerId, Integer currentPage, Integer pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<MallCrowdfundingListVo> list = this.crowdCommonConfigMapper.getMyCrowd(customerId);
        PageInfo pg = page.toPageInfo();
        list.forEach(c -> {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(c.getActivNo());
            if (activeEntity != null) {
                c.setBeginTime(activeEntity.getBeginTime());
                c.setEndTime(activeEntity.getEndTime());
                List<String> pics = this.picService.getProductPicUrl(c.getProId() == null ? "" : c.getProId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                c.setSmallImages(pics);
                Integer num = this.getCrowdNum(c.getProId(), c.getActivNo(), c.getPeopleCount());
                double scale = MathUtils.mul((Number)MathUtils.div((Double)((Object)num), (Double)Double.valueOf(c.getTargerProple()), (Integer)4), (Number)100);
                c.setPropleScale(scale);
                if (c.getEndTime().before(DateUtils.now()) || activeEntity.getStatus() == 0) {
                    c.setCrowdStatus(3);
                    if (c.getTargerProple() <= num) {
                        c.setCrowdStatus(2);
                    }
                } else {
                    c.setCrowdStatus(1);
                }
                MallProductEntity product = this.mallProductInterface.getProduct(c.getProId());
                String pro_price = "\u96f6\u552e\u4ef7\u00a5" + c.getProPrice() + "/" + product.getProDw();
                if (product.getProPrice1() != null && !"".equals(product.getProPrice1()) && Double.parseDouble(product.getProPrice1()) > 0.0 && !product.getProPrice1().equals(product.getProPrice())) {
                    pro_price = "\u96f6\u552e\u4ef7\u00a5" + product.getProPrice() + "-" + product.getProPrice1() + "/" + product.getProDw();
                }
                c.setProPriceDesc(pro_price);
                c.setProMemo(product.getMemo());
                int surplus_date = CrowdService.getDateDiff(activeEntity.getEndTime());
                c.setSurplusDate(surplus_date);
                c.setJoinPeople(num);
            }
            c.setCrowdJoinCrowdId(c.getCrowdId());
        });
        return pg;
    }

    @Override
    public List<Map<String, Object>> getCrowdOrderList(Integer orderClass, String activeNo, String bindCode, String date) {
        return this.orderMainInterface.getOrderInfo(orderClass, activeNo, bindCode, date);
    }

    @Override
    public List<MallOrderMainEntity> getCrowdOrderMainList(String activeNo, String productId) {
        return this.orderMainInterface.getActiveOrdersBoughtProducts(activeNo, productId);
    }

    @Override
    public BaseJsonVo deleteCrowdCoupon(String proId) {
        Integer id = this.crowdCommonConfigMapper.getCrowdCoupon(proId);
        if (id != null && id > 0) {
            return this.activeCashticketInterface.deleteCouponConfig(id);
        }
        return BaseJsonVo.success((Object)"");
    }

    private static int getDateDiff(Date sdate) {
        Date now = new Date();
        if (now.after(sdate)) {
            return 0;
        }
        int day = 0;
        try {
            day = (int)((sdate.getTime() - now.getTime()) / 86400000L);
        }
        catch (Exception e) {
            return 0;
        }
        return day > 0 ? day + 1 : 1;
    }

    @Override
    public PageInfo getCrowdConfig(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.crowdCommonConfigMapper.getCrowdConfig();
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveCrowdConfigInfo(CrowdCommonConfigEntity crowdCommonConfigEntity) {
        crowdCommonConfigEntity.setCreateTime(new Date());
        if (crowdCommonConfigEntity.getId() == null) {
            this.crowdCommonConfigMapper.insertSelective(crowdCommonConfigEntity);
        } else {
            this.crowdCommonConfigMapper.updateByPrimaryKeySelective(crowdCommonConfigEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public PageInfo getCrowdFundingForumList(PageForm pageForm, CrowdFundingForumVo crowdFundingForumVo) {
        if (crowdFundingForumVo.getStartCreateTime() == null && crowdFundingForumVo.getEndCreateTime() != null) {
            crowdFundingForumVo.setStartCreateTime(new Date());
        }
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.crowdFundingForumMapper.getCrowdFundingForumList(crowdFundingForumVo);
        PageInfo pg = page.toPageInfo();
        LinkedHashMap container = new LinkedHashMap();
        ArrayList waitContainer = new ArrayList();
        pg.getList().forEach(e -> {
            Map entityMap = ObjectConvert.beanToMap((Object)((CrowdFundingForumEntity)e));
            if ((Long)entityMap.get("parentId") > 0L) {
                if (container.containsKey(entityMap.get("parentId"))) {
                    if (((Map)container.get(entityMap.get("parentId"))).containsKey("children")) {
                        ((List)((Map)container.get(entityMap.get("parentId"))).get("children")).add(entityMap);
                    } else {
                        ArrayList<Map> list = new ArrayList<Map>();
                        list.add(entityMap);
                        ((Map)container.get(entityMap.get("parentId"))).put("children", list);
                    }
                } else {
                    waitContainer.add(entityMap);
                }
            } else {
                container.put((Long)entityMap.get("id"), entityMap);
            }
        });
        waitContainer.forEach(entityMap -> {
            if (container.containsKey(entityMap.get("parentId"))) {
                if (((Map)container.get(entityMap.get("parentId"))).containsKey("children")) {
                    ((List)((Map)container.get(entityMap.get("parentId"))).get("children")).add(entityMap);
                } else {
                    ArrayList<Map> list = new ArrayList<Map>();
                    list.add((Map)entityMap);
                    ((Map)container.get(entityMap.get("parentId"))).put("children", list);
                }
            }
        });
        ArrayList finalList = new ArrayList();
        container.keySet().forEach(key -> finalList.add(container.get(key)));
        pg.setList(finalList);
        return pg;
    }

    @Override
    public BaseJsonVo deleteForum(String id) {
        this.crowdFundingForumMapper.updateForumById(id);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo saveCrowdImage(CrowdPicEntity crowdPicEntity) {
        this.crowdPicMapper.insertSelective(crowdPicEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo getCrowdPicList(CrowdPicEntity crowdPicEntity) {
        return BaseJsonVo.success(this.crowdPicMapper.getCrowdPicList(crowdPicEntity));
    }

    @Override
    public BaseJsonVo deleCrowdPicInfo(CrowdPicEntity crowdPicEntity) {
        this.crowdPicMapper.deleCrowdPicInfo(crowdPicEntity);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleCrowdPicByParam(CrowdPicEntity crowdPicEntity) {
        this.crowdPicMapper.deleCrowdPicByParam(crowdPicEntity);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo saveCrowdImage(String proId, String typeId, String classId, MultipartFile[] file) throws IOException {
        if (typeId == null) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7c7b,\u7136\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (file == null || file.length == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247");
        }
        CrowdPicEntity crowdPicEntityParam = new CrowdPicEntity();
        crowdPicEntityParam.setType(Integer.valueOf(typeId));
        crowdPicEntityParam.setProId(Integer.valueOf(proId));
        crowdPicEntityParam.setClassId(Integer.valueOf(classId));
        this.deleCrowdPicByParam(crowdPicEntityParam);
        for (MultipartFile f : file) {
            String fileName = new String(f.getOriginalFilename().getBytes(), "UTF-8");
            String picUrl = this.ossService.getImageResoure(AliyunOSSDir.IMG_STORAGE.getPath() + fileName);
            this.ossService.uploadFile(AliyunOSSDir.IMG_STORAGE, fileName, f.getInputStream());
            CrowdPicEntity crowdPicEntity = new CrowdPicEntity();
            crowdPicEntity.setPicUrl(picUrl);
            crowdPicEntity.setType(Integer.valueOf(typeId));
            crowdPicEntity.setProId(Integer.valueOf(proId));
            crowdPicEntity.setClassId(Integer.valueOf(classId));
            this.saveCrowdImage(crowdPicEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendMessage() {
        return null;
    }

    @Override
    public BaseJsonVo crowdSucc(Integer crowdId) {
        CrowdFundingEntity crowd = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(crowdId);
        ActiveEntity active = this.activeService.getActiveEntityByActiveNo(crowd.getActiveNo());
        List<ActiveRuleEntity> rules = this.activeRuleInterface.getRuleList(crowd.getActiveNo(), crowd.getProId());
        List<MallOrderMainEntity> crowdOrderList = this.getCrowdOrderMainList(active.getActiveNo().toString(), crowd.getProId().toString());
        this.logger.error("\u4e00\u5171\u8981\u53d1\uff1a" + crowdOrderList.size());
        int index = 0;
        for (MallOrderMainEntity order : crowdOrderList) {
            for (ActiveRuleEntity rule : rules) {
                List list = (List)this.activeCashticketInterface.getCashticketListByBindCode(rule.getBindCode()).getValue();
                list.forEach(cashticketVo -> {
                    if (cashticketVo.getTicketType() == 1) {
                        BaseJsonVo inviteResult = this.getCrowdInviteList(crowdId, order.getCustomerId());
                        BigDecimal couponAmount = new BigDecimal(crowd.getBaseAmount());
                        if (inviteResult.isSuccess()) {
                            couponAmount = ((CrowdInviteVo)inviteResult.getValue()).getTotal();
                        }
                        double amount = couponAmount.doubleValue();
                        BaseJsonVo vo = this.activeCashticketInterface.sendTicket4Base(order.getCustomerId(), rule.getBindCode(), amount, "", order.getPlatformId(), true, true, false);
                        if (!vo.isSuccess()) {
                            this.logger.error("\u7b2c{}\u4e2a\u4f17\u7b79\u53d1\u5238\u5931\u8d25orderMainNo={},bindCode={},cashticketBatchName={},amount={},reason={}", new Object[]{index, order.getOrderMainNo(), active.getBindCode(), cashticketVo.getTicketBatchName(), amount, vo.getError_msg()});
                        } else {
                            this.logger.error("\u7b2c{}\u4e2a\u4f17\u7b79\u53d1\u5238\u6210\u529forderMainNo={},bindCode={},cashticketBatchName={},amount={},reason={}", new Object[]{index, order.getOrderMainNo(), active.getBindCode(), cashticketVo.getTicketBatchName(), amount, vo.getError_msg()});
                        }
                    } else {
                        this.activeCashticketInterface.sendTicket4Base(order.getCustomerId(), rule.getBindCode(), 0.0, "", order.getPlatformId(), true, true, false);
                    }
                });
            }
            this.tradeInterface.confirmGoods(order.getCustomerId(), order.getOrderMainNo(), "");
        }
        crowd.setAmountStatus(2);
        crowd.setMessageStatus(2);
        this.crowdFundingMapper.updateByPrimaryKey(crowd);
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo crowdFail(Integer crowdId) {
        CrowdFundingEntity crowd = (CrowdFundingEntity)this.crowdFundingMapper.selectByPrimaryKey(crowdId);
        ActiveEntity active = this.activeService.getActiveEntityByActiveNo(crowd.getActiveNo());
        List<MallOrderMainEntity> crowdOrderList = this.getCrowdOrderMainList(active.getActiveNo(), crowd.getProId());
        ExecutorService pool = Executors.newCachedThreadPool();
        StringBuilder sb = new StringBuilder();
        crowdOrderList.forEach(order -> pool.execute(new Runnable((MallOrderMainEntity)order, active, crowd, sb){
            final /* synthetic */ MallOrderMainEntity val$order;
            final /* synthetic */ ActiveEntity val$active;
            final /* synthetic */ CrowdFundingEntity val$crowd;
            final /* synthetic */ StringBuilder val$sb;
            {
                this.val$order = mallOrderMainEntity;
                this.val$active = activeEntity;
                this.val$crowd = crowdFundingEntity;
                this.val$sb = stringBuilder;
            }

            @Override
            public void run() {
                ActiveRefundHandle activeRefundHandle = CrowdService.this.activeRefundContext.getActiveRefundHanle(24);
                BaseJsonVo b = activeRefundHandle.refund(this.val$order.getOrderMainNo(), "\u4f17\u7b79\u5931\u8d25\u6279\u91cf\u9000\u6b3e");
                if (b.isSuccess()) {
                    List<CustomerOpenidEntity> customerOpenids;
                    if (PlatFormEnum.LECHUN_WECHAT_MAIN.getValue() == this.val$order.getPlatformId().intValue()) {
                        CustomerEntity customer = CrowdService.this.customerInterface.getCustomer(this.val$order.getCustomerId());
                        HashMap<String, String> variableMap = new HashMap<String, String>();
                        variableMap.put("nickName", customer.getNickName());
                        variableMap.put("beginTime", DateUtils.formatDate((Date)this.val$active.getBeginTime(), (String)"yyyy-MM-dd"));
                        variableMap.put("endTime", DateUtils.formatDate((Date)this.val$active.getEndTime(), (String)"yyyy-MM-dd"));
                        variableMap.put("activeName", this.val$active.getActiveName());
                        variableMap.put("orderAmount", this.val$order.getOrderAmount().toString());
                        variableMap.put("currentTime", DateUtils.now((String)"yyyy-MM-dd"));
                        variableMap.put("orderMainNo", this.val$order.getOrderMainNo());
                        variableMap.put("createTime", DateUtils.formatDate((Date)this.val$order.getCreateTime(), (String)"yyyy-MM-dd"));
                        BaseJsonVo baseJsonVo = CrowdService.this.messageService.sendWechatMessage(1, "CROWD_FAIL_TP_MESSAGE", customer.getChannelCustomerId(), variableMap);
                    } else if (PlatFormEnum.LECHUN_MINI.getValue() == this.val$order.getPlatformId().intValue() && (customerOpenids = CrowdService.this.customerInterface.getCustomerOpenidList(this.val$order.getCustomerId(), PlatFormEnum.LECHUN_MINI.getValue())) != null && customerOpenids.size() > 0) {
                        MiniSubscribeMessage miniSubscribeMessage = new MiniSubscribeMessage();
                        miniSubscribeMessage.setTemplate_id("tlOTRug7_FRBDM3d-JLDlC8RbFuCizw-txtBhPkDUSU");
                        miniSubscribeMessage.setTouser(customerOpenids.get(0).getOpenId());
                        LinkedHashMap data = new LinkedHashMap();
                        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
                        map1.put("value", this.val$active.getActiveName());
                        data.put("thing1", map1);
                        LinkedHashMap map2 = new LinkedHashMap();
                        map1.put("value", "\u4f17\u7b79\u5931\u8d25");
                        data.put("thing2", map2);
                        LinkedHashMap map3 = new LinkedHashMap();
                        map1.put("value", "\u770b\u770b\u5176\u4ed6\u7684\uff01");
                        data.put("thing3", map3);
                        miniSubscribeMessage.setData(data);
                        BaseResult baseResult = CrowdService.this.messageService.miniMessageSubscribeSend(this.val$order.getPlatformId(), 99, miniSubscribeMessage);
                        if (!baseResult.isSuccess()) {
                            CrowdService.this.logger.error("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{},{}", (Object)baseResult.getErrcode(), (Object)baseResult.getErrmsg());
                        }
                    }
                    this.val$crowd.setAmountStatus(2);
                    this.val$crowd.setMessageStatus(2);
                    CrowdService.this.updateByPrimaryKey(this.val$crowd);
                } else {
                    this.val$sb.append(this.val$order.getOrderMainNo() + ":" + b.getError() + "|");
                }
            }
        }));
        if (sb.length() > 0) {
            return BaseJsonVo.error((String)sb.toString());
        }
        return BaseJsonVo.success((Object)"\u6279\u91cf\u9000\u6b3e\u6210\u529f");
    }
}

