/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleDetailMapper;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleDetailEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.form.cashticket.CashUseRuleForm;
import cc.lechun.mall.form.cashticket.CashUseRuleItem;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketBatchNewRuleService
extends BaseService
implements CashticketBatchNewRuleInterface {
    @Autowired
    private CashticketBatchNewRuleDetailMapper cashticketBatchNewRuleDetailMapper;
    @Autowired
    private CashticketBatchNewRuleMapper cashticketBatchNewRuleMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    MallProductInterface productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private MallProductCategoryInterface productCategoryService;
    @Lazy
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;

    @Override
    public List<CashticketBatchNewRuleVo> getCashRule(String ticketBatchId) {
        return this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
    }

    @Override
    public List<CashticketBatchNewRuleVo> getCashRule(String ticketBatchId, Integer ruleType, Integer platformGroupId) {
        List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        if (list != null) {
            return list.stream().filter(cashticketBatchNewRuleVo -> {
                boolean flag = false;
                if (cashticketBatchNewRuleVo.getRuleType().equals(ruleType)) {
                    flag = true;
                    cashticketBatchNewRuleVo.setDetailIdNames(this.getName(cashticketBatchNewRuleVo.getRuleType(), cashticketBatchNewRuleVo.getDetailIds(), platformGroupId));
                }
                return flag;
            }).collect(Collectors.toList());
        }
        return new ArrayList<CashticketBatchNewRuleVo>();
    }

    @Override
    public PageInfo getCashticketBatchUseRuleList(PageForm pageForm, String ticketBatchId, Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(cashticketBatchNewRuleVo -> {
                cashticketBatchNewRuleVo.setRuleTypeName(CashRuleTypeEnum.getName(cashticketBatchNewRuleVo.getRuleType()));
                cashticketBatchNewRuleVo.setDetailIdNames(this.getName(cashticketBatchNewRuleVo.getRuleType(), cashticketBatchNewRuleVo.getDetailIds(), platformGroupId));
            });
        }
        return pg;
    }

    private String getName(Integer ruleType, String detailIds, Integer platformGroupId) {
        String detailIdNames;
        block8: {
            String[] detailIdss;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                if (StringUtils.isEmpty((String)detailIds)) {
                                    return "";
                                }
                                detailIdss = detailIds.split(",");
                                detailIdNames = "";
                                if (ruleType.intValue() != CashRuleTypeEnum.danpin.getValue()) break block7;
                                MallProductEntity detail = null;
                                for (String str : detailIdss) {
                                    detail = this.productService.getProduct(str);
                                    if (detail == null) continue;
                                    detailIdNames = detailIdNames + detail.getProName() + ",";
                                }
                                break block8;
                            }
                            if (ruleType.intValue() != CashRuleTypeEnum.cuxiao.getValue()) break block9;
                            MallPromotionEntity detail = null;
                            for (String str : detailIdss) {
                                detail = this.mallPromotionService.getPromotion(str);
                                if (detail == null) continue;
                                detailIdNames = detailIdNames + detail.getPromotionName() + ",";
                            }
                            break block8;
                        }
                        if (ruleType.intValue() != CashRuleTypeEnum.taozhuang.getValue()) break block10;
                        MallProductGroupEntity detail = null;
                        for (String str : detailIdss) {
                            detail = this.mallGroupService.getGroup(str);
                            if (detail == null) continue;
                            detailIdNames = detailIdNames + detail.getGroupName() + ",";
                        }
                        break block8;
                    }
                    if (ruleType.intValue() != CashRuleTypeEnum.pingtai.getValue()) break block11;
                    PlatFormEntity detail = null;
                    for (String str : detailIdss) {
                        detail = this.platFormService.getPlatForm(Integer.parseInt(str));
                        if (detail == null) continue;
                        detailIdNames = detailIdNames + detail.getPlatformName() + ",";
                    }
                    break block8;
                }
                if (ruleType.intValue() != CashRuleTypeEnum.transport.getValue()) break block12;
                String detail = null;
                for (String str : detailIdss) {
                    detail = TransportTypeEnum.getName(Integer.parseInt(str));
                    if (detail == null) continue;
                    detailIdNames = detailIdNames + detail + ",";
                }
                break block8;
            }
            if (ruleType.intValue() != CashRuleTypeEnum.product_class.getValue()) break block8;
            MallProductCategoryEntity detail = null;
            for (String str : detailIdss) {
                detail = this.productCategoryService.getMallProductCategoryEntityById(str);
                if (detail == null) continue;
                detailIdNames = detailIdNames + detail.getCategoryName() + ",";
            }
        }
        return detailIdNames;
    }

    @Override
    @Transactional
    public BaseJsonVo saveCashRule(CashUseRuleForm cashUseRuleForm) {
        this.removeCache(cashUseRuleForm.getTicketBatchId());
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(cashUseRuleForm.getTicketBatchId());
        qpq.setRuleType(cashUseRuleForm.getRuleType());
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        if (ls1 != null && ls1.size() > 0) {
            ls1.forEach(cashticketBatchNewRuleEntity -> this.deleteCashRule(cashticketBatchNewRuleEntity.getRuleId()));
        }
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity2 = new CashticketBatchNewRuleEntity();
        cashticketBatchNewRuleEntity2.setCreateTime(DateUtils.now());
        cashticketBatchNewRuleEntity2.setRuleType(cashUseRuleForm.getRuleType());
        cashticketBatchNewRuleEntity2.setStats(cashUseRuleForm.getStats());
        cashticketBatchNewRuleEntity2.setTicketBatchId(cashUseRuleForm.getTicketBatchId());
        this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity2);
        if (cashUseRuleForm.getDetailIds() != null && cashUseRuleForm.getDetailIds().size() > 0) {
            cashUseRuleForm.getDetailIds().forEach(s -> {
                CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
                m.setCreateTime(DateUtils.now());
                m.setRuleId(cashticketBatchNewRuleEntity2.getRuleId());
                m.setDetailId((String)s);
                this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo saveCashRule(CashUseRuleItem cashUseRuleItem) {
        this.removeCache(cashUseRuleItem.getTicketBatchId());
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(cashUseRuleItem.getTicketBatchId());
        qpq.setRuleType(cashUseRuleItem.getRuleType());
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = new CashticketBatchNewRuleEntity();
        if (ls1 != null && ls1.size() > 0) {
            cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)ls1.get(0);
        } else {
            cashticketBatchNewRuleEntity.setCreateTime(DateUtils.now());
            cashticketBatchNewRuleEntity.setRuleType(cashUseRuleItem.getRuleType());
            cashticketBatchNewRuleEntity.setStats(cashUseRuleItem.getStats());
            cashticketBatchNewRuleEntity.setTicketBatchId(cashUseRuleItem.getTicketBatchId());
            this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity);
        }
        Long ruleId = cashticketBatchNewRuleEntity.getRuleId();
        if (cashUseRuleItem.getDetailIds() != null && cashUseRuleItem.getDetailIds().size() > 0) {
            cashUseRuleItem.getDetailIds().forEach(s -> {
                CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
                m.setCreateTime(DateUtils.now());
                m.setRuleId(ruleId);
                m.setDetailId((String)s);
                this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo deleteCashRule(Long ruleId) {
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)this.cashticketBatchNewRuleMapper.selectByPrimaryKey(ruleId);
        if (cashticketBatchNewRuleEntity != null) {
            this.removeCache(cashticketBatchNewRuleEntity.getTicketBatchId());
            this.cashticketBatchNewRuleMapper.deleteByPrimaryKey(ruleId);
            CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
            qpq.setTicketBatchId(cashticketBatchNewRuleEntity.getTicketBatchId());
            List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
            boolean productType = false;
            if (ls1 != null && ls1.size() > 0) {
                productType = ls1.stream().anyMatch(rule -> {
                    Integer ruleTypeId = rule.getRuleType();
                    return ruleTypeId.intValue() == CashRuleTypeEnum.transport.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.taozhuang.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.cuxiao.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.product_class.getValue();
                });
            }
            if (!productType) {
                CashticketBatchEntity updateBatch = new CashticketBatchEntity();
                updateBatch.setUseType(1);
                updateBatch.setTicketBatchId(cashticketBatchNewRuleEntity.getTicketBatchId());
                this.cashticketBatchInterface.saveCashticketBatch(updateBatch);
            }
            CashticketBatchNewRuleDetailEntity qpc = new CashticketBatchNewRuleDetailEntity();
            qpc.setRuleId(cashticketBatchNewRuleEntity.getRuleId());
            List ls = this.cashticketBatchNewRuleDetailMapper.getList(qpc);
            if (ls != null && ls.size() > 0) {
                ls.forEach(cashticketBatchNewRuleDetailEntity -> this.cashticketBatchNewRuleDetailMapper.deleteByPrimaryKey(cashticketBatchNewRuleDetailEntity.getId()));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashRule", ticketBatchId);
    }
}

