/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.mall.dao.trade.MallOrderCacheMapper;
import cc.lechun.mall.entity.trade.MallOrderCacheEntity;
import cc.lechun.mall.iservice.trade.MallOrderCacheInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderCacheService
implements MallOrderCacheInterface {
    @Autowired
    private MallOrderCacheMapper orderCacheMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="ordercache", expiration=3600)
    public MallOrderCacheEntity getOrderCacheEntity(@ParameterValueKeyProvider String cacheId) {
        return (MallOrderCacheEntity)this.orderCacheMapper.selectByPrimaryKey((Serializable)((Object)cacheId));
    }

    @Override
    public Boolean insertOrderCacheEntity(String cacheId, String cacheContent) {
        MallOrderCacheEntity orderCacheEntity = new MallOrderCacheEntity();
        orderCacheEntity.setCacheId(cacheId);
        orderCacheEntity.setCacheContent(cacheContent);
        orderCacheEntity.setCreateTime(DateUtils.now());
        return this.orderCacheMapper.insertSelective(orderCacheEntity) > 0;
    }

    @Override
    public Boolean deleteOrderCacheEntity(String cacheId) {
        this.removeCache(cacheId);
        return this.orderCacheMapper.deleteByPrimaryKey((Serializable)((Object)cacheId)) > 0;
    }

    private void removeCache(String cacheId) {
        this.memcachedService.delete("ordercache", cacheId);
    }
}

