/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.user;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.user.MallRoleResourceMapper;
import cc.lechun.mall.dao.user.MallUserMapper;
import cc.lechun.mall.dao.user.MallUserRoleMapper;
import cc.lechun.mall.entity.user.MallRoleResourceEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.user.MallUserEntityVo;
import cc.lechun.mall.entity.user.MallUserMenuRsVo;
import cc.lechun.mall.entity.user.MallUserMenuVo;
import cc.lechun.mall.entity.user.MallUserRoleEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.iservice.IOrgPaperService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysUserService
implements SysUserInterface {
    @Autowired
    MallUserMapper mallUserMapper;
    @Autowired
    MallUserRoleMapper mallUserRoleMapper;
    @Autowired
    MallRoleResourceMapper mallRoleResourceMapper;
    @Autowired
    IOrgPaperService paperService;
    @Autowired
    RedisCacheUtil redisCacheUtil;
    @Autowired
    SysUserInterface sysUserInterface;

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo saveMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallUserEntity.setUserId(IDGenerate.getUniqueID() + "");
        mallUserEntity.setCreateTime(DateUtils.now());
        mallUserEntity.setUserType(1);
        mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        this.mallUserMapper.insertSelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo updateMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        if (!StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        }
        this.mallUserMapper.updateByPrimaryKeySelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo validUser(MallUserEntity mallUserEntity) {
        if (StringUtils.isEmpty((String)mallUserEntity.getUserName())) {
            return BaseJsonVo.paramError((String)"\u767b\u5f55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserNick())) {
            return BaseJsonVo.paramError((String)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserId()) && StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallUserEntity.getPlatformGroupId() == null) {
            return BaseJsonVo.paramError((String)"\u6240\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="SysUserService.getMallUserList", expiration=7200)
    public PageInfo getMallUserList(@ParameterValueKeyProvider(order=0) Integer pageNum, @ParameterValueKeyProvider(order=1) Integer pageSize, @ParameterValueKeyProvider(order=2) String userName, @ParameterValueKeyProvider(order=3) String userNick, @ParameterValueKeyProvider(order=4) Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserList(userName, userNick, platformGroupId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    @ReadThroughSingleCache(namespace="getMallUserNickName", expiration=7200)
    public String getMallUserNickName(@ParameterValueKeyProvider String user_id) {
        MallUserEntity mallUserEntity = this.getMallUser(user_id);
        return mallUserEntity == null ? "" : mallUserEntity.getUserNick();
    }

    @Override
    @ReadThroughSingleCache(namespace="SysUserService.getMallUser", expiration=300)
    public MallUserEntity getMallUser(@ParameterValueKeyProvider String user_id) {
        return (MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)user_id));
    }

    @Override
    public MallUserEntity getSysUser4name(String user_name) {
        return this.mallUserMapper.getSysUser4name(user_name);
    }

    @Override
    public List<MallUserMenuRsVo> getSysUserMenu(String user_id) {
        List<MallUserMenuVo> ls = this.mallUserMapper.getUserMenuList(user_id);
        ArrayList<MallUserMenuRsVo> rs = new ArrayList<MallUserMenuRsVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getParentResourceId())).entrySet().forEach(longListEntry -> {
            MallUserMenuRsVo rsvo = new MallUserMenuRsVo();
            rsvo.setMenu_list((List)longListEntry.getValue());
            rsvo.setParentResourceId((Long)longListEntry.getKey());
            rsvo.setParentResourceName(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceName());
            rsvo.setParentResourceIcon(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceIcon());
            rsvo.setParentResourceOrder(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceOrder());
            rsvo.getMenu_list().sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
            rs.add(rsvo);
        });
        rs.sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
        return rs;
    }

    @Override
    public List<Integer> getSysUserRoleList(String user_id) {
        return this.mallUserMapper.getSysUserRoleList(user_id);
    }

    @Override
    public List<String> getSysUserResourceList(String user_id) {
        return this.mallUserMapper.getSysUserResourceList(user_id);
    }

    @Override
    public PageInfo getMallUserRoleList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserRoleList(userId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveUserRole(MallUserRoleEntity mallUserRoleEntity) {
        this.mallUserRoleMapper.insertSelective(mallUserRoleEntity);
    }

    @Override
    public void deleteUserRole(int id) {
        this.mallUserRoleMapper.deleteByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public PageInfo getMallRoleResourceList(int pageNum, int pageSize, String roleId, int resourceType) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallRoleResourceList(roleId, resourceType);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveRoleResource(MallRoleResourceEntity mallRoleResourceEntity) {
        this.mallRoleResourceMapper.insertSelective(mallRoleResourceEntity);
    }

    @Override
    public void deleteRoleResource(long id) {
        this.mallRoleResourceMapper.deleteByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public BaseJsonVo syncSysUsers() {
        this.mallUserMapper.syncSysUsers();
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getBaseUserList(int type, String userId) {
        List<Map<String, String>> users = this.mallUserMapper.getBaseUserList(type);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String resourcePath = request.getParameter("pageRouterUrl");
        if ("cooperate".equals(resourcePath)) {
            List<String> twiceUsers = this.paperService.getThankTwiceThisMonth(userId);
            List<MallUserEntity> equalUser = this.sysUserInterface.getEqualDeptUser(userId);
            for (Map<String, String> user : users) {
                if (userId.equals(user.get("USER_ID"))) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                if (twiceUsers.contains(user.get("USER_ID"))) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                if (equalUser.stream().filter(c -> c.getUserId().equals(user.get("USER_ID"))).count() > 0L) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                user.put("enable", (String)((Object)Integer.valueOf(1)));
            }
        }
        return BaseJsonVo.success(users);
    }

    @Override
    public Integer getRoleUserCount(Integer roleId) {
        Integer count = this.mallUserRoleMapper.getUserCount(roleId);
        return count == null ? 0 : count;
    }

    @Override
    public Set<String> getSubordinate(String userId) {
        Set<String> subordinate = this.mallUserMapper.findAllSubordinate(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(subordinate);
        if (subordinate != null) {
            for (String s : subordinate) {
                rtn.addAll(this.getSubordinate(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="getFinancialSubordinate", expiration=300)
    public Set<String> getFinancialSubordinate(@ParameterValueKeyProvider(order=0) String userId) {
        Set<String> allFinancialSubordinate = this.mallUserMapper.findAllFinancialSubordinate(userId);
        return allFinancialSubordinate;
    }

    @Override
    public Boolean isLeadershipRelation(String leaderId, String subordinateId) {
        if (this.getSubordinate(leaderId).contains(subordinateId)) {
            return true;
        }
        return false;
    }

    public Set<String> getLeaderInfo(String userId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(leadeInfo);
        if (leadeInfo != null && leadeInfo.size() > 0 && !leadeInfo.contains(userId)) {
            for (String s : leadeInfo) {
                rtn.addAll(this.getLeaderInfo(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="isLeadershipRelationNew", expiration=300)
    public Boolean isLeadershipRelationNew(@ParameterValueKeyProvider(order=0) String leaderId, @ParameterValueKeyProvider(order=1) String subordinateId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(subordinateId);
        if (leadeInfo.contains(leaderId)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isLeadership(String leaderId, String subordinateId) {
        String key = "isLeadership_" + leaderId + "_" + subordinateId;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (Boolean)o;
        }
        MallUserEntity param = new MallUserEntity();
        param.setLeader(leaderId);
        param.setUserId(subordinateId);
        List list = this.mallUserMapper.getList(param);
        if (list == null || list.size() == 0) {
            this.redisCacheUtil.set(key, (Object)false, Long.valueOf(300L));
            return false;
        }
        this.redisCacheUtil.set(key, (Object)true, Long.valueOf(300L));
        return true;
    }

    @Override
    @ReadThroughSingleCache(namespace="getSysUserList4RoleId", expiration=300)
    public List<MallUserEntity> getSysUserList4RoleId(@ParameterValueKeyProvider(order=0) Integer roleId) {
        return this.mallUserMapper.getSysUserList4RoleId(roleId);
    }

    @Override
    public List<MallUserEntityVo> getMallUserInfoByParam(String userName, String userNick, String dingdingId, Integer platformGroupId) {
        return this.mallUserMapper.getMallUserInfoByParam(userName, userNick, dingdingId, platformGroupId);
    }

    @Override
    public int updateUserDingDingIdById(String userId, String dingdingId) {
        return this.mallUserMapper.updateUserDingDingIdById(userId, dingdingId);
    }

    @Override
    public List<MallUserEntity> getSysUserListByStatus() {
        return this.mallUserMapper.getSysUserListByStatus();
    }

    @Override
    public List<Map<String, Object>> getDeparts() {
        return this.mallUserMapper.getDeparts();
    }

    @Override
    public List<MallUserEntity> getEqualDeptUser(String userId) {
        MallUserEntity user = this.getMallUser(userId);
        if (user != null && user.getDeptId() != null) {
            MallUserEntity param = new MallUserEntity();
            param.setDeptId(user.getDeptId());
            return this.mallUserMapper.getList(param);
        }
        return new ArrayList<MallUserEntity>();
    }
}

