/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.Repository.shiro;

import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.springframework.beans.factory.annotation.Autowired;

public class MyShiroRealm
extends AuthorizingRealm {
    @Autowired
    SysUserInterface sysUserInterface;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        MallUserEntity user = (MallUserEntity)super.getAvailablePrincipal(principalCollection);
        if (user != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            List userRoleList = this.sysUserInterface.getSysUserRoleList(user.getUserId());
            info.setRoles(userRoleList.stream().map(value -> value + "").distinct().collect(Collectors.toSet()));
            List userResouceList = this.sysUserInterface.getSysUserResourceList(user.getUserId());
            return info;
        }
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        token.setRememberMe(true);
        MallUserEntity user = this.sysUserInterface.getSysUser4name(token.getUsername());
        if (user != null && user.getStatus() == 1) {
            return new SimpleAuthenticationInfo((Object)user, (Object)user.getPassword(), ByteSource.Util.bytes((String)"lechun"), this.getName());
        }
        throw new UnknownAccountException("\u65e0\u6548\u7528\u6237");
    }
}

