/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.Image;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.image.ImageTypeEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.image.ImageInterface;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/image"})
public class ImageController
extends BaseController {
    @Autowired
    private ImageInterface imageInterface;
    @Autowired
    private OssService ossService;

    @RequestMapping(value={"/getImageTypeList"})
    @ResponseBody
    public List<ImageTypeEntity> getImageTypeList() throws AuthorizeException {
        return this.imageInterface.getImageTypeList();
    }

    @RequestMapping(value={"/saveImageType"})
    @ResponseBody
    public BaseJsonVo saveImageType(String typeName, String typePath) throws AuthorizeException {
        if (StringUtils.isEmpty((String)typeName)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)typePath)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u8def\u5f84");
        }
        if (!typePath.matches("^[A-Za-z]+$")) {
            return BaseJsonVo.paramError((String)"\u8def\u5f84\u5fc5\u987b\u662f\u5168\u5b57\u6bcd\uff0c\u5efa\u8bae\u540d\u79f0\u7684\u5168\u62fc");
        }
        MallUserEntity user = this.getUser();
        try {
            this.imageInterface.saveImageType(typeName, typePath);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return BaseJsonVo.paramError((String)"\u8def\u5f84\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getImageList"})
    @ResponseBody
    public BaseJsonVo getImageList(PageForm pageForm, Integer typeId) throws AuthorizeException {
        if (typeId == null || typeId == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7c7b");
        }
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.imageInterface.getImageList(pageForm.getCurrentPage(), pageForm.getPageSize(), typeId.intValue(), user.getPlatformGroupId().intValue()));
    }

    @RequestMapping(value={"/saveImage"})
    @ResponseBody
    public BaseJsonVo saveImage(Integer typeId, String imageName, MultipartFile[] file) throws AuthorizeException, IOException {
        this.log.info("*******saveImage\u540d\u79f0\u4fee\u6539******imageName={}", (Object)imageName);
        if (typeId == null || typeId == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7c7b,\u7136\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (StringUtils.isEmpty((String)imageName)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u6587\u4ef6\u63cf\u8ff0");
        }
        if (file == null || file.length == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247");
        }
        MallUserEntity user = this.getUser();
        for (MultipartFile f : file) {
            String fileName = new String(f.getOriginalFilename().getBytes(), "UTF-8");
            this.log.info("*******saveImage\u540d\u79f0\u4fee\u6539******MultipartFile={},file.length={}", (Object)f, (Object)file.length);
            BaseJsonVo rs = this.ossService.uploadFileNew(user.getPlatformGroupId().intValue(), typeId.intValue(), fileName, f.getInputStream());
            this.log.info("*******saveImage\u540d\u79f0\u4fee\u6539******rs.isSuccess()={}", (Object)rs.isSuccess());
            if (!rs.isSuccess()) continue;
            imageName = imageName + "_" + fileName;
            this.log.info("*******saveImage\u540d\u79f0\u4fee\u6539******imageName={}", (Object)imageName);
            this.imageInterface.saveImage(user.getPlatformGroupId().intValue(), typeId.intValue(), imageName, rs.getValue().toString(), user.getUserId());
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/deleteImage"})
    @ResponseBody
    public BaseJsonVo deleteImage(Long imageId) throws AuthorizeException {
        if (imageId == null || imageId == 0L) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u56fe\u7247");
        }
        this.imageInterface.deleteImage(imageId.longValue());
        return BaseJsonVo.success((Object)"");
    }
}

