/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.item;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.IndexItemEntity;
import cc.lechun.mall.entity.item.IndexNavEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallIndexNavInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/item"})
public class MallItemController
extends BaseController {
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MallIndexItemInterface indexItemInterface;
    @Autowired
    private MallIndexNavInterface indexNavInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @RequestMapping(value={"/getbuildpagetree"})
    @ResponseBody
    public BaseJsonVo getBuildPageTree() throws AuthorizeException {
        int platFormGroupId = this.getUser().getPlatformGroupId();
        List treeVos = this.buildPageInterface.getBuildPageTree(platFormGroupId);
        if (treeVos != null) {
            return BaseJsonVo.success((Object)treeVos);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u9996\u9875\u6a21\u677f\u680f\u76ee");
    }

    @RequestMapping(value={"/getbuildpagelist"})
    @ResponseBody
    public BaseJsonVo getBuildPageEntityList(int platformId, short navType) throws AuthorizeException {
        List buildPageVos = this.buildPageInterface.getBuildPageEntityList(platformId, navType);
        if (buildPageVos != null) {
            return BaseJsonVo.success((Object)buildPageVos);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u9996\u9875\u6a21\u677f\u680f\u76ee");
    }

    @RequestMapping(value={"/getbuildpage"})
    @ResponseBody
    public Map<String, Object> getBuildPage(Integer buildPageId) throws AuthorizeException {
        BuildPageEntity buildPageEntity = null;
        if (buildPageId != null && buildPageId != 0) {
            buildPageEntity = this.buildPageInterface.getBuildPage(buildPageId.intValue());
        }
        MallUserEntity userEntity = this.getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", buildPageEntity);
        map.put("pageTypeData", this.dictionaryInterface.getValidDictionaryList(userEntity.getPlatformGroupId(), Integer.valueOf(25)));
        map.put("navTypeData", this.dictionaryInterface.getValidDictionaryList(userEntity.getPlatformGroupId(), Integer.valueOf(24)));
        return map;
    }

    @RequestMapping(value={"/savebuildpage"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseJsonVo saveBuildPage(BuildPageEntity buildPageEntity) throws AuthorizeException {
        if (buildPageEntity.getBuildPageId() == null || buildPageEntity.getBuildPageId() == 0) {
            buildPageEntity.setCreateUserId(this.getUser().getUserId());
            buildPageEntity.setCreateUserName(this.getUser().getUserName());
        }
        return this.buildPageInterface.saveBuildPage(buildPageEntity);
    }

    @RequestMapping(value={"/deletebuildPage"})
    @ResponseBody
    public BaseJsonVo deleteBuildPage(Integer buildPageId) throws AuthorizeException {
        boolean b = this.buildPageInterface.deleteBuildPage(buildPageId.intValue());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/getIndexNavTree"})
    @ResponseBody
    public BaseJsonVo getIndexNavTree() throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        List treeVos = this.indexNavInterface.getIndexNavTree(platFormGroupId);
        if (treeVos != null) {
            return BaseJsonVo.success((Object)treeVos);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u9996\u9875\u6a21\u677f\u680f\u76ee");
    }

    @RequestMapping(value={"/getIndexNavList"})
    @ResponseBody
    public BaseJsonVo getIndexNavList(int platformId) throws AuthorizeException {
        List indexNavEntities = this.indexNavInterface.getIndexNavList(Integer.valueOf(platformId));
        if (indexNavEntities != null) {
            return BaseJsonVo.success((Object)indexNavEntities);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u9996\u9875\u6a21\u677f\u680f\u76ee");
    }

    @RequestMapping(value={"/getIndexNav"})
    @ResponseBody
    public Map<String, Object> getIndexNav(String indexNavId) throws AuthorizeException {
        IndexNavEntity indexNavEntity = null;
        if (indexNavId != null && !indexNavId.isEmpty()) {
            indexNavEntity = this.indexNavInterface.getIndexNav(indexNavId);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("index", indexNavEntity);
        return map;
    }

    @RequestMapping(value={"/saveIndexNav"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseJsonVo saveIndexNav(IndexNavEntity indexNavEntity) throws AuthorizeException {
        if (indexNavEntity.getIndexNavId() == null || indexNavEntity.getIndexNavId().isEmpty()) {
            indexNavEntity.setCreateUser(this.getUser().getUserName());
        }
        return this.indexNavInterface.saveIndexNav(indexNavEntity);
    }

    @RequestMapping(value={"/deleteIndexNav"})
    @ResponseBody
    public BaseJsonVo deleteIndexNav(String indexNavId) throws AuthorizeException {
        return this.indexNavInterface.deleteIndexNav(indexNavId);
    }

    @RequestMapping(value={"/getIndexItemList"})
    @ResponseBody
    public BaseJsonVo getIndexItemList(String indexNavId) throws AuthorizeException {
        List indexItemVos = this.indexItemInterface.getIndexItemList(indexNavId);
        if (indexItemVos != null) {
            return BaseJsonVo.success((Object)indexItemVos);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u9996\u9875\u6a21\u677f\u680f\u76ee");
    }

    @RequestMapping(value={"/getIndexItem"})
    @ResponseBody
    public BaseJsonVo getIdnexItem(String indexItemId, String indexNavId) throws AuthorizeException {
        IndexNavEntity indexNavEntity;
        IndexItemEntity indexItemEntity = null;
        if (!indexItemId.isEmpty()) {
            indexItemEntity = this.indexItemInterface.getIdnexItem(indexItemId);
        }
        if ((indexNavEntity = this.indexNavInterface.getIndexNav(indexNavId)) == null) {
            return BaseJsonVo.error((String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        int itemType = indexItemEntity == null ? ((SalesTypeEnum)SalesTypeEnum.getList().get(0)).getValue() : Integer.parseInt(indexItemEntity.getItemType());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (indexItemEntity == null) {
            indexItemEntity = new IndexItemEntity();
            indexItemEntity.setNavId(indexNavId);
            indexItemEntity.setItemSn(Integer.valueOf(0));
        }
        map.put("indexItem", indexItemEntity);
        map.put("itemTypeData", SalesTypeEnum.getSelectDataList());
        map.put("buildPageData", this.buildPageInterface.getBuildPageEntityList(indexNavEntity.getPlatformId().intValue(), (short)4));
        map.put("detailBuildPageData", this.buildPageInterface.getBuildPageEntityList(indexNavEntity.getPlatformId().intValue(), (short)5));
        map.put("items", this.indexItemInterface.getItems(itemType, this.getUser().getPlatformGroupId().intValue()));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/saveIndexItem"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseJsonVo saveIndexItem(IndexItemEntity indexItemEntity) throws AuthorizeException {
        return this.indexItemInterface.saveIndexItem(indexItemEntity);
    }

    @RequestMapping(value={"/getItems"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MallSelectDataVo> getItems(int itemType) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.indexItemInterface.getItems(itemType, userEntity.getPlatformGroupId().intValue());
    }

    @RequestMapping(value={"/deleteIndexItem"})
    @ResponseBody
    public BaseJsonVo deleteIndexItem(String indexItemId) throws AuthorizeException {
        return this.indexItemInterface.deleteIndexItem(indexItemId);
    }

    @RequestMapping(value={"/buildModulePage"})
    @ResponseBody
    public BaseJsonVo buildModulePage(int platformId) throws AuthorizeException {
        return this.indexNavInterface.buildModulePage(Integer.valueOf(platformId), "");
    }
}

