/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.qrcode;

import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.qrcode.QrExportVO;
import cc.lechun.mall.entity.qrcode.QrcodeEntity;
import cc.lechun.mall.entity.qrcode.QrcodeSubEntity;
import cc.lechun.mall.entity.qrcode.SubQrCodeExportVO;
import cc.lechun.mall.entity.qrcode.SubQrLinkExportVO;
import cc.lechun.mall.idomain.qrcode.IQrcodeDomain;
import cc.lechun.mall.iservice.qrcode.QrcodeInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeSubInterface;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qr"})
public class QrController {
    @Autowired
    private IQrcodeDomain qrcodeDomain;
    @Autowired
    private QrcodeInterface qrcodeService;
    @Autowired
    QrcodeSubInterface qrcodeSubService;

    @RequestMapping(value={"/findQrList"})
    public BaseJsonVo findQrList(PageForm pageForm, String qrName, String qrStatus) {
        PageInfo pageInfo = this.qrcodeDomain.findQrList(pageForm, qrName, StringUtils.isEmpty((String)qrStatus) ? null : Integer.valueOf(qrStatus));
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/findQrSubList"})
    public BaseJsonVo findQrSubList(PageForm pageForm, Integer qrId, String subQrName) {
        PageInfo pageInfo = this.qrcodeDomain.findQrSubList(pageForm, qrId, subQrName);
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/getQr"})
    public BaseJsonVo getQr(Integer qrId) {
        QrcodeEntity qr = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey((Serializable)qrId);
        return BaseJsonVo.success((Object)qr);
    }

    @RequestMapping(value={"/addOrEditQr"})
    public BaseJsonVo addOrEditQr(QrcodeEntity qr) {
        return this.qrcodeDomain.addOrEditQr(qr);
    }

    @RequestMapping(value={"/addOrEditQrSub"})
    public BaseJsonVo addOrEditQrSub(QrcodeSubEntity qrSub) {
        return this.qrcodeDomain.addOrEditQrSub(qrSub);
    }

    @RequestMapping(value={"/delQr"})
    public BaseJsonVo delQr(Integer qrId) {
        return this.qrcodeDomain.delQr(qrId);
    }

    @RequestMapping(value={"/delQrSub"})
    public BaseJsonVo delQrSub(Integer qrSubId) {
        return this.qrcodeDomain.delQrSub(qrSubId);
    }

    @RequestMapping(value={"/onoff"})
    public BaseJsonVo onoff(Integer qrId) {
        return this.qrcodeDomain.onoff(qrId);
    }

    @RequestMapping(value={"/downloadQR"})
    public void downloadQR(Integer qrId, HttpServletResponse response) throws IOException {
        QrcodeEntity qr = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey((Serializable)qrId);
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(qr.getQrName(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        BaseJsonVo dataVO = this.qrcodeDomain.downloadQR(qr);
        if (dataVO.isSuccess()) {
            try {
                ExcelWriter writer = new ExcelWriter((OutputStream)response.getOutputStream(), ExcelTypeEnum.XLSX);
                Sheet sheet = new Sheet(1, 0, QrExportVO.class);
                sheet.setSheetName(qr.getQrName());
                writer.write((List)dataVO.getValue(), sheet);
                writer.finish();
            }
            catch (IOException e) {
                response.reset();
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("status", "failure");
                map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
                response.getWriter().println(JSON.toJSONString(map));
            }
        } else {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u6570\u636e\u4e0d\u5b58\u5728");
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"/downloadSubQR"})
    public void downloadSubQR(Integer qrSubId, HttpServletResponse response) throws IOException {
        QrcodeSubEntity qrSub = (QrcodeSubEntity)this.qrcodeSubService.selectByPrimaryKey((Serializable)qrSubId);
        QrcodeEntity qr = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey((Serializable)qrSub.getQrId());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(qrSub.getSubQrName(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        BaseJsonVo dataVO = this.qrcodeDomain.downloadSubQR(qrSub);
        if (dataVO.isSuccess()) {
            try {
                ExcelWriter writer = new ExcelWriter((OutputStream)response.getOutputStream(), ExcelTypeEnum.XLSX);
                Sheet sheet = new Sheet(1, 0, qr.getQrType() == 1 ? SubQrLinkExportVO.class : SubQrCodeExportVO.class);
                sheet.setSheetName(qrSub.getSubQrName());
                writer.write((List)dataVO.getValue(), sheet);
                writer.finish();
            }
            catch (IOException e) {
                response.reset();
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("status", "failure");
                map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
                response.getWriter().println(JSON.toJSONString(map));
            }
        } else {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u6570\u636e\u4e0d\u5b58\u5728");
            response.getWriter().println(JSON.toJSONString(map));
        }
    }
}

