/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallGroupProductEntityKey;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"group"})
public class MallGroupController
extends BaseController {
    @Autowired
    private MallGroupInterface groupService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private DistributorItemInterface distributorItemInterface;

    @RequestMapping(value={"grouplist"})
    public PageInfo grouList(PageForm pageForm, MallProductGroupEntity mallProductGroupEntity) throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        mallProductGroupEntity.setPlatformGroupId(platFormGroupId);
        return this.groupService.getGroupList(pageForm.getCurrentPage(), pageForm.getPageSize(), mallProductGroupEntity);
    }

    @RequestMapping(value={"getGroup"})
    public BaseJsonVo getGroup(String groupId) {
        MallProductGroupEntity entity = this.groupService.getGroup(groupId);
        if (entity != null) {
            return BaseJsonVo.success((Object)entity);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    @RequestMapping(value={"addGroup"})
    public BaseJsonVo addGroup(MallProductGroupEntity mallProductGroupEntity) {
        BaseJsonVo sr = this.groupService.addGroup(mallProductGroupEntity);
        if (sr.isSuccess()) {
            MallProductGroupEntity groupEntity = (MallProductGroupEntity)sr.getValue();
            if (groupEntity != null) {
                this.distributorItemInterface.initDistributorItem(groupEntity.getGroupId(), Integer.valueOf(2));
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delGroup"})
    public BaseJsonVo delGroup(MallProductGroupEntity mallProductGroupEntity) {
        BaseJsonVo sr = this.groupService.delGroup(mallProductGroupEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallProductGroupEntity.getGroupId(), Integer.valueOf(2));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getGroupProduct"})
    public BaseJsonVo getGroupProductErp(String groupId) {
        MallProductGroupEntity group = this.groupService.getGroup(groupId);
        List groupProducts = this.groupService.getGroupProducts(groupId);
        List products = this.productService.getAllProductList(group.getPlatformGroupId());
        ArrayList rtnList = new ArrayList();
        if (products != null) {
            products.forEach(product -> {
                List list;
                HashMap<String, Object> rtnMap = new HashMap<String, Object>();
                rtnMap.put("EXISTS", 0);
                rtnMap.put("PRO_CODE", product.getProCode());
                rtnMap.put("PRO_ID", product.getProId());
                rtnMap.put("PRO_NAME", product.getProName());
                rtnMap.put("PRO_NAME_SX", product.getProNameSx());
                rtnMap.put("EXISTS_COUNT", 0);
                rtnMap.put("EXISTS_PRICE", 0);
                if (groupProducts != null && groupProducts.size() > 0 && (list = groupProducts.stream().filter(groupProduct -> product.getProId().equals(groupProduct.getProId())).collect(Collectors.toList())) != null && list.size() > 0) {
                    rtnMap.put("EXISTS_COUNT", ((MallGroupProductEntity)list.get(0)).getProCount());
                    rtnMap.put("EXISTS_PRICE", ((MallGroupProductEntity)list.get(0)).getProPrice());
                }
                rtnList.add(rtnMap);
            });
        }
        if (rtnList != null && rtnList.size() > 0) {
            return BaseJsonVo.success(rtnList);
        }
        return BaseJsonVo.error((String)"\u67e5\u4e0d\u5230\u5546\u54c1");
    }

    @RequestMapping(value={"getGroupProductCms"})
    public BaseJsonVo getGroupProductCms(String groupId) {
        List groupProducts = this.groupService.getGroupProducts(groupId);
        if (groupProducts != null && groupProducts.size() > 0) {
            return BaseJsonVo.success((Object)groupProducts);
        }
        return BaseJsonVo.error((String)"\u67e5\u4e0d\u5230\u5546\u54c1");
    }

    @RequestMapping(value={"addGroupProduct"})
    public BaseJsonVo addGroupProduct(MallGroupProductEntity mallGroupProductEntity, MallGroupProductEntityKey mallGroupProductEntityKey) {
        mallGroupProductEntity.setProId(mallGroupProductEntityKey.getProId());
        MallProductEntity product = this.productService.getProduct(mallGroupProductEntity.getProId());
        if (product != null && StringUtils.isNotEmpty((String)product.getProName())) {
            mallGroupProductEntity.setProName(product.getProName());
        }
        mallGroupProductEntity.setGroupId(mallGroupProductEntityKey.getGroupId());
        BaseJsonVo sr = this.groupService.addGroupProduct(mallGroupProductEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallGroupProductEntity.getGroupId(), Integer.valueOf(2));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delGroupProduct"})
    public BaseJsonVo delGroup(MallGroupProductEntity mallGroupProductEntity, MallGroupProductEntityKey mallGroupProductEntityKey) {
        mallGroupProductEntity.setProId(mallGroupProductEntityKey.getProId());
        mallGroupProductEntity.setGroupId(mallGroupProductEntityKey.getGroupId());
        BaseJsonVo sr = this.groupService.delGroupProduct(mallGroupProductEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallGroupProductEntity.getGroupId(), Integer.valueOf(2));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }
}

