/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.shoppingcart.MallShoppingRuleEntity;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingRuleInterface;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shoppingRule"})
public class MallShoppingRuleController
extends BaseController {
    @Autowired
    private MallShoppingRuleInterface shoppingRuleInterface;

    @RequestMapping(value={"getShoppingRule"})
    public MallShoppingRuleEntity getShoppingRule(Integer shoppingRuleId) {
        return this.shoppingRuleInterface.select(shoppingRuleId);
    }

    @RequestMapping(value={"getShoppingRuleList"})
    public Map<String, Object> getShoppingRuleList(MallShoppingRuleEntity ruleEntity) throws AuthorizeException {
        List orderSourceEnums = OrderSourceEnum.getList();
        List ruleListVos = this.shoppingRuleInterface.list(ruleEntity);
        HashedMap map = new HashedMap();
        map.put("orderSource", orderSourceEnums);
        map.put("ruleListVos", ruleListVos);
        return map;
    }

    @RequestMapping(value={"deleteShoppingRule"})
    public BaseJsonVo deleteShoppingRule(Integer shoppingRuleId) throws AuthorizeException {
        return this.shoppingRuleInterface.delete(shoppingRuleId);
    }

    @RequestMapping(value={"saveShoppingRule"})
    public BaseJsonVo saveShoppingRule(MallShoppingRuleEntity ruleEntity) throws AuthorizeException {
        return this.shoppingRuleInterface.save(ruleEntity);
    }
}

