/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sms;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.apiinvoke.message.GroupRuleInvoke;
import cc.lechun.apiinvoke.message.SmsInvoke;
import cc.lechun.apiinvoke.message.TaskMessageInvoke;
import cc.lechun.baseservice.model.sms.AppDTO;
import cc.lechun.baseservice.model.sms.AppQueryDTO;
import cc.lechun.baseservice.model.sms.GroupDetailEntity;
import cc.lechun.baseservice.model.sms.MessageDTO;
import cc.lechun.baseservice.model.sms.TagRuleDo;
import cc.lechun.baseservice.model.sms.TaskEntity;
import cc.lechun.baseservice.model.sms.TaskQueryVo;
import cc.lechun.baseservice.model.sms.TaskVo;
import cc.lechun.baseservice.model.sms.TemplateDTO;
import cc.lechun.baseservice.model.sms.TemplateQueryDTO;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.model.sms.UserGroupQueryVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.UploadDataListener;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/task"})
public class SmsController
extends BaseController {
    @Autowired
    private SmsInvoke smsInvoke;
    @Autowired
    private TaskMessageInvoke taskMessageInvoke;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private GroupRuleInvoke groupRuleInvoke;

    @RequestMapping(value={"/getTagTypeRuleList"})
    public BaseJsonVo getTagTypeRuleList() {
        return this.groupRuleInvoke.getTagTypeRuleList();
    }

    @RequestMapping(value={"/getTagList"})
    public BaseJsonVo getTagList() {
        return this.groupRuleInvoke.getTagList();
    }

    @RequestMapping(value={"/getRuleList"})
    public BaseJsonVo getRuleList(Integer groupId) {
        return this.groupRuleInvoke.getRuleList(groupId);
    }

    @RequestMapping(value={"/deleteGroupRule"})
    public BaseJsonVo deleteGroupRule(Integer groupId) {
        return this.groupRuleInvoke.deleteGroupRule(groupId);
    }

    @RequestMapping(value={"/deleteRule"})
    public BaseJsonVo deleteRule(int ruleId) {
        return this.groupRuleInvoke.deleteRule(ruleId);
    }

    @RequestMapping(value={"/saveGroupRule"})
    public BaseJsonVo saveGroupRule(@Valid TagRuleDo tagRuleDo, BindingResult result) {
        if (result.hasErrors()) {
            Iterator iterator = result.getAllErrors().iterator();
            String message = "";
            while (iterator.hasNext()) {
                ObjectError objectError = (ObjectError)iterator.next();
                this.log.error("\u9519\u8bef\u4fe1\u606f:{},{}", (Object)objectError.getCode(), (Object)objectError.getDefaultMessage());
                message = message + objectError.getDefaultMessage() + ",";
            }
            return BaseJsonVo.error((String)message);
        }
        return this.groupRuleInvoke.saveGroupRule(tagRuleDo);
    }

    @RequestMapping(value={"/saveGroupRuleList"})
    public BaseJsonVo saveGroupRuleList(String list) throws UnsupportedEncodingException {
        String items = URLDecoder.decode(list, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List parmList = JsonUtils.getListByArray(TagRuleDo.class, (String)items);
        return this.groupRuleInvoke.saveGroupRuleList(parmList);
    }

    @RequestMapping(value={"/updateGroupNum"})
    public BaseJsonVo updateGroupNum(int groupId) {
        return this.taskMessageInvoke.updateGroupNum(groupId);
    }

    @RequestMapping(value={"/deleteTask"})
    public BaseJsonVo deleteTask(int taskId) {
        return this.taskMessageInvoke.deleteTask(taskId);
    }

    @RequestMapping(value={"/deleteGroup"})
    public BaseJsonVo deleteGroup(int groupId) {
        return this.taskMessageInvoke.deleteGroup(groupId);
    }

    @RequestMapping(value={"/upload"})
    public BaseJsonVo upload(@RequestParam(value="file") MultipartFile file, Integer groupId) {
        try {
            if (file.isEmpty()) {
                return BaseJsonVo.error((String)"\u6587\u4ef6\u4e3a\u7a7a");
            }
            EasyExcel.read((InputStream)file.getInputStream(), GroupDetailEntity.class, (ReadListener)new UploadDataListener(this.taskMessageInvoke, groupId)).sheet().doRead();
            return BaseJsonVo.success((Object)"\u5bfc\u5165\u6210\u529f");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.error((String)"\u5bfc\u5165\u5931\u8d25");
    }

    @RequestMapping(value={"/downLoad"})
    public void downLoad(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u5bfc\u5165\u6a21\u677f", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ArrayList list = new ArrayList();
        EasyExcel.write((OutputStream)response.getOutputStream(), GroupDetailEntity.class).sheet("\u6a21\u677f").doWrite(list);
    }

    @RequestMapping(value={"/getTaskParaList"})
    public BaseJsonVo getTaskParaList() {
        return this.taskMessageInvoke.getTaskParaList();
    }

    @RequestMapping(value={"/getTaskList"})
    public BaseJsonVo getTaskList(TaskQueryVo taskQueryVo) {
        BaseJsonVo result = this.taskMessageInvoke.getTaskList(taskQueryVo);
        PageInfo pageInfo = (PageInfo)result.getValue();
        List list = pageInfo.getList();
        if (list != null && list.size() > 0) {
            for (TaskVo taskVo : list) {
                if (!StringUtils.isNotEmpty((String)taskVo.getActiveNo())) continue;
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(taskVo.getActiveNo());
                taskVo.setActiveName(activeEntity == null ? "" : activeEntity.getActiveName());
            }
        }
        return result;
    }

    @RequestMapping(value={"/saveTask"})
    BaseJsonVo saveTask(TaskEntity task) {
        return this.taskMessageInvoke.saveTask(task);
    }

    @RequestMapping(value={"/auditTask"})
    BaseJsonVo auditTask(Integer taskId) {
        return this.taskMessageInvoke.auditTask(taskId);
    }

    @RequestMapping(value={"/cancel"})
    BaseJsonVo cancel(Integer taskId) {
        return this.taskMessageInvoke.cancelTask(taskId);
    }

    @RequestMapping(value={"/preview"})
    BaseJsonVo preview(Integer taskId, String account) {
        return this.taskMessageInvoke.preview(taskId, account);
    }

    @RequestMapping(value={"/getUserGroupList"})
    BaseJsonVo getUserGroupList(UserGroupQueryVo userGroupQueryVo) {
        return this.taskMessageInvoke.getUserGroupList(userGroupQueryVo);
    }

    @RequestMapping(value={"/saveGroup"})
    BaseJsonVo saveGroup(UserGroupEntity userGroupEntity) {
        return this.taskMessageInvoke.saveGroup(userGroupEntity);
    }

    @RequestMapping(value={"/getAppList"})
    public BaseJsonVo getAppList(AppQueryDTO appQueryDTO) {
        return this.smsInvoke.getAppList(appQueryDTO);
    }

    @RequestMapping(value={"/saveApp"})
    public BaseJsonVo saveApp(AppDTO appDTO) {
        return this.smsInvoke.saveApp(appDTO);
    }

    @RequestMapping(value={"/getTemplateList"})
    public BaseJsonVo getTemplateList(TemplateQueryDTO templateQueryDTO) {
        return this.smsInvoke.getTemplateList(templateQueryDTO);
    }

    @RequestMapping(value={"/saveTemplate"})
    public BaseJsonVo saveTemplate(TemplateDTO message) {
        return this.smsInvoke.saveTemplate(message);
    }

    @PostMapping(value={"/send"})
    public BaseJsonVo send(MessageDTO message) {
        this.log.info("\u77ed\u4fe1\u53c2\u6570:" + message.toString());
        return this.smsInvoke.send(message);
    }

    @RequestMapping(value={"/getMongateBalance"})
    public BaseJsonVo getMongateBalance() {
        return this.smsInvoke.getMongateBalance();
    }
}

