/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sys;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallResourceEntity;
import cc.lechun.mall.entity.user.MallResourceGroupEntity;
import cc.lechun.mall.iservice.user.SysResourceInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/resource"})
public class ResourceController
extends BaseController {
    @Autowired
    private SysResourceInterface sysResourceInterface;

    @RequestMapping(value={"/saveOrUpdateMallResource"})
    @ResponseBody
    public BaseJsonVo saveOrUpdateMallResource(MallResourceEntity mallResourceEntity) throws AuthorizeException {
        if (mallResourceEntity.getResourceId() != null && mallResourceEntity.getResourceId() != 0) {
            return this.sysResourceInterface.updateMallResource(mallResourceEntity);
        }
        return this.sysResourceInterface.saveMallResource(mallResourceEntity);
    }

    @RequestMapping(value={"/getMallParentResourceList"})
    @ResponseBody
    public BaseJsonVo getMallParentResourceList(PageForm pageForm, String resourceName, Integer resourceType, Integer roleId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.sysResourceInterface.getMallParentResourceList(pageForm.getCurrentPage(), pageForm.getPageSize(), resourceName, resourceType, roleId));
    }

    @RequestMapping(value={"/getMallleafResourceList"})
    @ResponseBody
    public BaseJsonVo getMallleafResourceList(PageForm pageForm, Integer resourceId, Integer roleId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.sysResourceInterface.getMallleafResourceList(pageForm.getCurrentPage(), pageForm.getPageSize(), resourceId.intValue(), roleId));
    }

    @RequestMapping(value={"/getResourceGroups"})
    @ResponseBody
    public BaseJsonVo getResourceGroups(PageForm pageForm, Integer resourceId) {
        return BaseJsonVo.success((Object)this.sysResourceInterface.getResourceGroupList(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), resourceId));
    }

    @RequestMapping(value={"/getResourceGroupUsers"})
    @ResponseBody
    public BaseJsonVo getResourceGroupUsers(Integer groupId) {
        return this.sysResourceInterface.getResourceGroupUsers(groupId);
    }

    @RequestMapping(value={"/saveResourceGroups"})
    @ResponseBody
    public BaseJsonVo saveResourceGroups(MallResourceGroupEntity entity) {
        return BaseJsonVo.success((Object)this.sysResourceInterface.saveResourceGroup(entity));
    }

    @RequestMapping(value={"/saveResourceGroupUsers"})
    @ResponseBody
    public BaseJsonVo saveResourceGroupUsers(Integer groupId, String userIds) {
        if (userIds == null) {
            userIds = "";
        }
        return BaseJsonVo.success((Object)this.sysResourceInterface.saveResourceGroupUser(groupId, userIds.split(",")));
    }

    @RequestMapping(value={"/saveResourceGroupRelations"})
    @ResponseBody
    public BaseJsonVo saveResourceGroupRelations(Integer groupId, String relations) {
        if (relations == null) {
            relations = "";
        }
        return BaseJsonVo.success((Object)this.sysResourceInterface.saveResourceGroupRelations(groupId, relations.split(",")));
    }

    @RequestMapping(value={"/delResourceGroup"})
    @ResponseBody
    public BaseJsonVo delResourceGroup(Integer groupId) {
        return BaseJsonVo.success((Object)this.sysResourceInterface.delResourceGroup(groupId));
    }

    @RequestMapping(value={"/getAllResourceGroups"})
    @ResponseBody
    public BaseJsonVo getAllResourceGroups(Integer resourceId) {
        return BaseJsonVo.success((Object)this.sysResourceInterface.getAllResourceGroups(resourceId));
    }

    @RequestMapping(value={"/getResourceVisibleGroups"})
    @ResponseBody
    public BaseJsonVo getResourceVisibleGroups(Integer resourceId, Integer groupId) {
        return BaseJsonVo.success((Object)this.sysResourceInterface.getResourceVisibleGroups(resourceId, groupId));
    }
}

