/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sys;

import cc.lechun.apiinvoke.maindata.MainDataInvoke;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.user.MallUserEntityVo;
import cc.lechun.mall.entity.user.MallUserRoleEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController
extends BaseController {
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    MainDataInvoke mainDataInvoke;
    @Autowired
    IPeriodService periodService;
    @Autowired
    IOrgPermittedUsersService orgPermittedUsersService;

    @RequestMapping(value={"/getMallUserList"})
    @ResponseBody
    public BaseJsonVo getMallUserList(PageForm pageForm, String userName, String userNick) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        PageInfo pageInfo = this.sysUserInterface.getMallUserList(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), userName, userNick, user.getPlatformGroupId());
        pageInfo.getList().forEach(MallUserEntityVo2 -> {
            MallUserEntityVo2.setPlatformGroupName(this.getUserValidPlatFormGroupName(MallUserEntityVo2.getPlatformGroupId()));
            MallUserEntityVo2.setPlatformNames(this.getUserPlatFormNames(MallUserEntityVo2.getPlatformGroupId().intValue(), MallUserEntityVo2.getPlatformId()));
        });
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/saveOrUpdateMallUser"})
    @ResponseBody
    public BaseJsonVo saveMallUser(MallUserEntityVo mallUserEntity) throws AuthorizeException {
        if (mallUserEntity.getPlatformIds() != null && mallUserEntity.getPlatformIds().size() > 0) {
            mallUserEntity.setPlatformId(String.join((CharSequence)",", mallUserEntity.getPlatformIds()));
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserId())) {
            return this.sysUserInterface.saveMallUser((MallUserEntity)mallUserEntity);
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            mallUserEntity.setPassword(null);
        }
        return this.sysUserInterface.updateMallUser((MallUserEntity)mallUserEntity);
    }

    @RequestMapping(value={"/updatePassWord"})
    @ResponseBody
    public BaseJsonVo updatePassWord(String oldPassword, String newPassword) throws AuthorizeException {
        if (StringUtil.isEmpty((String)oldPassword) || StringUtil.isEmpty((String)newPassword)) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MallUserEntity user = this.sysUserInterface.getMallUser(this.getUser().getUserId());
        if (!MD5.sign((String)"lechun", (String)oldPassword).equals(user.getPassword())) {
            return BaseJsonVo.paramError((String)"\u8001\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        user.setPassword(newPassword);
        return this.sysUserInterface.updateMallUser(user);
    }

    @RequestMapping(value={"/getMallUserRoleList"})
    @ResponseBody
    public BaseJsonVo getMallUserRoleList(PageForm pageForm, String userId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.sysUserInterface.getMallUserRoleList(pageForm.getCurrentPage(), pageForm.getPageSize(), userId));
    }

    @RequestMapping(value={"/saveUserRole"})
    @ResponseBody
    public BaseJsonVo saveUserRole(@RequestBody HashMap map) throws AuthorizeException {
        List ls;
        if (map.get("userId") == null) {
            return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
        }
        String userId = map.get("userId").toString();
        if (map.get("roleIds") != null && (ls = (List)map.get("roleIds")) != null && ls.size() > 0) {
            ls.forEach(o -> {
                MallUserRoleEntity mallUserRoleEntity = new MallUserRoleEntity();
                mallUserRoleEntity.setRoleId((Integer)o.get("roleId"));
                mallUserRoleEntity.setUserId(userId);
                this.sysUserInterface.saveUserRole(mallUserRoleEntity);
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/deleteUserRole"})
    @ResponseBody
    public BaseJsonVo deleteUserRole(int id) {
        this.sysUserInterface.deleteUserRole(id);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getMainDataUsers"})
    @ResponseBody
    public BaseJsonVo getMainDataUsers(String userName, String userNick) {
        if (StringUtils.isEmpty((String)userName)) {
            return BaseJsonVo.error((String)"\u8bf7\u5728\u7528\u6237\u767b\u5f55\u540d\u7684\u5730\u65b9\u8f93\u5165\u4e00\u7ec4classId\uff0c\u9017\u53f7\u9694\u5f00");
        }
        if (StringUtils.isEmpty((String)userNick)) {
            return BaseJsonVo.error((String)"\u8bf7\u5728\u7528\u6237\u6635\u79f0\u7684\u5730\u65b9\u8f93\u5165\u4e00\u7ec4\u7528\u6237ID\uff0c\u9017\u53f7\u9694\u5f00");
        }
        String[] userIds = userNick.split(",");
        this.orgPermittedUsersService.importData(Integer.valueOf(userName), userIds);
        return BaseJsonVo.success(null);
    }

    @RequestMapping(value={"/getUserListForDorpbox"})
    @ResponseBody
    public BaseJsonVo getUserListForDorpbox(String classId, Integer type) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        type = type == null ? 0 : type;
        return this.sysUserInterface.getBaseUserList(type.intValue(), user.getUserId());
    }

    @RequestMapping(value={"/getDeparts"})
    @ResponseBody
    public BaseJsonVo getDeparts() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.sysUserInterface.getDeparts());
    }
}

