/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.collage;

import cc.lechun.active.entity.collage.CollageConfigEntity;
import cc.lechun.active.entity.collage.CollageConfigProductEntity;
import cc.lechun.active.entity.collage.CollageConfigVo;
import cc.lechun.active.entity.collage.CollageDiscountEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.collage.CollageInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/collageManage"})
public class CollageController
extends BaseController {
    @Autowired
    private CollageInterface collageService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private OssService ossService;

    @RequestMapping(value={"getCollageConfigList"})
    public BaseJsonVo getCollageList(PageForm pageForm) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", this.collageService.getCmsCollageActiveList(pageForm, user.getPlatformGroupId().intValue()));
        Integer[] activeTypes = null;
        map.put("activeData", this.activeInterface.getOptionActiveList(this.getUser().getPlatformGroupId(), activeTypes));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"saveCollageConfig"})
    public BaseJsonVo saveCollageConfig(CollageConfigVo collageConfig) {
        return this.collageService.saveCollageConfig(collageConfig);
    }

    @RequestMapping(value={"uploadCollageConfigBanner"})
    public BaseJsonVo uploadCollageConfigBanner(MultipartFile file) throws AuthorizeException, IOException {
        if (file == null) {
            return BaseJsonVo.error((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247");
        }
        String path = AliyunOSSDir.TEMP_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + file.getOriginalFilename();
        this.ossService.uploadFile(path, file.getInputStream());
        return BaseJsonVo.success((Object)this.ossService.getImageResoure(path));
    }

    @RequestMapping(value={"getCollageProductConfigList"})
    public BaseJsonVo getCollageProductConfigList(String activeNo) throws AuthorizeException {
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("selectList", this.collageService.getCollageProductConfigList(activeNo));
        MallUserEntity user = this.getUser();
        map.put("allList", this.collageService.getAllProductList(user.getPlatformGroupId(), false));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"saveCollageProductConfigList"})
    public BaseJsonVo saveCollageProductConfig(String list) throws UnsupportedEncodingException {
        return this.collageService.saveCollageProductConfig(list);
    }

    @RequestMapping(value={"saveCollageProductConfig"})
    public BaseJsonVo saveCollageProductConfig(CollageConfigProductEntity collageConfigProduct) {
        return this.collageService.saveCollageProductConfig(collageConfigProduct);
    }

    @RequestMapping(value={"deleteCollageProductConfig"})
    public BaseJsonVo deleteCollageProductConfig(String id) {
        return this.collageService.deleteCollageProductConfig(id);
    }

    @RequestMapping(value={"getCollageDiscountConfigList"})
    public BaseJsonVo getCollageDiscountConfigList(String activeNo) {
        return this.collageService.getCollageDiscountConfigList(activeNo);
    }

    @RequestMapping(value={"saveCollageDiscountConfig"})
    public BaseJsonVo saveCollageDiscountConfig(CollageDiscountEntity collageDiscount) {
        return this.collageService.saveCollageDiscountConfig(collageDiscount);
    }

    @RequestMapping(value={"setCollageConfigProduct"})
    public BaseJsonVo setCollageConfigProduct(CollageConfigEntity configEntity) {
        return this.collageService.setCollageConfigProduct(configEntity);
    }

    @RequestMapping(value={"deleteCollageDiscountConfig"})
    public BaseJsonVo deleteCollageDiscountConfig(String id) {
        return this.collageService.deleteCollageDiscountConfig(id);
    }
}

