/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.bill;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.bill.MallBillResultVo;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPlatformPayTypeEntity;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallPlatformPayTypeInterface;
import cc.lechun.mall.service.pay.bill.bankBill.CMBBankBillService;
import cc.lechun.mall.service.pay.cmbRefundTestService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"cmbBankBill"})
public class CMBBankBillController
extends BaseController {
    static String fileUrl = System.getProperty("user.dir") + "/";
    @Autowired
    private CMBBankBillService cmbBankBillService;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private MallPlatformPayTypeInterface mallPlatformPayTypeInterface;
    @Autowired
    private cmbRefundTestService cmbRefundTestService;

    @RequestMapping(value={"getOrderBillInfo"})
    public BaseJsonVo getOrderBillInfo(PageForm pageForm, MallBillResultVo mallBillResultVo) {
        PageInfo orderBillInfo = this.cmbBankBillService.getOrderBillInfo(pageForm.getCurrentPage(), pageForm.getPageSize(), mallBillResultVo);
        return BaseJsonVo.success((Object)orderBillInfo);
    }

    @RequestMapping(value={"downloadBill"})
    public BaseJsonVo downloadBill() {
        String billType = "M01";
        BaseJsonVo result = new BaseJsonVo();
        int payTypeSubId = 0;
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
        if (mallPayTypeEntity != null) {
            payTypeSubId = mallPayTypeEntity.getPaytypeId();
        }
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(1, payTypeSubId);
        PayInputEntity pe = new PayInputEntity();
        if (platformPayTypeEntity != null) {
            pe.setPayKey(platformPayTypeEntity.getPayKey());
            pe.setAppId(platformPayTypeEntity.getAppid());
            pe.setBody(platformPayTypeEntity.getBody());
            pe.setMchId(platformPayTypeEntity.getMchId());
            pe.setTradeType(platformPayTypeEntity.getTradeType());
            pe.setDomain(platformPayTypeEntity.getDomain());
            pe.setAppName(platformPayTypeEntity.getAppName());
            pe.setPublicKey(platformPayTypeEntity.getPublicKey());
            pe.setRequestDomain(platformPayTypeEntity.getRequestDomain());
            pe.setCharset(platformPayTypeEntity.getCharset());
            pe.setSignType(platformPayTypeEntity.getSignType());
            pe.setReturnUrl(platformPayTypeEntity.getReturnUrl());
            pe.setNotifyUrl(platformPayTypeEntity.getNotifyUrl());
            pe.setSellerEmail(platformPayTypeEntity.getSellerEmail());
            pe.setDataFormat(platformPayTypeEntity.getDataFormat());
            pe.setTimeOut(platformPayTypeEntity.getTimeout().intValue());
            pe.setRefundCertFile(platformPayTypeEntity.getRefundCertFile());
            result = this.cmbBankBillService.downloadBill(pe, billType);
            if (!result.isSuccess()) {
                return result;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            Date date = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
            String dateStr = format.format(date);
            String fileName = "\u62db\u5546\u5bf9\u8d26\u5355" + dateStr + ".zip";
            String pathName = fileUrl + fileName;
            File storeFile = new File(pathName);
            this.cmbBankBillService.unZip(storeFile, fileUrl, null);
        }
        return result;
    }

    @RequestMapping(value={"readCsv"})
    public BaseJsonVo readCsv() {
        BaseJsonVo result = new BaseJsonVo();
        int i = this.cmbBankBillService.readCsv(null);
        if (i > 0) {
            this.cmbBankBillService.checkPayBillInfo(null);
            this.cmbBankBillService.checkRefundBillInfo(null);
        }
        return result;
    }

    @RequestMapping(value={"billResult"})
    public BaseJsonVo billResult(MallBillResultVo mallBillResultVo) {
        int i;
        BaseJsonVo result = new BaseJsonVo();
        String billType = "M01";
        if (mallBillResultVo != null && mallBillResultVo.getCreateTime() != null) {
            billType = "D01";
        }
        if ((i = this.cmbBankBillService.billResult(billType, mallBillResultVo)) <= 0) {
            if (i == -1) {
                result.setValue((Object)"\u6570\u636e\u5df2\u5b58\u5728");
            } else {
                result.setError("\u5bf9\u8d26\u5931\u8d25");
            }
        }
        return result;
    }

    @RequestMapping(value={"cmbRefund"})
    public BaseJsonVo cmbRefund(PayInputEntity inputEntity) {
        inputEntity.setPayKey("156152599871586");
        inputEntity.setRefundBillNo(inputEntity.getRefundBillNo());
        inputEntity.setCharset("UTF-8");
        inputEntity.setPublicKey("77imTNThUD7elDwy8zMLrp4CsEqalLmr");
        inputEntity.setSignType("MD5");
        BaseJsonVo jsonVo = new BaseJsonVo();
        jsonVo = this.cmbRefundTestService.refundQueryByCMB(inputEntity);
        this.log.info("============CMBBankBillController.cmbRefund=============jsonVo={}", (Object)JSON.toJSONString((Object)jsonVo));
        return jsonVo;
    }
}

